/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.DocumentReader;
import bluej.parser.JavaParser;
import bluej.parser.ParseUtils;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.IntersectionTypeEntity;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.entity.PositionedResolver;
import bluej.parser.entity.TparEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.UnresolvedArray;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.CommentNode;
import bluej.parser.nodes.ContainerNode;
import bluej.parser.nodes.DeclarationNode;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.ImportNode;
import bluej.parser.nodes.InnerNode;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.MethodBodyNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.nodes.PkgStmtNode;
import bluej.parser.nodes.TypeInnerNode;
import bluej.parser.symtab.Selection;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class EditorParser
extends JavaParser {
    protected Stack<JavaParentNode> scopeStack = new Stack();
    private ParsedTypeNode innermostType;
    private LocatableToken pcuStmtBegin;
    private ParsedCUNode pcuNode;
    private List<LocatableToken> commentQueue = new LinkedList<LocatableToken>();
    private List<LocatableToken> lastTypeSpec;
    private FieldNode lastField;
    private int arrayDecls;
    private String declaredPkg = "";
    private List<TypeParam> typeParams;
    private String lastTypeParamName;
    private List<List<LocatableToken>> lastTypeParBounds;
    private List<JavaEntity> extendedTypes;
    private List<JavaEntity> implementedTypes;
    private Document document;
    private boolean gotExtends = false;
    private boolean gotImplements = false;
    private boolean gotNewType = true;
    private Stack<List<LocatableToken>> newTypes = new Stack();
    private int currentModifiers = 0;

    protected EditorParser(Reader r, EntityResolver resolver) {
        super(r);
        this.pcuNode = new ParsedCUNode();
        this.pcuNode.setParentResolver(resolver);
    }

    public EditorParser(Document document) {
        super(new DocumentReader(document));
        this.document = document;
    }

    public EditorParser(Document document, Reader r, int line, int col, int pos, Stack<JavaParentNode> scopeStack) {
        super(r, line, col, pos);
        this.document = document;
        this.scopeStack = scopeStack;
        this.pcuNode = (ParsedCUNode)scopeStack.get(0);
    }

    public List<JavaEntity> getExtendedTypes() {
        return this.extendedTypes;
    }

    @Override
    protected void error(String msg, int beginLine, int beginColumn, int endLine, int endColumn) {
        if (this.document instanceof MoeSyntaxDocument) {
            MoeSyntaxDocument mdocument = (MoeSyntaxDocument)this.document;
            Element lineEl = mdocument.getDefaultRootElement().getElement(beginLine - 1);
            int position = lineEl.getStartOffset() + beginColumn - 1;
            if (endLine != beginLine) {
                lineEl = mdocument.getDefaultRootElement().getElement(endLine - 1);
            }
            int endPos = lineEl.getStartOffset() + endColumn - 1;
            mdocument.parseError(position, endPos - position, msg);
        }
    }

    @Override
    public void parseCU() {
        this.scopeStack.push(this.pcuNode);
        super.parseCU();
        this.scopeStack.pop();
        this.completedNode(this.pcuNode, 0, this.pcuNode.getSize());
    }

    protected int lineColToPosition(int line, int col) {
        if (this.document == null) {
            return 0;
        }
        return this.document.getDefaultRootElement().getElement(line - 1).getStartOffset() + col - 1;
    }

    private void endTopNode(LocatableToken token, boolean included) {
        int topPos = this.getTopNodeOffset();
        ParsedNode top = this.scopeStack.pop();
        int endPos = included ? this.lineColToPosition(token.getEndLine(), token.getEndColumn()) : this.lineColToPosition(token.getLine(), token.getColumn());
        top.resize(endPos - topPos);
        NodeTree.NodeAndPosition<ParsedNode> child = new NodeTree.NodeAndPosition<ParsedNode>(top, topPos, endPos - topPos);
        this.scopeStack.peek().childResized(null, topPos - top.getOffsetFromParent(), child);
        this.completedNode(top, topPos, endPos - topPos);
    }

    public void completedNode(ParsedNode node, int position, int size) {
        ListIterator<LocatableToken> i = this.commentQueue.listIterator();
        while (i.hasNext()) {
            LocatableToken token = i.next();
            int startpos = this.lineColToPosition(token.getLine(), token.getColumn());
            if (startpos < position || startpos >= position + size) continue;
            int endpos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
            CommentNode cn = new CommentNode(node, token);
            node.insertNode(cn, startpos - position, endpos - startpos);
            i.remove();
        }
    }

    protected void beginNode(int position) {
        ListIterator<LocatableToken> i = this.commentQueue.listIterator();
        while (i.hasNext()) {
            LocatableToken token = i.next();
            int startpos = this.lineColToPosition(token.getLine(), token.getColumn());
            int endpos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
            if (startpos >= position) break;
            i.remove();
            int topOffset = this.getTopNodeOffset();
            CommentNode cn = new CommentNode(this.scopeStack.peek(), token);
            this.scopeStack.peek().insertNode(cn, startpos - topOffset, endpos - startpos);
        }
    }

    protected int getTopNodeOffset() {
        Iterator i = this.scopeStack.iterator();
        if (!i.hasNext()) {
            return 0;
        }
        int rval = 0;
        i.next();
        while (i.hasNext()) {
            rval += ((JavaParentNode)i.next()).getOffsetFromParent();
        }
        return rval;
    }

    protected static String joinTokens(List<LocatableToken> tokens) {
        StringBuffer r = new StringBuffer();
        for (LocatableToken token : tokens) {
            r.append(token.getText());
        }
        return r.toString();
    }

    protected Reflective currentQuerySource() {
        ListIterator i = this.scopeStack.listIterator(this.scopeStack.size());
        while (i.hasPrevious()) {
            ParsedNode pn = (ParsedNode)i.previous();
            if (pn.getNodeType() != 1) continue;
            ParsedTypeNode ptn = (ParsedTypeNode)pn;
            return new ParsedReflective(ptn);
        }
        return null;
    }

    @Override
    protected void gotModifier(LocatableToken token) {
        switch (token.getType()) {
            case 40: {
                this.currentModifiers |= 0x400;
                break;
            }
            case 88: {
                this.currentModifiers |= 2;
                break;
            }
            case 89: {
                this.currentModifiers |= 1;
                break;
            }
            case 90: {
                this.currentModifiers |= 4;
                break;
            }
            case 39: {
                this.currentModifiers |= 0x10;
                break;
            }
            case 93: {
                this.currentModifiers |= 0x20;
                break;
            }
            case 41: {
                this.currentModifiers |= 0x800;
                break;
            }
            case 92: {
                this.currentModifiers |= 0x100;
                break;
            }
            case 65: {
                this.currentModifiers |= 8;
                break;
            }
        }
    }

    @Override
    protected void modifiersConsumed() {
        this.currentModifiers = 0;
    }

    @Override
    protected void beginPackageStatement(LocatableToken token) {
        this.pcuStmtBegin = token;
    }

    @Override
    protected void gotPackage(List<LocatableToken> pkgTokens) {
        super.gotPackage(pkgTokens);
        this.declaredPkg = EditorParser.joinTokens(pkgTokens);
    }

    @Override
    protected void gotImport(List<LocatableToken> tokens, boolean isStatic) {
        EntityResolver parentResolver = this.pcuNode.getParentResolver();
        if (parentResolver == null) {
            return;
        }
        if (isStatic) {
            TypeEntity tentity;
            int newSize;
            String memberName = tokens.get(newSize + 1).getText();
            ArrayList<LocatableToken> newList = new ArrayList<LocatableToken>(newSize);
            Iterator<LocatableToken> i = tokens.iterator();
            for (newSize = tokens.size() - 2; newSize > 0; --newSize) {
                newList.add(i.next());
            }
            JavaEntity entity = ParseUtils.getImportEntity(parentResolver, this.currentQuerySource(), newList);
            TypeEntity typeEntity = tentity = entity != null ? entity.resolveAsType() : null;
            if (tentity != null) {
                this.pcuNode.getImports().addStaticImport(memberName, tentity);
            }
        } else {
            String memberName = tokens.get(tokens.size() - 1).getText();
            JavaEntity entity = ParseUtils.getImportEntity(parentResolver, this.currentQuerySource(), tokens);
            if (entity != null) {
                this.pcuNode.getImports().addNormalImport(memberName, entity);
            }
        }
    }

    @Override
    protected void gotWildcardImport(List<LocatableToken> tokens, boolean isStatic) {
        EntityResolver parentResolver = this.pcuNode.getParentResolver();
        if (parentResolver == null) {
            return;
        }
        JavaEntity importEntity = ParseUtils.getImportEntity(parentResolver, this.currentQuerySource(), tokens);
        if (importEntity == null) {
            return;
        }
        if (!isStatic) {
            this.pcuNode.getImports().addWildcardImport(importEntity);
        } else {
            TypeEntity tentity = importEntity.resolveAsType();
            if (tentity != null) {
                this.pcuNode.getImports().addStaticWildcardImport(tentity);
            }
        }
    }

    @Override
    protected void gotDeclBegin(LocatableToken token) {
        this.pcuStmtBegin = token;
        DeclarationNode placeHolder = new DeclarationNode(this.scopeStack.peek());
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.scopeStack.peek().insertNode(placeHolder, insPos - curOffset, 0);
        this.scopeStack.push(placeHolder);
    }

    @Override
    protected void endDecl(LocatableToken token) {
        this.scopeStack.pop().remove();
    }

    @Override
    protected void gotTypeDef(LocatableToken firstToken, int tdType) {
        this.endDecl(firstToken);
        Reflective ref = this.currentQuerySource();
        String prefix = ref != null ? ref.getName() + '$' : (this.declaredPkg.length() == 0 ? "" : this.declaredPkg + ".");
        this.innermostType = new ParsedTypeNode(this.scopeStack.peek(), this.innermostType, tdType, prefix, this.currentModifiers);
        int curOffset = this.getTopNodeOffset();
        LocatableToken hidden = firstToken.getHiddenBefore();
        if (hidden != null && hidden.getType() == 61) {
            firstToken = hidden;
            this.innermostType.setCommentAttached(true);
        }
        int insPos = this.lineColToPosition(firstToken.getLine(), firstToken.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(this.innermostType, insPos - curOffset, 0);
        this.scopeStack.push(this.innermostType);
        this.initializeTypeExtras();
    }

    public final void initializeTypeExtras() {
        this.typeParams = new LinkedList<TypeParam>();
        this.extendedTypes = new LinkedList<JavaEntity>();
        this.implementedTypes = new LinkedList<JavaEntity>();
    }

    @Override
    protected void gotMethodTypeParamsBegin() {
        this.typeParams = new LinkedList<TypeParam>();
    }

    @Override
    protected void gotTypeDefName(LocatableToken nameToken) {
        ParsedTypeNode tnode = (ParsedTypeNode)this.scopeStack.peek();
        tnode.setName(nameToken.getText());
    }

    @Override
    protected void gotTypeParam(LocatableToken idToken) {
        if (this.lastTypeParamName != null) {
            this.typeParams.add(new TypeParam(this.lastTypeParamName, this.lastTypeParBounds));
        }
        this.lastTypeParamName = idToken.getText();
        this.lastTypeParBounds = new ArrayList<List<LocatableToken>>();
    }

    @Override
    protected void gotTypeParamBound(List<LocatableToken> tokens) {
        this.lastTypeParBounds.add(tokens);
        this.typeParams.add(new TypeParam(this.lastTypeParamName, this.lastTypeParBounds));
    }

    public final List<TparEntity> getTparList(EntityResolver resolver) {
        if (this.typeParams == null) {
            return null;
        }
        if (this.lastTypeParamName != null) {
            this.typeParams.add(new TypeParam(this.lastTypeParamName, this.lastTypeParBounds));
            this.lastTypeParamName = null;
        }
        Reflective querySource = this.currentQuerySource();
        ArrayList<TparEntity> rlist = new ArrayList<TparEntity>(this.typeParams.size());
        for (TypeParam tpar : this.typeParams) {
            ArrayList<JavaEntity> bounds = new ArrayList<JavaEntity>(tpar.bounds.size());
            for (List<LocatableToken> boundTokens : tpar.bounds) {
                bounds.add(ParseUtils.getTypeEntity(resolver, querySource, boundTokens));
            }
            JavaEntity boundsEnt = IntersectionTypeEntity.getIntersectionEntity(bounds, this.scopeStack.peek());
            rlist.add(new TparEntity(tpar.name, boundsEnt));
        }
        return rlist;
    }

    @Override
    protected void beginTypeBody(LocatableToken token) {
        ParsedTypeNode top = (ParsedTypeNode)this.scopeStack.peek();
        top.setTypeParams(this.getTparList(top));
        top.setExtendedTypes(this.extendedTypes);
        top.setImplementedTypes(this.implementedTypes);
        this.gotExtends = false;
        this.gotImplements = false;
        TypeInnerNode bodyNode = new TypeInnerNode(this.scopeStack.peek());
        bodyNode.setInner(true);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        top.insertInner(bodyNode, insPos - curOffset, 0);
        this.scopeStack.push(bodyNode);
    }

    @Override
    protected void beginForLoop(LocatableToken token) {
        ContainerNode loopNode = new ContainerNode(this.scopeStack.peek(), 3);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
        this.scopeStack.push(loopNode);
    }

    @Override
    protected void beginForLoopBody(LocatableToken token) {
        if (token.getType() != 99) {
            InnerNode loopNode = new InnerNode(this.scopeStack.peek());
            loopNode.setInner(true);
            int curOffset = this.getTopNodeOffset();
            int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
            this.beginNode(insPos);
            this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
            this.scopeStack.push(loopNode);
        }
    }

    @Override
    protected void endForLoopBody(LocatableToken token, boolean included) {
        if (this.scopeStack.peek().getNodeType() != 3) {
            this.endTopNode(token, false);
        }
    }

    @Override
    protected void beginWhileLoop(LocatableToken token) {
        ContainerNode loopNode = new ContainerNode(this.scopeStack.peek(), 3);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
        this.scopeStack.push(loopNode);
    }

    @Override
    protected void beginWhileLoopBody(LocatableToken token) {
        if (token.getType() != 99) {
            InnerNode loopNode = new InnerNode(this.scopeStack.peek());
            loopNode.setInner(true);
            int curOffset = this.getTopNodeOffset();
            int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
            this.beginNode(insPos);
            this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
            this.scopeStack.push(loopNode);
        }
    }

    @Override
    protected void endWhileLoopBody(LocatableToken token, boolean included) {
        if (this.scopeStack.peek().getNodeType() != 3) {
            this.endTopNode(token, false);
        }
    }

    @Override
    protected void beginDoWhile(LocatableToken token) {
        ContainerNode loopNode = new ContainerNode(this.scopeStack.peek(), 3);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
        this.scopeStack.push(loopNode);
    }

    @Override
    protected void beginDoWhileBody(LocatableToken token) {
        if (token.getType() != 99) {
            InnerNode loopNode = new InnerNode(this.scopeStack.peek());
            loopNode.setInner(true);
            int curOffset = this.getTopNodeOffset();
            int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
            this.beginNode(insPos);
            this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
            this.scopeStack.push(loopNode);
        }
    }

    @Override
    protected void endDoWhileBody(LocatableToken token, boolean included) {
        if (this.scopeStack.peek().getNodeType() != 3) {
            this.endTopNode(token, false);
        }
    }

    @Override
    protected void beginIfStmt(LocatableToken token) {
        ContainerNode loopNode = new ContainerNode(this.scopeStack.peek(), 4);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
        this.scopeStack.push(loopNode);
    }

    @Override
    protected void beginIfCondBlock(LocatableToken token) {
        if (token.getType() != 99) {
            InnerNode loopNode = new InnerNode(this.scopeStack.peek());
            loopNode.setInner(true);
            int curOffset = this.getTopNodeOffset();
            int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
            this.beginNode(insPos);
            this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
            this.scopeStack.push(loopNode);
        }
    }

    @Override
    protected void endIfCondBlock(LocatableToken token, boolean included) {
        if (this.scopeStack.peek().getNodeType() != 4) {
            this.endTopNode(token, false);
        }
    }

    @Override
    protected void endIfStmt(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void beginSwitchStmt(LocatableToken token) {
        this.beginIfStmt(token);
    }

    @Override
    protected void beginSwitchBlock(LocatableToken token) {
        InnerNode loopNode = new InnerNode(this.scopeStack.peek());
        loopNode.setInner(true);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(loopNode, insPos - curOffset, 0);
        this.scopeStack.push(loopNode);
    }

    @Override
    protected void endSwitchBlock(LocatableToken token) {
        this.endTopNode(token, false);
    }

    @Override
    protected void endSwitchStmt(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void beginTryCatchSmt(LocatableToken token) {
        ContainerNode tryNode = new ContainerNode(this.scopeStack.peek(), 4);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(tryNode, insPos - curOffset, 0);
        this.scopeStack.push(tryNode);
    }

    @Override
    protected void beginTryBlock(LocatableToken token) {
        InnerNode tryBlockNode = new InnerNode(this.scopeStack.peek());
        tryBlockNode.setInner(true);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(tryBlockNode, insPos - curOffset, 0);
        this.scopeStack.push(tryBlockNode);
    }

    @Override
    protected void endTryBlock(LocatableToken token, boolean included) {
        this.endTopNode(token, false);
    }

    @Override
    protected void endTryCatchStmt(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void beginStmtblockBody(LocatableToken token) {
        int insPos;
        int curOffset = this.getTopNodeOffset();
        if (!this.scopeStack.peek().isContainer()) {
            ContainerNode blockNode = new ContainerNode(this.scopeStack.peek(), 0);
            blockNode.setInner(false);
            insPos = this.lineColToPosition(token.getLine(), token.getColumn());
            this.beginNode(insPos);
            this.scopeStack.peek().insertNode(blockNode, insPos - curOffset, 0);
            this.scopeStack.push(blockNode);
            curOffset = insPos;
        }
        InnerNode blockInner = new InnerNode(this.scopeStack.peek());
        blockInner.setInner(true);
        insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(blockInner, insPos - curOffset, 0);
        this.scopeStack.push(blockInner);
    }

    @Override
    protected void endStmtblockBody(LocatableToken token, boolean included) {
        this.endTopNode(token, false);
        if (this.scopeStack.peek().getNodeType() == 0) {
            this.endTopNode(token, included);
        }
    }

    @Override
    protected void beginSynchronizedBlock(LocatableToken token) {
        ContainerNode tryNode = new ContainerNode(this.scopeStack.peek(), 0);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getLine(), token.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(tryNode, insPos - curOffset, 0);
        this.scopeStack.push(tryNode);
    }

    @Override
    protected void beginInitBlock(LocatableToken first, LocatableToken lcurly) {
        this.endDecl(first);
        int curOffset = this.getTopNodeOffset();
        ContainerNode blockNode = new ContainerNode(this.scopeStack.peek(), 0);
        blockNode.setInner(false);
        int insPos = this.lineColToPosition(first.getLine(), first.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(blockNode, insPos - curOffset, 0);
        this.scopeStack.push(blockNode);
        curOffset = insPos;
        InnerNode blockInner = new InnerNode(this.scopeStack.peek());
        blockInner.setInner(true);
        insPos = this.lineColToPosition(lcurly.getEndLine(), lcurly.getEndColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(blockInner, insPos - curOffset, 0);
        this.scopeStack.push(blockInner);
    }

    @Override
    protected void endInitBlock(LocatableToken rcurly, boolean included) {
        this.endStmtblockBody(rcurly, included);
    }

    @Override
    protected void beginElement(LocatableToken token) {
        this.pcuStmtBegin = token;
    }

    @Override
    protected void endTypeBody(LocatableToken token, boolean included) {
        this.endTopNode(token, false);
    }

    @Override
    protected void gotTypeDefEnd(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
        this.innermostType = this.innermostType.getContainingClass();
        this.gotExtends = false;
        this.gotImplements = false;
    }

    @Override
    protected void endForLoop(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void endWhileLoop(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void endDoWhile(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void gotPackageSemi(LocatableToken token) {
        Selection s = new Selection(this.pcuStmtBegin.getLine(), this.pcuStmtBegin.getColumn());
        s.extendEnd(token.getLine(), token.getColumn() + token.getLength());
        int startpos = this.lineColToPosition(s.getLine(), s.getColumn());
        int endpos = this.lineColToPosition(s.getEndLine(), s.getEndColumn());
        PkgStmtNode psn = new PkgStmtNode(this.pcuNode);
        this.beginNode(startpos);
        this.pcuNode.insertNode(psn, startpos, endpos - startpos);
        this.completedNode(psn, startpos, endpos - startpos);
    }

    @Override
    protected void gotImportStmtSemi(LocatableToken token) {
        Selection s = new Selection(this.pcuStmtBegin.getLine(), this.pcuStmtBegin.getColumn());
        s.extendEnd(token.getLine(), token.getColumn() + token.getLength());
        int startpos = this.lineColToPosition(s.getLine(), s.getColumn());
        int endpos = this.lineColToPosition(s.getEndLine(), s.getEndColumn());
        ImportNode cn = new ImportNode(this.pcuNode);
        cn.setComplete(true);
        this.beginNode(startpos);
        this.pcuNode.insertNode(cn, startpos, endpos - startpos);
        this.completedNode(cn, startpos, endpos - startpos);
    }

    @Override
    public void gotComment(LocatableToken token) {
        this.commentQueue.add(token);
    }

    @Override
    protected void gotConstructorDecl(LocatableToken token, LocatableToken hiddenToken) {
        this.endDecl(token);
        LocatableToken start = this.pcuStmtBegin;
        String jdcomment = null;
        if (hiddenToken != null) {
            start = hiddenToken;
            jdcomment = hiddenToken.getText();
        }
        MethodNode pnode = new MethodNode(this.scopeStack.peek(), token.getText(), jdcomment);
        pnode.setModifiers(this.currentModifiers);
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(start.getLine(), start.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(pnode, insPos - curOffset, 0);
        this.scopeStack.push(pnode);
    }

    @Override
    protected void gotMethodDeclaration(LocatableToken token, LocatableToken hiddenToken) {
        this.endDecl(token);
        LocatableToken start = this.pcuStmtBegin;
        String jdcomment = null;
        if (hiddenToken != null) {
            start = hiddenToken;
            jdcomment = hiddenToken.getText();
        }
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(start.getLine(), start.getColumn());
        MethodNode pnode = new MethodNode(this.scopeStack.peek(), token.getText(), jdcomment);
        JavaEntity returnType = ParseUtils.getTypeEntity(pnode, this.currentQuerySource(), this.lastTypeSpec);
        pnode.setReturnType(returnType);
        pnode.setModifiers(this.currentModifiers);
        pnode.setTypeParams(this.getTparList(pnode));
        this.typeParams = null;
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(pnode, insPos - curOffset, 0);
        this.scopeStack.push(pnode);
    }

    @Override
    protected void gotMethodParameter(LocatableToken token, LocatableToken ellipsisToken) {
        JavaEntity paramType = ParseUtils.getTypeEntity(this.scopeStack.peek(), this.currentQuerySource(), this.lastTypeSpec);
        if (paramType == null) {
            return;
        }
        while (this.arrayDecls-- > 0) {
            paramType = new UnresolvedArray(paramType);
        }
        MethodNode mNode = (MethodNode)this.scopeStack.peek();
        if (ellipsisToken != null) {
            mNode.setVarArgs(true);
            paramType = new UnresolvedArray(paramType);
        }
        mNode.addParameter(token.getText(), paramType);
    }

    @Override
    protected void endMethodDecl(LocatableToken token, boolean included) {
        MethodNode mNode = (MethodNode)this.scopeStack.peek();
        mNode.setComplete(included);
        this.endTopNode(token, included);
        TypeInnerNode topNode = (TypeInnerNode)this.scopeStack.peek();
        topNode.methodAdded(mNode);
    }

    @Override
    protected void beginMethodBody(LocatableToken token) {
        MethodBodyNode pnode = new MethodBodyNode(this.scopeStack.peek());
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(pnode, insPos - curOffset, 0);
        this.scopeStack.push(pnode);
    }

    @Override
    protected void endMethodBody(LocatableToken token, boolean included) {
        this.scopeStack.peek().setComplete(included);
        this.endTopNode(token, false);
    }

    @Override
    protected void gotExprNew(LocatableToken token) {
        this.gotNewType = false;
    }

    @Override
    protected void endExprNew(LocatableToken token, boolean included) {
        if (this.gotNewType) {
            this.newTypes.pop();
        }
        this.gotNewType = true;
    }

    @Override
    protected void gotTypeSpec(List<LocatableToken> tokens) {
        if (this.gotExtends) {
            JavaEntity supert = ParseUtils.getTypeEntity(this.scopeStack.peek(), this.currentQuerySource(), tokens);
            if (supert != null) {
                this.extendedTypes.add(supert);
            }
        } else if (this.gotImplements) {
            JavaEntity supert = ParseUtils.getTypeEntity(this.scopeStack.peek(), this.currentQuerySource(), tokens);
            if (supert != null) {
                this.implementedTypes.add(supert);
            }
        } else if (!this.gotNewType) {
            this.gotNewType = true;
            this.newTypes.push(tokens);
        } else {
            this.lastTypeSpec = tokens;
            this.arrayDecls = 0;
        }
    }

    @Override
    protected void gotArrayDeclarator() {
        ++this.arrayDecls;
    }

    @Override
    protected void beginFieldDeclarations(LocatableToken first) {
        this.arrayDecls = 0;
        this.endDecl(first);
    }

    @Override
    protected void gotField(LocatableToken first, LocatableToken idToken) {
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(first.getLine(), first.getColumn());
        PositionedResolver resolver = new PositionedResolver(this.scopeStack.peek(), insPos - curOffset);
        JavaEntity fieldType = ParseUtils.getTypeEntity(resolver, this.currentQuerySource(), this.lastTypeSpec);
        this.lastField = new FieldNode(this.scopeStack.peek(), idToken.getText(), fieldType, this.arrayDecls, this.currentModifiers);
        this.arrayDecls = 0;
        this.beginNode(insPos);
        if (fieldType != null) {
            JavaParentNode top = this.scopeStack.peek();
            top.insertField(this.lastField, insPos - curOffset, 0);
        } else {
            this.scopeStack.peek().insertNode(this.lastField, insPos - curOffset, 0);
        }
        this.scopeStack.push(this.lastField);
    }

    @Override
    protected void gotSubsequentField(LocatableToken first, LocatableToken idToken) {
        FieldNode field = new FieldNode(this.scopeStack.peek(), idToken.getText(), this.lastField, this.arrayDecls);
        this.arrayDecls = 0;
        int curOffset = this.getTopNodeOffset();
        int insPos = this.lineColToPosition(first.getLine(), first.getEndColumn());
        this.beginNode(insPos);
        if (this.lastField.getFieldType() != null) {
            JavaParentNode top = this.scopeStack.peek();
            top.insertField(field, insPos - curOffset, 0);
        } else {
            this.scopeStack.peek().insertNode(field, insPos - curOffset, 0);
        }
        this.scopeStack.push(field);
    }

    @Override
    protected void endField(LocatableToken token, boolean included) {
        this.endTopNode(token, included);
    }

    @Override
    protected void beginVariableDecl(LocatableToken first) {
        this.beginFieldDeclarations(first);
    }

    @Override
    protected void gotVariableDecl(LocatableToken first, LocatableToken idToken, boolean inited) {
        this.gotField(first, idToken);
    }

    @Override
    protected void gotSubsequentVar(LocatableToken first, LocatableToken idToken, boolean inited) {
        this.gotSubsequentField(first, idToken);
    }

    @Override
    protected void endVariable(LocatableToken token, boolean included) {
        this.endField(token, included);
    }

    @Override
    protected void beginForInitDecl(LocatableToken first) {
        this.arrayDecls = 0;
    }

    @Override
    protected void gotForInit(LocatableToken first, LocatableToken idToken) {
        this.gotField(first, idToken);
    }

    @Override
    protected void gotSubsequentForInit(LocatableToken first, LocatableToken idToken) {
        this.gotSubsequentField(first, idToken);
    }

    @Override
    protected void endForInit(LocatableToken token, boolean included) {
        this.endField(token, included);
    }

    @Override
    protected void beginAnonClassBody(LocatableToken token, boolean isEnumMember) {
        JavaEntity supert;
        ParsedTypeNode pnode;
        this.innermostType = pnode = new ParsedTypeNode(this.scopeStack.peek(), this.innermostType, 0, null, 0);
        int curOffset = this.getTopNodeOffset();
        LocatableToken begin = token;
        int insPos = this.lineColToPosition(begin.getLine(), begin.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(pnode, insPos - curOffset, 0);
        this.scopeStack.push(pnode);
        if (!isEnumMember) {
            PositionedResolver resolver = new PositionedResolver(this.scopeStack.peek(), insPos - curOffset);
            supert = ParseUtils.getTypeEntity(resolver, this.currentQuerySource(), this.newTypes.peek());
        } else {
            supert = new TypeEntity(new ParsedReflective(this.innermostType));
        }
        ArrayList<JavaEntity> superts = new ArrayList<JavaEntity>(1);
        superts.add(supert);
        pnode.setExtendedTypes(superts);
        TypeInnerNode bodyNode = new TypeInnerNode(this.scopeStack.peek());
        bodyNode.setInner(true);
        curOffset = this.getTopNodeOffset();
        insPos = this.lineColToPosition(token.getEndLine(), token.getEndColumn());
        this.beginNode(insPos);
        pnode.insertInner(bodyNode, insPos - curOffset, 0);
        this.scopeStack.push(bodyNode);
    }

    @Override
    protected void endAnonClassBody(LocatableToken token, boolean included) {
        this.endTopNode(token, false);
        this.endTopNode(token, included);
        this.innermostType = this.innermostType.getContainingClass();
    }

    @Override
    protected void beginExpression(LocatableToken token) {
        ExpressionNode nnode = new ExpressionNode(this.scopeStack.peek());
        int curOffset = this.getTopNodeOffset();
        LocatableToken begin = token;
        int insPos = this.lineColToPosition(begin.getLine(), begin.getColumn());
        this.beginNode(insPos);
        this.scopeStack.peek().insertNode(nnode, insPos - curOffset, 0);
        this.scopeStack.push(nnode);
    }

    @Override
    protected void endExpression(LocatableToken token, boolean isEmpty) {
        this.endTopNode(token, false);
        this.arrayDecls = 0;
    }

    @Override
    protected void gotTypeDefExtends(LocatableToken extendsToken) {
        this.gotExtends = true;
        this.gotImplements = false;
    }

    @Override
    protected void gotTypeDefImplements(LocatableToken implementsToken) {
        this.gotImplements = true;
        this.gotExtends = false;
    }

    class TypeParam {
        String name;
        List<List<LocatableToken>> bounds;

        TypeParam(String name, List<List<LocatableToken>> bounds) {
            this.name = name;
            this.bounds = bounds;
        }
    }
}

