/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.utility;

import java.io.PrintStream;

public class Flexdbg {
    private int serviceMask = -1;
    private int debugLevel = 3;
    private PrintStream outStream = System.err;
    private String msgPrefix = null;
    public static final int TRACE = 1;
    public static final int DEBUG = 2;
    public static final int NOTICE = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static final int ALL_SERVICES = -1;

    public void setOutput(PrintStream i_outStream) {
        if (i_outStream == null) {
            this.error(-1, "Flexdbg.setOutput: You cannot set a NULL outStream");
            return;
        }
        this.outStream = i_outStream;
    }

    public int setDebugLevel(int i_debugLevel) {
        this.debugLevel = i_debugLevel;
        return this.debugLevel;
    }

    public int setServiceMask(int i_serviceMask) {
        this.serviceMask = i_serviceMask;
        return this.serviceMask;
    }

    public void setMsgPrefix(String i_msgPrefix) {
        this.msgPrefix = i_msgPrefix;
    }

    private void doPrint(int serviceId, String message) {
        if ((serviceId & this.serviceMask) == 0) {
            return;
        }
        if (this.msgPrefix != null) {
            this.outStream.print(this.msgPrefix);
        }
        this.outStream.println(message);
    }

    public void trace(int serviceId, String message) {
        if (this.debugLevel > 1) {
            return;
        }
        this.doPrint(serviceId, message);
    }

    public void debug(int serviceId, String message) {
        if (this.debugLevel > 2) {
            return;
        }
        this.doPrint(serviceId, message);
    }

    public void notice(int serviceId, String message) {
        if (this.debugLevel > 3) {
            return;
        }
        this.doPrint(serviceId, message);
    }

    public void error(int serviceId, String message) {
        if (this.debugLevel > 4) {
            return;
        }
        this.doPrint(serviceId, message);
    }

    public void fatal(int serviceId, String message) {
        if (this.debugLevel > 5) {
            return;
        }
        this.doPrint(serviceId, message);
    }
}

