/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.editor.EditorManager;
import bluej.editor.moe.MoeSyntaxView;
import bluej.editor.moe.ScopeHighlightingPrefDisplay;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditorPrefPanel
extends JPanel
implements PrefPanelListener {
    private JTextField editorFontField;
    private JCheckBox hilightingBox;
    private JCheckBox autoIndentBox;
    private JCheckBox lineNumbersBox;
    private JCheckBox makeBackupBox;
    private JCheckBox matchBracketsBox;
    private ScopeHighlightingPrefDisplay scopeHighlightingPrefDisplay = new ScopeHighlightingPrefDisplay();

    public EditorPrefPanel() {
        this.setBorder(BlueJTheme.generalBorder);
        DBox editorPanel = new DBox(DBoxLayout.Y_AXIS, 0, 5, 0.5f);
        String editorTitle = Config.getString((String)"prefmgr.edit.editor.title");
        editorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(editorTitle), BlueJTheme.generalBorder));
        editorPanel.setAlignmentX(0.0f);
        JPanel topPanel = new JPanel(new GridLayout(3, 2, 0, 0));
        JPanel fontPanel = new JPanel(new FlowLayout(0, 5, 5));
        fontPanel.add(new JLabel(Config.getString((String)"prefmgr.edit.editorfontsize") + "  "));
        this.editorFontField = new JTextField(4);
        fontPanel.add(this.editorFontField);
        topPanel.add(fontPanel);
        this.autoIndentBox = new JCheckBox(Config.getString((String)"prefmgr.edit.autoindent"));
        topPanel.add(this.autoIndentBox);
        this.hilightingBox = new JCheckBox(Config.getString((String)"prefmgr.edit.usesyntaxhilighting"));
        topPanel.add(this.hilightingBox);
        this.makeBackupBox = new JCheckBox(Config.getString((String)"prefmgr.edit.makeBackup"));
        topPanel.add(this.makeBackupBox);
        this.lineNumbersBox = new JCheckBox(Config.getString((String)"prefmgr.edit.displaylinenumbers"));
        topPanel.add(this.lineNumbersBox);
        this.matchBracketsBox = new JCheckBox(Config.getString((String)"prefmgr.edit.matchBrackets"));
        topPanel.add(this.matchBracketsBox);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        bottomPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString((String)"prefmgr.edit.colortransparency")), BlueJTheme.generalBorder));
        JPanel sliderPanel = new JPanel(new FlowLayout(0, 20, 20));
        sliderPanel.add(this.scopeHighlightingPrefDisplay.getHighlightStrengthSlider());
        bottomPanel.add(sliderPanel);
        bottomPanel.add(this.scopeHighlightingPrefDisplay.getColourPalette());
        editorPanel.add(topPanel);
        editorPanel.add(Box.createVerticalGlue());
        editorPanel.add(bottomPanel);
        this.add((Component)editorPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalGlue());
    }

    public void beginEditing() {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize()));
        this.hilightingBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting"));
        this.autoIndentBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.autoIndent"));
        this.lineNumbersBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers"));
        this.makeBackupBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.makeBackup"));
        this.matchBracketsBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.matchBrackets"));
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        int newFontSize = 0;
        try {
            newFontSize = Integer.parseInt(this.editorFontField.getText());
            PrefMgr.setEditorFontSize((int)newFontSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setFlag((String)"bluej.editor.syntaxHilighting", (boolean)this.hilightingBox.isSelected());
        MoeSyntaxView.resetSyntaxHighlighting();
        PrefMgr.setFlag((String)"bluej.editor.autoIndent", (boolean)this.autoIndentBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.displayLineNumbers", (boolean)this.lineNumbersBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.makeBackup", (boolean)this.makeBackupBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.matchBrackets", (boolean)this.matchBracketsBox.isSelected());
        PrefMgr.setScopeHighlightStrength((int)this.scopeHighlightingPrefDisplay.getStrengthValue());
        EditorManager.getEditorManager().refreshAll();
    }
}

