/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.reactfx.util.FingerTree;
import org.reactfx.util.Lists;
import org.reactfx.util.ToSemigroup;

class ListConcatenation<E>
extends AbstractList<E> {
    private static final ToSemigroup<List<?>, Integer> LIST_SIZE_MONOID = new ToSemigroup<List<?>, Integer>(){

        @Override
        public Integer apply(List<?> t) {
            return t.size();
        }

        @Override
        public Integer reduce(Integer left, Integer right) {
            return left + right;
        }
    };
    private final FingerTree<List<E>, Integer> ft;

    static <E> List<E> create(List<List<? extends E>> lists) {
        return lists.stream().filter(l -> !l.isEmpty()).map(l -> {
            List lst = l;
            return lst instanceof ListConcatenation ? ((ListConcatenation)lst).ft : FingerTree.mkTree(Collections.singletonList(lst), LIST_SIZE_MONOID);
        }).reduce(FingerTree::join).map(ListConcatenation::new).orElse(Collections.emptyList());
    }

    ListConcatenation(FingerTree<List<E>, Integer> ft) {
        this.ft = ft;
    }

    @Override
    public E get(int index) {
        return (E)this.ft.get(Integer::intValue, index, List::get);
    }

    @Override
    public int size() {
        return this.ft.getSummary(0);
    }

    @Override
    public List<E> subList(int from, int to) {
        Lists.checkRange(from, to, this.size());
        return super.drop(from);
    }

    private ListConcatenation<E> trim(int limit) {
        return this.ft.caseEmpty().unify(emptyTree -> this, neTree -> neTree.split(Integer::intValue, limit).map((l, m, r) -> {
            FingerTree t = m.map((lst, i) -> i == 0 ? l : l.append(lst.subList(0, (int)i)));
            return new ListConcatenation(t);
        }));
    }

    private ListConcatenation<E> drop(int n) {
        return this.ft.caseEmpty().unify(emptyTree -> this, neTree -> neTree.split(Integer::intValue, n).map((l, m, r) -> {
            FingerTree t = m.map((lst, i) -> i.intValue() == lst.size() ? r : r.prepend(lst.subList((int)i, lst.size())));
            return new ListConcatenation(t);
        }));
    }
}

