/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Function;
import org.fxmisc.flowless.Cell;

final class CellPool<T, C extends Cell<T, ?>> {
    private final Function<? super T, ? extends C> cellFactory;
    private final Queue<C> pool = new LinkedList<C>();

    public CellPool(Function<? super T, ? extends C> cellFactory) {
        this.cellFactory = cellFactory;
    }

    public C getCell(T item) {
        Cell cell = (Cell)this.pool.poll();
        if (cell != null) {
            cell.updateItem(item);
        } else {
            cell = (Cell)this.cellFactory.apply(item);
        }
        return (C)cell;
    }

    public void acceptCell(C cell) {
        cell.reset();
        if (cell.isReusable()) {
            this.pool.add(cell);
        } else {
            cell.dispose();
        }
    }

    public void dispose() {
        for (Cell cell : this.pool) {
            cell.dispose();
        }
        this.pool.clear();
    }
}

