/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions.event;

import bluej.extensions.BClassTarget;
import bluej.extensions.BDependency;
import bluej.extensions.BPackage;
import bluej.extensions.event.ExtensionEvent;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import java.util.ArrayList;
import java.util.List;

public class ClassTargetEvent
implements ExtensionEvent {
    private Type eventType;
    private ClassTarget classTarget;
    private Package bluejPackage;

    public ClassTargetEvent(ClassTarget classTarget, Package bluejPackage, boolean visible) {
        this.classTarget = classTarget;
        this.bluejPackage = bluejPackage;
        this.eventType = visible ? Type.CLASS_TARGET_SHOWN : Type.CLASS_TARGET_HIDDEN;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public BClassTarget getClassTarget() {
        return this.classTarget.getBClassTarget();
    }

    public BClassTarget getAssociation() {
        DependentTarget association = this.classTarget.getAssociation();
        if (association instanceof ClassTarget) {
            return ((ClassTarget)association).getBClassTarget();
        }
        return null;
    }

    public List<BDependency> getParentDependencies() {
        return this.getBDependencies(this.classTarget.getParents());
    }

    public List<BDependency> getChildDependencies() {
        return this.getBDependencies(this.classTarget.getChildren());
    }

    private List<BDependency> getBDependencies(List<Dependency> dependencies) {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        for (Dependency dependency : dependencies) {
            result.add(dependency.getBDependency());
        }
        return result;
    }

    public BPackage getPackage() {
        return this.bluejPackage.getBPackage();
    }

    public String toString() {
        return "ClassTargetEvent: " + (Object)((Object)this.eventType) + " (" + this.classTarget + ")";
    }

    public static enum Type {
        CLASS_TARGET_HIDDEN,
        CLASS_TARGET_SHOWN;

    }
}

