/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.debugger.gentype.JavaType;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.CommentNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public final class MoeActions {
    private static final String KEYS_FILE = "editor.keys";
    private static int SHORTCUT_MASK;
    private static int ALT_SHORTCUT_MASK;
    private static int SHIFT_SHORTCUT_MASK;
    private static int SHIFT_ALT_SHORTCUT_MASK;
    private static int DOUBLE_SHORTCUT_MASK;
    private static final int tabSize;
    private static final String spaces = "                                        ";
    private static final char TAB_CHAR = '\t';
    private Action[] actionTable;
    private HashMap<Object, Action> actions;
    private String[] categories;
    private int[] categoryIndex;
    private Keymap keymap;
    private KeyCatcher keyCatcher;
    private boolean lastActionWasCut;
    public UndoAction undoAction;
    public RedoAction redoAction;
    public FindNextAction findNextAction;
    public FindNextBackwardAction findNextBackwardAction;
    public Action compileAction;
    public Action contentAssistAction;
    private InputMap componentInputMap;
    private static MoeActions moeActions;
    private Action[] overrideActions;

    public Action[] getActionTable() {
        return this.actionTable;
    }

    public void setActionTable(Action[] actionTable) {
        this.actionTable = actionTable;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] categories) {
        this.categories = categories;
    }

    public int[] getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setCategoryIndex(int[] categoryIndex) {
        this.categoryIndex = categoryIndex;
    }

    public static MoeActions getActions(JTextComponent textComponent) {
        if (moeActions == null) {
            moeActions = new MoeActions(textComponent);
        }
        if (textComponent != null) {
            textComponent.setKeymap(MoeActions.moeActions.keymap);
            moeActions.overrideActions(textComponent);
        }
        return moeActions;
    }

    private void overrideActions(JTextComponent textComponent) {
        for (Action action : this.overrideActions) {
            textComponent.getActionMap().put(action.getValue("Name"), action);
        }
    }

    private MoeActions(JTextComponent textComponent) {
        SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ALT_SHORTCUT_MASK = SHORTCUT_MASK == 2 ? 4 : 2;
        SHIFT_SHORTCUT_MASK = SHORTCUT_MASK + 1;
        SHIFT_ALT_SHORTCUT_MASK = 1 + ALT_SHORTCUT_MASK;
        DOUBLE_SHORTCUT_MASK = SHORTCUT_MASK + ALT_SHORTCUT_MASK;
        Keymap origKeymap = textComponent.getKeymap();
        this.keymap = JTextComponent.addKeymap("BlueJ map", origKeymap);
        this.createActionTable(textComponent);
        this.keyCatcher = new KeyCatcher();
        if (!this.load()) {
            this.setDefaultKeyBindings();
        }
        this.lastActionWasCut = false;
        this.componentInputMap = textComponent.getInputMap();
    }

    public void setUndoEnabled(boolean enabled) {
        this.undoAction.setEnabled(enabled);
    }

    public void setRedoEnabled(boolean enabled) {
        this.redoAction.setEnabled(enabled);
    }

    public void setPasteEnabled(boolean enabled) {
        this.actions.get("paste-from-clipboard").setEnabled(enabled);
    }

    public FindNextAction getFindNextAction() {
        return this.findNextAction;
    }

    public FindNextBackwardAction getFindNextBackwardAction() {
        return this.findNextBackwardAction;
    }

    public void enableAction(String action, boolean flag) {
        Action moeAction = this.getActionByName(action);
        if (moeAction != null) {
            moeAction.setEnabled(flag);
        }
    }

    public Action getActionByName(String name) {
        return this.actions.get(name);
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        KeyStroke[] keys = this.keymap.getKeyStrokesForAction(action);
        if ((keys = this.addComponentKeyStrokes(action, keys)) != null && keys.length > 0) {
            return keys;
        }
        return null;
    }

    public KeyStroke[] addComponentKeyStrokes(Action action, KeyStroke[] keys) {
        KeyStroke[] allKeys;
        ArrayList<KeyStroke> keyStrokes = null;
        KeyStroke[] componentKeys = this.componentInputMap.allKeys();
        for (int i = 0; i < componentKeys.length; ++i) {
            if (!this.componentInputMap.get(componentKeys[i]).equals(action.getValue("Name"))) continue;
            if (keyStrokes == null) {
                keyStrokes = new ArrayList<KeyStroke>();
            }
            keyStrokes.add(componentKeys[i]);
        }
        if (keyStrokes != null) {
            Iterator i = keyStrokes.iterator();
            while (i.hasNext()) {
                if (this.keymap.getAction((KeyStroke)i.next()) == null) continue;
                i.remove();
            }
        }
        if (keyStrokes == null || keyStrokes.isEmpty()) {
            return keys;
        }
        if (keys == null) {
            allKeys = new KeyStroke[keyStrokes.size()];
            keyStrokes.toArray(allKeys);
        } else {
            allKeys = new KeyStroke[keyStrokes.size() + keys.length];
            keyStrokes.toArray(allKeys);
            System.arraycopy(allKeys, 0, allKeys, keys.length, keyStrokes.size());
            System.arraycopy(keys, 0, allKeys, 0, keys.length);
        }
        return allKeys;
    }

    public void addActionForKeyStroke(KeyStroke key, Action a) {
        this.keymap.addActionForKeyStroke(key, a);
    }

    public void removeKeyStrokeBinding(KeyStroke key) {
        this.keymap.removeKeyStrokeBinding(key);
    }

    public boolean save() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileOutputStream ostream = new FileOutputStream(file);
            ObjectOutputStream stream = new ObjectOutputStream(ostream);
            KeyStroke[] keys = this.keymap.getBoundKeyStrokes();
            stream.writeInt(300);
            stream.writeInt(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                stream.writeObject(keys[i]);
                stream.writeObject(this.keymap.getAction(keys[i]).getValue("Name"));
            }
            stream.flush();
            ostream.close();
            return true;
        }
        catch (Exception exc) {
            Debug.message((String)("Cannot save key bindings: " + exc));
            return false;
        }
    }

    public boolean load() {
        try {
            File file = Config.getUserConfigFile((String)KEYS_FILE);
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream stream = new ObjectInputStream(istream);
            int version = 0;
            int count = stream.readInt();
            if (count > 100) {
                version = count;
                count = stream.readInt();
            }
            if (Config.isMacOS() && version < 140) {
                istream.close();
                return false;
            }
            for (int i = 0; i < count; ++i) {
                KeyStroke key = (KeyStroke)stream.readObject();
                String actionName = (String)stream.readObject();
                Action action = this.actions.get(actionName);
                if (action == null) continue;
                this.keymap.addActionForKeyStroke(key, action);
            }
            istream.close();
            if (version < 252) {
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(61, SHORTCUT_MASK), this.actions.get("increase-font"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(45, SHORTCUT_MASK), this.actions.get("decrease-font"));
            }
            if (version < 300) {
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(32, 2), this.actions.get("code-completion"));
                this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, SHIFT_SHORTCUT_MASK), this.actions.get("autoindent"));
            }
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public void userAction() {
        this.lastActionWasCut = false;
    }

    public void textInsertAction(DocumentEvent evt, JTextComponent textPane) {
        try {
            int offset;
            Document doc;
            char ch;
            if (evt.getLength() == 1 && (ch = (doc = evt.getDocument()).getText(offset = evt.getOffset(), 1).charAt(0)) == '}' && PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                this.closingBrace(textPane, doc, offset);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void closingBrace(JTextComponent textPane, Document doc, int offset) throws BadLocationException {
        int lineIndex = MoeActions.getCurrentLineIndex(textPane);
        Element line = MoeActions.getLine(textPane, lineIndex);
        int lineStart = line.getStartOffset();
        String prefix = doc.getText(lineStart, offset - lineStart);
        if (prefix.trim().length() == 0) {
            Rectangle r = textPane.modelToView(textPane.getCaretPosition() - 1);
            Point p = r.getLocation();
            textPane.setCaretPosition(lineStart);
            this.doIndent(textPane, true);
            textPane.setCaretPosition(textPane.getCaretPosition() + 1);
            textPane.getCaret().setMagicCaretPosition(p);
        }
    }

    private static int findWordLimit(JTextComponent c, int pos, boolean forwards) {
        int maxLen = c.getDocument().getLength();
        if (forwards && pos >= maxLen) {
            return maxLen;
        }
        if (!forwards && pos <= 0) {
            return 0;
        }
        try {
            char curChar = c.getText(pos, 1).charAt(0);
            if (Character.isWhitespace(curChar)) {
                while (Character.isWhitespace(curChar)) {
                    pos = forwards ? ++pos : --pos;
                    if (pos == maxLen) {
                        return pos;
                    }
                    if (pos == 0) {
                        return 0;
                    }
                    curChar = c.getText(pos, 1).charAt(0);
                }
                return forwards ? pos : pos + 1;
            }
            if (Character.isJavaIdentifierPart(curChar)) {
                while (Character.isJavaIdentifierPart(curChar)) {
                    pos = forwards ? ++pos : --pos;
                    if (pos == maxLen) {
                        return pos;
                    }
                    if (pos == 0) {
                        return 0;
                    }
                    curChar = c.getText(pos, 1).charAt(0);
                }
                return forwards ? pos : pos + 1;
            }
            return forwards ? pos + 1 : pos;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean haveSelection(JTextComponent textPane) {
        Caret caret = textPane.getCaret();
        return caret.getMark() != caret.getDot();
    }

    public void addSelectionToClipboard(JTextComponent textComponent) {
        Clipboard clipboard = textComponent.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        String clipContent = "";
        if (content != null) {
            try {
                clipContent = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        StringSelection contents = new StringSelection(clipContent + textComponent.getSelectedText());
        clipboard.setContents(contents, contents);
    }

    private static int getCurrentColumn(JTextComponent textPane) {
        Caret caret = textPane.getCaret();
        int pos = Math.min(caret.getMark(), caret.getDot());
        AbstractDocument doc = (AbstractDocument)textPane.getDocument();
        int lineStart = doc.getParagraphElement(pos).getStartOffset();
        return pos - lineStart;
    }

    private static Element getLine(JTextComponent text, int lineNo) {
        return text.getDocument().getDefaultRootElement().getElement(lineNo);
    }

    private static int getCurrentLineIndex(JTextComponent text) {
        MoeSyntaxDocument document = (MoeSyntaxDocument)((Object)text.getDocument());
        return document.getDefaultRootElement().getElementIndex(text.getCaretPosition());
    }

    private void doIndent(JTextComponent textPane, boolean isNewLine) {
        int lineIndex = MoeActions.getCurrentLineIndex(textPane);
        if (lineIndex == 0) {
            if (!isNewLine) {
                MoeActions.insertSpacedTab(textPane);
            }
            return;
        }
        MoeSyntaxDocument doc = (MoeSyntaxDocument)((Object)textPane.getDocument());
        Element line = MoeActions.getLine(textPane, lineIndex);
        int lineStart = line.getStartOffset();
        int pos = textPane.getCaretPosition();
        try {
            int caretColumn;
            boolean isOpenBrace = false;
            boolean isCommentEnd = false;
            boolean isCommentEndOnly = false;
            String prefix = doc.getText(lineStart, pos - lineStart);
            if (prefix.trim().length() > 0) {
                MoeActions.insertSpacedTab(textPane);
                return;
            }
            boolean foundLine = false;
            int lineOffset = 1;
            String prevLineText = null;
            while (lineIndex - lineOffset >= 0 && !foundLine) {
                int prevLineEnd;
                Element prevline = MoeActions.getLine(textPane, lineIndex - lineOffset);
                int prevLineStart = prevline.getStartOffset();
                prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
                if (!MoeIndent.isWhiteSpaceOnly(prevLineText)) {
                    foundLine = true;
                    continue;
                }
                ++lineOffset;
            }
            if (!foundLine) {
                if (!isNewLine) {
                    MoeActions.insertSpacedTab(textPane);
                }
                return;
            }
            if (MoeActions.isOpenBrace(prevLineText)) {
                isOpenBrace = true;
            } else {
                isCommentEnd = prevLineText.trim().endsWith("*/");
                isCommentEndOnly = prevLineText.trim().equals("*/");
            }
            int indentPos = MoeIndent.findFirstNonIndentChar(prevLineText, isCommentEnd);
            String indent = prevLineText.substring(0, indentPos);
            if (isOpenBrace) {
                indentPos += tabSize;
            }
            if ((caretColumn = MoeActions.getCurrentColumn(textPane)) >= indentPos) {
                if (!isNewLine) {
                    MoeActions.insertSpacedTab(textPane);
                }
                return;
            }
            if (isNewLine && MoeActions.isNewCommentStart(indent, doc, lineStart)) {
                MoeActions.completeNewCommentBlock(textPane, indent);
                return;
            }
            int lineEnd = line.getEndOffset();
            String lineText = doc.getText(lineStart, lineEnd - lineStart);
            indentPos = MoeIndent.findFirstNonIndentChar(lineText, true);
            char firstChar = lineText.charAt(indentPos);
            doc.remove(lineStart, indentPos);
            String newIndent = MoeActions.nextIndent(indent, isOpenBrace, isCommentEndOnly);
            if (firstChar == '*') {
                newIndent = newIndent.replace('*', ' ');
            }
            doc.insertString(lineStart, newIndent, null);
            if (firstChar == '}') {
                MoeActions.removeTab(textPane, (Document)((Object)doc));
            }
        }
        catch (BadLocationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void doDeIndent(JTextComponent textPane) {
        int lineIndex = MoeActions.getCurrentLineIndex(textPane);
        MoeSyntaxDocument doc = (MoeSyntaxDocument)((Object)textPane.getDocument());
        try {
            int prevLineEnd;
            Element line = MoeActions.getLine(textPane, lineIndex);
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            String lineText = doc.getText(lineStart, lineEnd - lineStart);
            int currentIndentPos = MoeIndent.findFirstNonIndentChar(lineText, true);
            char firstChar = lineText.charAt(currentIndentPos);
            textPane.setCaretPosition(lineStart + currentIndentPos);
            if (lineIndex == 0) {
                MoeActions.removeTab(textPane, (Document)((Object)doc));
                return;
            }
            Element prevline = MoeActions.getLine(textPane, lineIndex - 1);
            int prevLineStart = prevline.getStartOffset();
            String prevLineText = doc.getText(prevLineStart, (prevLineEnd = prevline.getEndOffset()) - prevLineStart);
            int targetIndentPos = MoeIndent.findFirstNonIndentChar(prevLineText, true);
            if (currentIndentPos > targetIndentPos) {
                String indent = prevLineText.substring(0, targetIndentPos);
                doc.remove(lineStart, currentIndentPos);
                doc.insertString(lineStart, indent, null);
                if (firstChar == '}') {
                    MoeActions.removeTab(textPane, (Document)((Object)doc));
                }
            } else {
                MoeActions.removeTab(textPane, (Document)((Object)doc));
            }
        }
        catch (BadLocationException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void doBlockIndent(MoeEditor editor) {
        editor.undoManager.beginCompoundEdit();
        MoeActions.blockAction(editor, new IndentLineAction());
        editor.undoManager.endCompoundEdit();
    }

    private void doBlockDeIndent(MoeEditor editor) {
        editor.undoManager.beginCompoundEdit();
        MoeActions.blockAction(editor, new DeindentLineAction());
        editor.undoManager.endCompoundEdit();
    }

    private static boolean isNewCommentStart(String s, MoeSyntaxDocument doc, int lineStart) {
        if ((s = s.trim()).endsWith("/**") || s.endsWith("/*")) {
            NodeTree.NodeAndPosition curNode = doc.getParser().findNodeAt(lineStart, 0);
            while (curNode != null && !(curNode.getNode() instanceof CommentNode)) {
                curNode = ((ParsedNode)curNode.getNode()).findNodeAt(lineStart, curNode.getPosition());
            }
            if (curNode == null) {
                return true;
            }
            String comment = MoeActions.getNodeContents(doc, (NodeTree.NodeAndPosition<ParsedNode>)curNode);
            comment = comment.substring(2);
            return comment.contains("/*");
        }
        return false;
    }

    private static void completeNewCommentBlock(JTextComponent textPane, String indentString) {
        String nextIndent = indentString.substring(0, indentString.length() - 2);
        textPane.replaceSelection(nextIndent + " * ");
        int pos = textPane.getCaretPosition();
        textPane.replaceSelection("\n");
        textPane.replaceSelection(nextIndent + " */");
        textPane.setCaretPosition(pos);
    }

    private static boolean isOpenBrace(String s) {
        int index = s.lastIndexOf(123);
        if (index == -1) {
            return false;
        }
        return s.indexOf(125, index + 1) == -1;
    }

    private static String nextIndent(String s, boolean openBrace, boolean commentEndOnly) {
        if (openBrace) {
            return s + spaces.substring(0, tabSize);
        }
        if (commentEndOnly) {
            return s.substring(0, s.length() - 1);
        }
        if (s.endsWith("/*")) {
            return s.substring(0, s.length() - 2) + " * ";
        }
        return s;
    }

    private static void insertSpacedTab(JTextComponent textPane) {
        int numSpaces = tabSize - MoeActions.getCurrentColumn(textPane) % tabSize;
        textPane.replaceSelection(spaces.substring(0, numSpaces));
    }

    private static void removeTab(JTextComponent textPane, Document doc) throws BadLocationException {
        int col = MoeActions.getCurrentColumn(textPane);
        if (col > 0) {
            int remove = col % tabSize;
            if (remove == 0) {
                remove = tabSize;
            }
            int pos = textPane.getCaretPosition();
            doc.remove(pos - remove, remove);
        }
    }

    private int convertTabsToSpaces(JTextComponent textPane) {
        int count = 0;
        int lineNo = 0;
        AbstractDocument doc = (AbstractDocument)textPane.getDocument();
        Element root = doc.getDefaultRootElement();
        Element line = root.getElement(lineNo);
        try {
            while (line != null) {
                int start = line.getStartOffset();
                int length = line.getEndOffset() - start;
                String text = doc.getText(start, length);
                int startCount = count;
                int tabIndex = text.indexOf(9);
                while (tabIndex != -1) {
                    text = MoeActions.expandTab(text, tabIndex);
                    ++count;
                    tabIndex = text.indexOf(9);
                }
                if (count != startCount) {
                    doc.remove(start, length);
                    doc.insertString(start, text, null);
                }
                line = root.getElement(++lineNo);
            }
        }
        catch (BadLocationException exc) {
            throw new RuntimeException(exc);
        }
        return count;
    }

    private static String expandTab(String s, int idx) {
        int numSpaces = tabSize - idx % tabSize;
        return s.substring(0, idx) + spaces.substring(0, numSpaces) + s.substring(idx + 1);
    }

    private static void insertTemplate(JTextComponent textPane, MoeEditor editor, String templateName) {
        try {
            File template = Config.getTemplateFile((String)templateName);
            FileInputStream fileStream = new FileInputStream(template);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
            int addedTextLength = 0;
            String line = in.readLine();
            while (line != null) {
                while (line.length() > 0 && line.charAt(0) == '\t') {
                    line = line.substring(1);
                }
                addedTextLength += line.length() + 1;
                textPane.replaceSelection(line);
                textPane.replaceSelection("\n");
                line = in.readLine();
            }
            int caretPos = editor.getSourcePane().getCaretPosition();
            MoeIndent.AutoIndentInformation info = MoeIndent.calculateIndentsAndApply(editor.getSourceDocument(), caretPos - addedTextLength, caretPos + 2, caretPos);
            editor.setCaretPositionForward(info.getNewCaretPosition() - editor.getSourcePane().getCaretPosition());
            in.close();
        }
        catch (IOException exc) {
            Debug.reportError((String)"Could not read method template.");
            Debug.reportError((String)("Exception: " + exc));
        }
    }

    private static void blockAction(MoeEditor editor, LineAction lineAction) {
        editor.setCaretActive(false);
        Caret caret = editor.getSourcePane().getCaret();
        int selectionStart = caret.getMark();
        int selectionEnd = caret.getDot();
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
        }
        if (selectionStart != selectionEnd) {
            --selectionEnd;
        }
        MoeSyntaxDocument doc = editor.getSourceDocument();
        Element text = doc.getDefaultRootElement();
        int firstLineIndex = text.getElementIndex(selectionStart);
        int lastLineIndex = text.getElementIndex(selectionEnd);
        for (int i = firstLineIndex; i <= lastLineIndex; ++i) {
            Element line = text.getElement(i);
            lineAction.apply(line, doc);
        }
        editor.setSelection(firstLineIndex + 1, 1, text.getElement(lastLineIndex).getEndOffset() - text.getElement(firstLineIndex).getStartOffset());
        editor.setCaretActive(true);
    }

    private void createActionTable(JTextComponent textComponent) {
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.compileAction = new CompileAction();
        Action[] textActions = textComponent.getActions();
        this.overrideActions = new Action[]{new NextWordAction(false), new NextWordAction(true), new PrevWordAction(false), new PrevWordAction(true), new EndWordAction(false), new EndWordAction(true), new BeginWordAction(false), new BeginWordAction(true), new DeleteWordAction(), new SelectWordAction()};
        Action[] actionArray = new Action[38];
        actionArray[0] = new SaveAction();
        actionArray[1] = new ReloadAction();
        actionArray[2] = new PageSetupAction();
        actionArray[3] = new PrintAction();
        actionArray[4] = new CloseAction();
        actionArray[5] = this.undoAction;
        actionArray[6] = this.redoAction;
        actionArray[7] = new CommentBlockAction();
        actionArray[8] = new UncommentBlockAction();
        actionArray[9] = new AutoIndentAction();
        actionArray[10] = new IndentBlockAction();
        actionArray[11] = new DeindentBlockAction();
        actionArray[12] = new InsertMethodAction();
        actionArray[13] = new AddJavadocAction();
        actionArray[14] = new IndentAction();
        actionArray[15] = new DeIndentAction();
        actionArray[16] = new NewLineAction();
        actionArray[17] = new CopyLineAction();
        actionArray[18] = new CutLineAction();
        actionArray[19] = new CutEndOfLineAction();
        actionArray[20] = new CutWordAction();
        actionArray[21] = new CutEndOfWordAction();
        actionArray[22] = new FindAction();
        this.findNextAction = new FindNextAction();
        actionArray[23] = this.findNextAction;
        this.findNextBackwardAction = new FindNextBackwardAction();
        actionArray[24] = this.findNextBackwardAction;
        actionArray[25] = new ReplaceAction();
        actionArray[26] = this.compileAction;
        actionArray[27] = new GoToLineAction();
        actionArray[28] = new ToggleInterfaceAction();
        actionArray[29] = new ToggleBreakPointAction();
        actionArray[30] = new KeyBindingsAction();
        actionArray[31] = new PreferencesAction();
        actionArray[32] = new AboutAction();
        actionArray[33] = new DescribeKeyAction();
        actionArray[34] = new HelpMouseAction();
        actionArray[35] = new IncreaseFontAction();
        actionArray[36] = new DecreaseFontAction();
        actionArray[37] = new ContentAssistAction();
        Action[] myActions = actionArray;
        this.actions = new HashMap();
        for (Action action : textActions) {
            this.actions.put(action.getValue("Name"), action);
        }
        for (Action action : this.overrideActions) {
            this.actions.put(action.getValue("Name"), action);
        }
        for (Action action : myActions) {
            this.actions.put(action.getValue("Name"), action);
        }
        this.actionTable = new Action[]{this.actions.get("delete-previous"), this.actions.get("delete-next"), this.actions.get("delete-previous-word"), this.actions.get("copy-to-clipboard"), this.actions.get("cut-to-clipboard"), this.actions.get("copy-line"), this.actions.get("cut-line"), this.actions.get("cut-end-of-line"), this.actions.get("cut-word"), this.actions.get("cut-end-of-word"), this.actions.get("paste-from-clipboard"), this.actions.get("indent"), this.actions.get("de-indent"), this.actions.get("insert-tab"), this.actions.get("new-line"), this.actions.get("insert-break"), this.actions.get("insert-method"), this.actions.get("comment-block"), this.actions.get("uncomment-block"), this.actions.get("autoindent"), this.actions.get("indent-block"), this.actions.get("deindent-block"), this.actions.get("select-word"), this.actions.get("select-line"), this.actions.get("select-paragraph"), this.actions.get("select-all"), this.actions.get("selection-backward"), this.actions.get("selection-forward"), this.actions.get("selection-up"), this.actions.get("selection-down"), this.actions.get("selection-begin-word"), this.actions.get("selection-end-word"), this.actions.get("selection-previous-word"), this.actions.get("selection-next-word"), this.actions.get("selection-begin-line"), this.actions.get("selection-end-line"), this.actions.get("selection-begin-paragraph"), this.actions.get("selection-end-paragraph"), this.actions.get("selection-page-up"), this.actions.get("selection-page-down"), this.actions.get("selection-begin"), this.actions.get("selection-end"), this.actions.get("unselect"), this.actions.get("caret-backward"), this.actions.get("caret-forward"), this.actions.get("caret-up"), this.actions.get("caret-down"), this.actions.get("caret-begin-word"), this.actions.get("caret-end-word"), this.actions.get("caret-previous-word"), this.actions.get("caret-next-word"), this.actions.get("caret-begin-line"), this.actions.get("caret-end-line"), this.actions.get("caret-begin-paragraph"), this.actions.get("caret-end-paragraph"), this.actions.get("page-up"), this.actions.get("page-down"), this.actions.get("caret-begin"), this.actions.get("caret-end"), this.actions.get("save"), this.actions.get("reload"), this.actions.get("close"), this.actions.get("print"), this.actions.get("page-setup"), this.actions.get("key-bindings"), this.actions.get("preferences"), this.actions.get("describe-key"), this.actions.get("help-mouse"), this.actions.get("show-manual"), this.actions.get("about-editor"), this.undoAction, this.redoAction, this.actions.get("find"), this.actions.get("find-next"), this.actions.get("find-next-backward"), this.actions.get("replace"), this.actions.get("compile"), this.actions.get("toggle-interface-view"), this.actions.get("toggle-breakpoint"), this.actions.get("go-to-line"), this.actions.get("increase-font"), this.actions.get("decrease-font"), this.actions.get("code-completion")};
        this.categories = new String[]{Config.getString((String)"editor.functions.editFunctions"), Config.getString((String)"editor.functions.moveScroll"), Config.getString((String)"editor.functions.classFunctions"), Config.getString((String)"editor.functions.customisation"), Config.getString((String)"editor.functions.help"), Config.getString((String)"editor.functions.misc")};
        this.categoryIndex = new int[]{0, 43, 59, 64, 66, 70, 83};
    }

    public void setDefaultKeyBindings() {
        this.keymap.removeBindings();
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(83, SHORTCUT_MASK), this.actions.get("save"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(80, SHORTCUT_MASK), this.actions.get("print"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, SHORTCUT_MASK), this.actions.get("close"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(90, SHORTCUT_MASK), this.actions.get("undo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, SHORTCUT_MASK), this.actions.get("redo"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(119, 0), this.actions.get("comment-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(118, 0), this.actions.get("uncomment-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(117, 0), this.actions.get("indent-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(116, 0), this.actions.get("deindent-block"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(77, SHORTCUT_MASK), this.actions.get("insert-method"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this.actions.get("indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), this.actions.get("de-indent"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, SHORTCUT_MASK), this.actions.get("insert-tab"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this.actions.get("new-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), this.actions.get("insert-break"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, SHORTCUT_MASK), this.actions.get("find"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, SHORTCUT_MASK), this.actions.get("find-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(71, SHIFT_SHORTCUT_MASK), this.actions.get("find-next-backward"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(82, SHORTCUT_MASK), this.actions.get("replace"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(76, SHORTCUT_MASK), this.actions.get("go-to-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(75, SHORTCUT_MASK), this.actions.get("compile"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(74, SHORTCUT_MASK), this.actions.get("toggle-interface-view"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(66, SHORTCUT_MASK), this.actions.get("toggle-breakpoint"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(68, SHORTCUT_MASK), this.actions.get("describe-key"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, SHORTCUT_MASK), this.actions.get("copy-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, SHORTCUT_MASK), this.actions.get("cut-to-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, SHORTCUT_MASK), this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(113, 0), this.actions.get("copy-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(115, 0), this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, ALT_SHORTCUT_MASK), this.actions.get("paste-from-clipboard"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, ALT_SHORTCUT_MASK), this.actions.get("delete-previous"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, ALT_SHORTCUT_MASK), this.actions.get("delete-next"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, SHIFT_ALT_SHORTCUT_MASK), this.actions.get("cut-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, SHIFT_ALT_SHORTCUT_MASK), this.actions.get("cut-end-of-line"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, DOUBLE_SHORTCUT_MASK), this.actions.get("cut-word"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, DOUBLE_SHORTCUT_MASK), this.actions.get("cut-end-of-word"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(61, SHORTCUT_MASK), this.actions.get("increase-font"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(45, SHORTCUT_MASK), this.actions.get("decrease-font"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(32, 2), this.actions.get("code-completion"));
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, SHIFT_SHORTCUT_MASK), this.actions.get("autoindent"));
    }

    private static String getNodeContents(MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap) {
        try {
            return doc.getText(nap.getPosition(), nap.getSize());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
    }

    class KeyCatcher
    extends KeyAdapter {
        MoeEditor editor;

        KeyCatcher() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 20 || keyCode == 16 || keyCode == 17 || keyCode == 157 || keyCode == 18 || keyCode == 65406 || keyCode == 65312 || keyCode == 144 || keyCode == 145 || keyCode == 0) {
                return;
            }
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            String modifierName = KeyEvent.getKeyModifiersText(key.getModifiers());
            String keyName = KeyEvent.getKeyText(keyCode);
            if (modifierName.length() > 0) {
                keyName = modifierName + "+" + keyName;
            }
            Action action = null;
            for (Keymap map = MoeActions.this.keymap; map != null && action == null; map = map.getResolveParent()) {
                action = map.getAction(key);
            }
            if (action == null) {
                Object binding = MoeActions.this.componentInputMap.get(key);
                if (binding == null) {
                    this.editor.writeMessage(keyName + " " + Config.getString((String)"editor.keypressed.keyIsNotBound").trim());
                } else {
                    this.editor.writeMessage(keyName + " " + Config.getString((String)"editor.keypressed.callsTheFunction").trim() + binding + "\"");
                }
            } else {
                String name = (String)action.getValue("Name");
                this.editor.writeMessage(keyName + Config.getString((String)"editor.keypressed.callsTheFunction") + name + "\"");
            }
            e.getComponent().removeKeyListener(MoeActions.this.keyCatcher);
            e.consume();
        }

        public void setEditor(MoeEditor ed) {
            this.editor = ed;
        }
    }

    class DeindentLineAction
    implements LineAction {
        DeindentLineAction() {
        }

        @Override
        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                String spacedTab = MoeActions.spaces.substring(0, tabSize);
                if (lineText.startsWith(spacedTab)) {
                    doc.remove(lineStart, tabSize);
                } else if (lineText.charAt(0) == '\t') {
                    doc.remove(lineStart, 1);
                } else {
                    int cnt = 0;
                    while (lineText.charAt(cnt) == ' ') {
                        ++cnt;
                    }
                    doc.remove(lineStart, cnt);
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    class IndentLineAction
    implements LineAction {
        IndentLineAction() {
        }

        @Override
        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            try {
                doc.insertString(lineStart, MoeActions.spaces.substring(0, tabSize), null);
            }
            catch (BadLocationException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    class UncommentLineAction
    implements LineAction {
        UncommentLineAction() {
        }

        @Override
        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            try {
                String lineText = doc.getText(lineStart, lineEnd - lineStart);
                if (lineText.trim().startsWith("//")) {
                    int cnt = 0;
                    while (lineText.charAt(cnt) != '/') {
                        ++cnt;
                    }
                    if (lineText.charAt(cnt + 2) == ' ') {
                        doc.remove(lineStart, cnt + 3);
                    } else {
                        doc.remove(lineStart, cnt + 2);
                    }
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    class CommentLineAction
    implements LineAction {
        CommentLineAction() {
        }

        @Override
        public void apply(Element line, MoeSyntaxDocument doc) {
            int lineStart = line.getStartOffset();
            try {
                doc.insertString(lineStart, "// ", null);
            }
            catch (BadLocationException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    static interface LineAction {
        public void apply(Element var1, MoeSyntaxDocument var2);
    }

    class GoToLineAction
    extends MoeAbstractAction {
        public GoToLineAction() {
            super("go-to-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).goToLine();
        }
    }

    class HelpMouseAction
    extends MoeAbstractAction {
        public HelpMouseAction() {
            super("help-mouse");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.getEditor(e), new String[]{"Moe Mouse Buttons:", " ", "left button:", "   click: place cursor", "   double-click: select word", "   triple-click: select line", "   drag: make selection", " ", "right button:", "   (currently unused)"}, "Moe Mouse Buttons", 1);
        }
    }

    class DescribeKeyAction
    extends MoeAbstractAction {
        public DescribeKeyAction() {
            super("describe-key");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            textComponent.addKeyListener(MoeActions.this.keyCatcher);
            MoeEditor ed = this.getEditor(e);
            MoeActions.this.keyCatcher.setEditor(ed);
            ed.writeMessage("Describe key: ");
        }
    }

    class AboutAction
    extends MoeAbstractAction {
        public AboutAction() {
            super("about-editor");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(this.getEditor(e), new String[]{"Moe", "Version 3.0.0", " ", "Moe is the editor of the BlueJ programming environment.", "Written by Michael K\u00f6lling (mik@bluej.org)."}, "About Moe", 1);
        }
    }

    class PreferencesAction
    extends MoeAbstractAction {
        public PreferencesAction() {
            super("preferences");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrefMgrDialog.showDialog((int)0);
        }
    }

    class KeyBindingsAction
    extends MoeAbstractAction {
        public KeyBindingsAction() {
            super("key-bindings");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrefMgrDialog.showDialog((int)1);
        }
    }

    class ToggleBreakPointAction
    extends MoeAbstractAction {
        public ToggleBreakPointAction() {
            super("toggle-breakpoint");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).toggleBreakpoint();
        }
    }

    class ToggleInterfaceAction
    extends MoeAbstractAction {
        public ToggleInterfaceAction() {
            super("toggle-interface-view");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JComboBox) {
                this.getEditor(e).toggleInterface();
            } else {
                this.getEditor(e).toggleInterfaceMenu();
            }
        }
    }

    class CompileAction
    extends MoeAbstractAction {
        public CompileAction() {
            super("compile");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).compile();
        }
    }

    class ReplaceAction
    extends MoeAbstractAction {
        public ReplaceAction() {
            super("replace");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            if (editor != null) {
                editor.setFindPanelVisible();
                editor.setReplacePanelVisible(true);
                if (editor.getSourcePane().getSelectedText() != null) {
                    editor.setFindTextfield(editor.getSourcePane().getSelectedText());
                }
            }
        }
    }

    public class FindNextBackwardAction
    extends MoeAbstractAction {
        public FindNextBackwardAction() {
            super("find-next-backward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).findNext(true);
        }
    }

    public class FindNextAction
    extends MoeAbstractAction {
        public FindNextAction() {
            super("find-next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).findNext(false);
        }
    }

    class FindAction
    extends MoeAbstractAction {
        public FindAction() {
            super("find");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            if (editor != null) {
                editor.initFindPanel();
            }
        }
    }

    class SelectWordAction
    extends MoeAbstractAction {
        public SelectWordAction() {
            super("select-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            int origPos = c.getCaret().getDot();
            int newStart = MoeActions.findWordLimit(c, origPos, false);
            int newEnd = MoeActions.findWordLimit(c, origPos, true);
            c.getCaret().setDot(newStart);
            c.getCaret().moveDot(newEnd);
        }
    }

    class DeleteWordAction
    extends MoeAbstractAction {
        public DeleteWordAction() {
            super("delete-previous-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            Action prevWordAct = (Action)MoeActions.this.actions.get("caret-previous-word");
            int end = c.getCaret().getDot();
            prevWordAct.actionPerformed(e);
            int begin = c.getCaret().getDot();
            try {
                c.getDocument().remove(begin, end - begin);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class BeginWordAction
    extends MoeActionWithOrWithoutSelection {
        public BeginWordAction(boolean withSelection) {
            super(withSelection ? "selection-begin-word" : "caret-begin-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            int origPos = c.getCaret().getDot();
            int start = MoeActions.findWordLimit(c, origPos, false);
            this.moveCaret(c, start);
        }
    }

    class EndWordAction
    extends MoeActionWithOrWithoutSelection {
        public EndWordAction(boolean withSelection) {
            super(withSelection ? "selection-end-word" : "caret-end-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            int origPos = c.getCaret().getDot();
            int end = MoeActions.findWordLimit(c, origPos, true);
            this.moveCaret(c, end);
        }
    }

    class PrevWordAction
    extends MoeActionWithOrWithoutSelection {
        public PrevWordAction(boolean withSelection) {
            super(withSelection ? "selection-previous-word" : "caret-previous-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            int origPos = c.getCaret().getDot();
            if (origPos == 0) {
                return;
            }
            try {
                if (Character.isWhitespace(c.getText(origPos - 1, 1).charAt(0))) {
                    int startOfWS = MoeActions.findWordLimit(c, origPos - 1, false);
                    int startOfPrevWord = MoeActions.findWordLimit(c, startOfWS - 1, false);
                    this.moveCaret(c, startOfPrevWord);
                } else {
                    int startOfWord = MoeActions.findWordLimit(c, origPos - 1, false);
                    this.moveCaret(c, startOfWord);
                }
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class NextWordAction
    extends MoeActionWithOrWithoutSelection {
        public NextWordAction(boolean withSelection) {
            super(withSelection ? "selection-next-word" : "caret-next-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            int origPos = c.getCaret().getDot();
            int end = MoeActions.findWordLimit(c, origPos, true);
            try {
                if (Character.isWhitespace(c.getText(end, 1).charAt(0))) {
                    int endOfWS = MoeActions.findWordLimit(c, end, true);
                    this.moveCaret(c, endOfWS);
                } else {
                    this.moveCaret(c, end);
                }
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private abstract class MoeActionWithOrWithoutSelection
    extends MoeAbstractAction {
        private boolean withSelection;

        protected MoeActionWithOrWithoutSelection(String actionName, boolean withSelection) {
            super(actionName);
            this.withSelection = withSelection;
        }

        protected void moveCaret(JTextComponent c, int pos) {
            if (this.withSelection) {
                c.getCaret().moveDot(pos);
            } else {
                c.setCaretPosition(pos);
            }
        }
    }

    class CutEndOfWordAction
    extends MoeAbstractAction {
        public CutEndOfWordAction() {
            super("cut-end-of-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class ContentAssistAction
    extends MoeAbstractAction {
        public ContentAssistAction() {
            super("code-completion");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            if (Config.getPropBoolean((String)"bluej.editor.codecompletion", (boolean)true)) {
                editor.createContentAssist();
            }
        }
    }

    class CutWordAction
    extends MoeAbstractAction {
        public CutWordAction() {
            super("cut-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-previous-word").actionPerformed(e);
            MoeActions.this.getActionByName("selection-next-word").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CutEndOfLineAction
    extends MoeAbstractAction {
        public CutEndOfLineAction() {
            super("cut-end-of-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("selection-end-line").actionPerformed(e);
            JTextComponent textComponent = this.getTextComponent(e);
            String selection = textComponent.getSelectedText();
            if (selection == null) {
                MoeActions.this.getActionByName("selection-forward").actionPerformed(e);
            }
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(textComponent);
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class DecreaseFontAction
    extends MoeAbstractAction {
        public DecreaseFontAction() {
            super("decrease-font");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textPane = this.getTextComponent(e);
            Font textPFont = textPane.getFont();
            int newFont = textPFont.getSize() - 1;
            PrefMgr.setEditorFontSize((int)newFont);
            this.getTextComponent(e).setFont(textPFont.deriveFont((float)newFont));
        }
    }

    class IncreaseFontAction
    extends MoeAbstractAction {
        public IncreaseFontAction() {
            super("increase-font");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textPane = this.getTextComponent(e);
            Font textPFont = textPane.getFont();
            int newFont = textPFont.getSize() + 1;
            PrefMgr.setEditorFontSize((int)newFont);
            this.getTextComponent(e).setFont(textPane.getFont().deriveFont((float)newFont));
        }
    }

    class CutLineAction
    extends MoeAbstractAction {
        public CutLineAction() {
            super("cut-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(e);
            MoeActions.this.getActionByName("selection-down").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
                MoeActions.this.getActionByName("delete-previous").actionPerformed(e);
            } else {
                MoeActions.this.getActionByName("cut-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class CopyLineAction
    extends MoeAbstractAction {
        public CopyLineAction() {
            super("copy-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean addToClipboard = MoeActions.this.lastActionWasCut;
            MoeActions.this.getActionByName("caret-begin-line").actionPerformed(e);
            MoeActions.this.getActionByName("selection-down").actionPerformed(e);
            if (addToClipboard) {
                MoeActions.this.addSelectionToClipboard(this.getTextComponent(e));
            } else {
                MoeActions.this.getActionByName("copy-to-clipboard").actionPerformed(e);
            }
            MoeActions.this.lastActionWasCut = true;
        }
    }

    class NewLineAction
    extends MoeAbstractAction {
        public NewLineAction() {
            super("new-line");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action action = (Action)MoeActions.this.actions.get("insert-break");
            action.actionPerformed(e);
            if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                JTextComponent textPane = this.getTextComponent(e);
                MoeActions.this.doIndent(textPane, true);
            }
        }
    }

    class DeIndentAction
    extends MoeAbstractAction {
        public DeIndentAction() {
            super("de-indent");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textPane = this.getTextComponent(e);
            MoeEditor ed = this.getEditor(e);
            if (MoeActions.haveSelection(textPane)) {
                MoeActions.this.doBlockDeIndent(ed);
            } else {
                if (ed.checkExpandTabs()) {
                    ed.setCaretActive(false);
                    int converted = MoeActions.this.convertTabsToSpaces(textPane);
                    ed.setCaretActive(true);
                    if (converted > 0) {
                        ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
                    }
                }
                MoeActions.this.doDeIndent(textPane);
            }
        }
    }

    class IndentAction
    extends MoeAbstractAction {
        public IndentAction() {
            super("indent");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textPane = this.getTextComponent(e);
            MoeEditor ed = this.getEditor(e);
            if (MoeActions.haveSelection(textPane)) {
                MoeActions.this.doBlockIndent(ed);
            } else {
                int converted = 0;
                if (ed.checkExpandTabs()) {
                    ed.setCaretActive(false);
                    converted = MoeActions.this.convertTabsToSpaces(textPane);
                    ed.setCaretActive(true);
                }
                if (PrefMgr.getFlag((String)"bluej.editor.autoIndent")) {
                    MoeActions.this.doIndent(textPane, false);
                } else {
                    MoeActions.insertSpacedTab(textPane);
                }
                if (converted > 0) {
                    ed.writeMessage(Config.getString((String)"editor.info.tabsExpanded"));
                }
            }
        }
    }

    class AddJavadocAction
    extends MoeAbstractAction {
        public AddJavadocAction() {
            super("add-javadoc");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            if (!editor.containsSourceCode()) {
                return;
            }
            int caretPos = editor.getCurrentTextPane().getCaretPosition();
            NodeTree.NodeAndPosition node = editor.getParsedNode().findNodeAt(caretPos, 0);
            while (node != null && ((ParsedNode)node.getNode()).getNodeType() != 2) {
                node = ((ParsedNode)node.getNode()).findNodeAt(caretPos, node.getPosition());
            }
            if (node == null || !(node.getNode() instanceof MethodNode)) {
                editor.writeMessage(Config.getString((String)"editor.addjavadoc.notAMethod"));
            } else {
                MethodNode methodNode = (MethodNode)node.getNode();
                boolean hasJavadocComment = false;
                Iterator it = methodNode.getChildren(node.getPosition());
                while (it.hasNext()) {
                    ParsedNode subNode = (ParsedNode)((NodeTree.NodeAndPosition)it.next()).getNode();
                    if (!(subNode instanceof CommentNode)) continue;
                    hasJavadocComment = hasJavadocComment || ((CommentNode)subNode).isJavadocComment();
                }
                if (hasJavadocComment) {
                    editor.writeMessage(Config.getString((String)"editor.addjavadoc.hasJavadoc"));
                } else {
                    JavaType retType;
                    StringBuilder indent = new StringBuilder();
                    int column = editor.getLineColumnFromOffset(node.getPosition()).getColumn();
                    for (int i = 0; i < column - 1; ++i) {
                        indent.append(' ');
                    }
                    StringBuilder newComment = new StringBuilder();
                    newComment.append("/**\n");
                    JavaEntity retTypeEntity = methodNode.getReturnType();
                    if (retTypeEntity == null) {
                        newComment.append((CharSequence)indent).append(" * ").append(methodNode.getName()).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.constructor")).append("\n");
                    } else {
                        newComment.append((CharSequence)indent).append(" * ").append(Config.getString((String)"editor.addjavadoc.method"));
                        newComment.append(" ").append(methodNode.getName()).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" *\n");
                    for (String s : methodNode.getParamNames()) {
                        newComment.append((CharSequence)indent).append(" * @param ").append(s).append(" ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.parameter")).append("\n");
                    }
                    if (retTypeEntity != null && (retType = retTypeEntity.resolveAsType().getType()) != null && !retType.isVoid()) {
                        newComment.append((CharSequence)indent).append(" * @return ");
                        newComment.append(Config.getString((String)"editor.addjavadoc.returnValue")).append("\n");
                    }
                    newComment.append((CharSequence)indent).append(" */\n").append((CharSequence)indent);
                    editor.undoManager.beginCompoundEdit();
                    editor.getCurrentTextPane().setCaretPosition(node.getPosition());
                    editor.getCurrentTextPane().replaceSelection(newComment.toString());
                    editor.getCurrentTextPane().setCaretPosition(caretPos + newComment.length());
                    editor.undoManager.endCompoundEdit();
                }
            }
        }
    }

    class InsertMethodAction
    extends MoeAbstractAction {
        public InsertMethodAction() {
            super("insert-method");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            if (!editor.containsSourceCode()) {
                return;
            }
            editor.undoManager.beginCompoundEdit();
            MoeActions.insertTemplate(this.getTextComponent(e), editor, "method");
            editor.undoManager.endCompoundEdit();
        }
    }

    class AutoIndentAction
    extends MoeAbstractAction {
        public AutoIndentAction() {
            super("autoindent");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            MoeSyntaxDocument doc = editor.getSourceDocument();
            if (doc.getParsedNode() == null) {
                return;
            }
            int prevCaretPos = editor.getSourcePane().getCaretPosition();
            editor.setCaretActive(false);
            editor.undoManager.beginCompoundEdit();
            MoeIndent.AutoIndentInformation info = MoeIndent.calculateIndentsAndApply(doc, prevCaretPos);
            editor.undoManager.endCompoundEdit();
            editor.setCaretPositionForward(info.getNewCaretPosition() - prevCaretPos);
            editor.setCaretActive(true);
            if (info.isPerfect()) {
                editor.writeMessage(Config.getString((String)"editor.info.perfectIndent"));
            }
        }
    }

    class DeindentBlockAction
    extends MoeAbstractAction {
        public DeindentBlockAction() {
            super("deindent-block");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeActions.this.doBlockDeIndent(this.getEditor(e));
        }
    }

    class IndentBlockAction
    extends MoeAbstractAction {
        public IndentBlockAction() {
            super("indent-block");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeActions.this.doBlockIndent(this.getEditor(e));
        }
    }

    class UncommentBlockAction
    extends MoeAbstractAction {
        public UncommentBlockAction() {
            super("uncomment-block");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            editor.undoManager.beginCompoundEdit();
            MoeActions.blockAction(editor, new UncommentLineAction());
            editor.undoManager.endCompoundEdit();
        }
    }

    class CommentBlockAction
    extends MoeAbstractAction {
        public CommentBlockAction() {
            super("comment-block");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            editor.undoManager.beginCompoundEdit();
            MoeActions.blockAction(editor, new CommentLineAction());
            editor.undoManager.endCompoundEdit();
        }
    }

    public class RedoAction
    extends MoeAbstractAction {
        public RedoAction() {
            super("redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            try {
                editor.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                Debug.message((String)"moe: cannot redo...");
            }
            editor.updateUndoControls();
            editor.updateRedoControls();
        }
    }

    public class UndoAction
    extends MoeAbstractAction {
        public UndoAction() {
            super("undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor editor = this.getEditor(e);
            try {
                editor.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                Debug.message((String)"moe: cannot undo...");
            }
            editor.updateUndoControls();
            editor.updateRedoControls();
        }
    }

    class CloseAction
    extends MoeAbstractAction {
        public CloseAction() {
            super("close");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).close();
        }
    }

    class PageSetupAction
    extends MoeAbstractAction {
        public PageSetupAction() {
            super("page-setup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MoeEditor.pageSetup();
        }
    }

    class PrintAction
    extends MoeAbstractAction {
        public PrintAction() {
            super("print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).print();
        }
    }

    class ReloadAction
    extends MoeAbstractAction {
        public ReloadAction() {
            super("reload");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).reload();
        }
    }

    class SaveAction
    extends MoeAbstractAction {
        public SaveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getEditor(e).userSave();
        }
    }

    abstract class MoeAbstractAction
    extends TextAction {
        public MoeAbstractAction(String name) {
            super(name);
        }

        protected final MoeEditor getEditor(ActionEvent e) {
            Container c;
            JTextComponent textComponent;
            Container c2;
            MoeEditor ed = null;
            Object source = e.getSource();
            if (source instanceof JComponent && (c2 = ((JComponent)source).getTopLevelAncestor()) instanceof MoeEditor) {
                ed = (MoeEditor)c2;
            }
            if (ed == null && (textComponent = this.getTextComponent(e)) != null && (c = textComponent.getTopLevelAncestor()) instanceof MoeEditor) {
                ed = (MoeEditor)c;
            }
            if (ed != null) {
                ed.clearMessage();
            }
            return ed;
        }
    }
}

