/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.views.Comment;
import bluej.views.View;
import java.lang.reflect.Modifier;

public abstract class MemberView {
    private View view;
    private Comment comment;

    protected MemberView(View view) {
        if (view == null) {
            throw new NullPointerException();
        }
        this.view = view;
    }

    public View getDeclaringView() {
        return this.view;
    }

    public String getClassName() {
        return this.view.getQualifiedName();
    }

    public abstract int getModifiers();

    public abstract String getSignature();

    void setComment(Comment comment) {
        this.comment = comment;
    }

    public Comment getComment() {
        if (this.view != null) {
            this.view.loadComments();
        }
        return this.comment;
    }

    public abstract String getShortDesc();

    public abstract String getLongDesc();

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public String toString() {
        return this.view.toString();
    }
}

