/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.parser.CodeSuggestions;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.UnresolvedArray;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import javax.swing.text.Document;

public class FieldNode
extends JavaParentNode {
    private String name;
    private JavaEntity fieldType;
    private FieldNode firstNode;
    private int modifiers;
    private int arrayDecls;

    public FieldNode(JavaParentNode parent, String name, JavaEntity fieldType, int arrayDecls, int modifiers) {
        super(parent);
        this.name = name;
        this.fieldType = fieldType;
        this.arrayDecls = arrayDecls;
        this.modifiers = modifiers;
    }

    public FieldNode(JavaParentNode parent, String name, FieldNode firstNode, int arrayDecls) {
        super(parent);
        this.name = name;
        this.firstNode = firstNode;
        this.arrayDecls = arrayDecls;
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    public JavaEntity getFieldType() {
        JavaEntity ftype = this.firstNode == null ? this.fieldType : this.firstNode.fieldType;
        for (int i = 0; i < this.arrayDecls; ++i) {
            ftype = new UnresolvedArray(ftype);
        }
        return ftype;
    }

    public int getModifiers() {
        if (this.firstNode != null) {
            return this.firstNode.getModifiers();
        }
        return this.modifiers;
    }

    @Override
    protected CodeSuggestions getExpressionType(int pos, int nodePos, JavaEntity defaultType, Document document) {
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(Math.max(pos - 1, 0), nodePos);
        if (child != null) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document);
        }
        return ExpressionNode.suggestAsExpression(pos, nodePos, this, defaultType, document);
    }
}

