/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.role.StdClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class ClassInspector
extends Inspector {
    protected static final String CLASS_INSPECT_TITLE = Config.getString("debugger.inspector.class.title");
    protected static final String CLASS_NAME_LABEL = Config.getString("debugger.inspector.class.nameLabel");
    protected static final String ENUM_INSPECT_TITLE = Config.getString("debugger.inspector.enum.title");
    protected static final String ENUM_NAME_LABEL = Config.getString("debugger.inspector.enum.nameLabel");
    protected static final String INTERFACE_INSPECT_TITLE = Config.getString("debugger.inspector.interface.title");
    protected static final String INTERFACE_NAME_LABEL = Config.getString("debugger.inspector.interface.nameLabel");
    protected static final String noFieldsMsg = Config.getString("debugger.inspector.class.noFields");
    protected static final String numFields = Config.getString("debugger.inspector.numFields");
    protected DebuggerClass myClass;

    public ClassInspector(DebuggerClass clss, InspectorManager inspectorManager, Package pkg, InvokerRecord ir, JFrame parent) {
        super(inspectorManager, pkg, ir, new Color(249, 230, 207));
        this.myClass = clss;
        ClassInspector insp = this;
        this.makeFrame();
        this.update();
        this.updateLayout();
        this.pack();
        if (parent instanceof Inspector) {
            DialogManager.tileWindow(insp, parent);
        } else {
            DialogManager.centreWindow(insp, parent);
        }
        this.installListenersForMoveDrag();
    }

    protected void makeFrame() {
        this.setUndecorated(true);
        String className = JavaNames.stripPrefix(this.myClass.getName());
        String headerString = null;
        String suffix = " " + numFields + " " + this.getListData().size();
        if (this.myClass.isEnum()) {
            this.setTitle(ENUM_INSPECT_TITLE + " " + className + suffix);
            headerString = ENUM_NAME_LABEL + " " + className;
        } else if (this.myClass.isInterface()) {
            this.setTitle(INTERFACE_INSPECT_TITLE + " " + className + suffix);
            headerString = INTERFACE_NAME_LABEL + " " + className;
        } else {
            this.setTitle(CLASS_INSPECT_TITLE + " " + className + suffix);
            headerString = CLASS_NAME_LABEL + " " + className;
        }
        JPanel header = new JPanel();
        if (!Config.isRaspberryPi()) {
            header.setOpaque(false);
        }
        header.setLayout(new BoxLayout(header, 1));
        JLabel headerLabel = new JLabel(headerString);
        headerLabel.setAlignmentX(0.5f);
        header.add(headerLabel);
        header.add(Box.createVerticalStrut(5));
        JSeparator sep = new JSeparator();
        sep.setForeground(new Color(217, 175, 150));
        if (!Config.isRaspberryPi()) {
            sep.setBackground(new Color(0, 0, 0, 0));
        } else {
            sep.setBackground(new Color(0, 0, 0));
        }
        header.add(sep);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        if (!Config.isRaspberryPi()) {
            mainPanel.setOpaque(false);
        }
        if (this.getListData().size() != 0) {
            JScrollPane scrollPane = this.createFieldListScrollPane();
            mainPanel.add((Component)scrollPane, "Center");
        } else {
            JLabel lab = new JLabel("  " + noFieldsMsg);
            lab.setPreferredSize(new Dimension(200, 30));
            lab.setFont(PrefMgr.getStandardFont().deriveFont(20.0f));
            lab.setForeground(new Color(160, 120, 77));
            mainPanel.add(lab);
        }
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            bottomPanel.setOpaque(false);
        }
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        if (!Config.isRaspberryPi()) {
            buttonPanel.setOpaque(false);
        }
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        bottomPanel.add(buttonPanel);
        JPanel contentPane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new StdClassRole().getBackgroundPaint(this.getWidth(), this.getHeight()));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setColor(Color.BLACK);
                g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    protected boolean showingResult() {
        return false;
    }

    @Override
    protected List<FieldInfo> getListData() {
        List<DebuggerField> fields = this.myClass.getStaticFields();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>(fields.size());
        for (DebuggerField field : fields) {
            String desc = Inspector.fieldToString(field);
            String value = field.getValueString();
            fieldInfos.add(new FieldInfo(desc, value));
        }
        return fieldInfos;
    }

    @Override
    protected void listElementSelected(int slot) {
        DebuggerField field = this.myClass.getStaticField(slot);
        if (field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(null), field.getName(), field.getType().toString());
            if (Modifier.isPublic(field.getModifiers())) {
                this.setButtonsEnabled(true, true);
            } else {
                this.setButtonsEnabled(true, false);
            }
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
    }

    protected void prepareInspection() {
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.myClass);
        }
    }

    protected void initInspectors(JTabbedPane inspTabs) {
    }

    @Override
    protected int getPreferredRows() {
        return 8;
    }
}

