/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeArrayClass;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.jdi.JdiArrayReflective;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class JdiArray
extends JdiObject {
    private JavaType componentType;

    protected JdiArray(ArrayReference obj) {
        this.obj = obj;
        obj.disableCollection();
        this.calcComponentType();
    }

    protected JdiArray(ArrayReference obj, JavaType expectedType) {
        this.obj = obj;
        obj.disableCollection();
        if (expectedType instanceof GenTypeArray) {
            String ctypestr = obj.referenceType().signature();
            JavaType genericType = expectedType;
            int level = 0;
            while (genericType instanceof GenTypeArray) {
                GenTypeArray genericArray = (GenTypeArray)genericType;
                genericType = genericArray.getArrayComponent();
                ctypestr = ctypestr.substring(1);
                ++level;
            }
            if (ctypestr.charAt(0) == '[') {
                this.calcComponentType();
                return;
            }
            if (genericType.isPrimitive()) {
                this.calcComponentType();
                return;
            }
            if (genericType instanceof GenTypeClass) {
                String compName = ctypestr.substring(1, ctypestr.length() - 1);
                compName = compName.replace('/', '.');
                JdiReflective compReflective = new JdiReflective(compName, obj.referenceType());
                GenTypeSolid component = ((GenTypeClass)genericType).mapToDerived(compReflective);
                while (level > 1) {
                    component = ((JavaType)component).getArray();
                    --level;
                }
                this.componentType = component;
            }
        }
        if (this.componentType == null) {
            this.calcComponentType();
        }
    }

    private void calcComponentType() {
        ArrayType ar = (ArrayType)this.obj.referenceType();
        String componentSig = ar.componentSignature();
        JdiReflective.StringIterator i = new JdiReflective.StringIterator(componentSig);
        this.componentType = JdiReflective.typeFromSignature(i, null, ar);
    }

    @Override
    public String getClassName() {
        return this.obj.referenceType().name();
    }

    @Override
    public GenTypeClass getGenType() {
        JdiArrayReflective r = new JdiArrayReflective(this.componentType, this.obj.referenceType());
        return new GenTypeArrayClass((Reflective)r, this.componentType);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getElementCount() {
        return ((ArrayReference)this.obj).length();
    }

    @Override
    public JavaType getElementType() {
        return this.componentType;
    }

    @Override
    public String getElementValueString(int index) {
        Value val = ((ArrayReference)this.obj).getValue(index);
        return JdiUtils.getJdiUtils().getValueString(val);
    }

    @Override
    public DebuggerObject getElementObject(int index) {
        Value val = ((ArrayReference)this.obj).getValue(index);
        return JdiObject.getDebuggerObject((ObjectReference)val, this.componentType);
    }
}

