/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HDTimer {
    private static Long sleepPrecision;
    private static long worstYieldTime;
    private static boolean inited;
    private static Long waitPrecision;

    static {
        HDTimer.init();
    }

    public static synchronized void init() {
        if (!inited) {
            HDTimer.measureSleepPrecision();
            HDTimer.measureWaitPrecision();
            inited = true;
        }
    }

    private static void measureSleepPrecision() {
        int testSize = 11;
        ArrayList<Long> tests = new ArrayList<Long>();
        try {
            int i = 0;
            while (i < testSize) {
                long t1 = System.nanoTime();
                Thread.sleep(0L, 1);
                long t2 = System.nanoTime();
                tests.add(t2 - t1);
                ++i;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(tests);
        sleepPrecision = (Long)tests.get(testSize / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measureWaitPrecision() {
        int testSize = 11;
        ArrayList<Long> tests = new ArrayList<Long>();
        Object lock = new Object();
        try {
            Object object = lock;
            synchronized (object) {
                int i = 0;
                while (i < testSize) {
                    long t1 = System.nanoTime();
                    lock.wait(0L, 1);
                    long t2 = System.nanoTime();
                    tests.add(t2 - t1);
                    ++i;
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(tests);
        waitPrecision = (Long)tests.get(testSize / 2);
    }

    public static void sleep(long nanos) throws InterruptedException {
        long tStart = System.nanoTime();
        HDTimer.sleepFromTime(nanos, tStart);
    }

    private static void sleepFromTime(long nanos, long tStart) throws InterruptedException {
        long sleepNanos = nanos - sleepPrecision;
        if (nanos / sleepPrecision >= 2L) {
            long actualDelayMillis = sleepNanos / 1000000L;
            int nanoRest = (int)(sleepNanos % 1000000L);
            if (Thread.interrupted()) {
                throw new InterruptedException("HDTimer.sleepFromTime interrupted in sleep.");
            }
            Thread.sleep(actualDelayMillis, nanoRest);
        }
        while (System.nanoTime() - tStart + worstYieldTime < nanos) {
            long t1 = System.nanoTime();
            if (Thread.interrupted()) {
                throw new InterruptedException("HDTimer.sleepFromTime interrupted in yield.");
            }
            Thread.yield();
            long yieldTime = System.nanoTime() - t1;
            if (yieldTime <= worstYieldTime) continue;
            worstYieldTime = yieldTime;
        }
        while (System.nanoTime() - tStart < nanos) {
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("HDTimer.sleepFromTime interrupted in busy loop.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(long nanos, Object lock) throws InterruptedException {
        long tStart = System.nanoTime();
        for (long waits = 0L; System.nanoTime() - tStart < nanos - waitPrecision || waits == 0L; ++waits) {
            long waitNanos = tStart - System.nanoTime() - waitPrecision;
            long actualDelayMillis = waitNanos / 1000000L;
            int nanoRest = (int)(waitNanos % 1000000L);
            if (actualDelayMillis <= 0L && nanoRest <= 0) {
                actualDelayMillis = 0L;
                nanoRest = 1;
            }
            Object object = lock;
            synchronized (object) {
                lock.wait(actualDelayMillis, nanoRest);
                continue;
            }
        }
        while (System.nanoTime() - tStart + worstYieldTime < nanos) {
            long t1 = System.nanoTime();
            Thread.yield();
            long yieldTime = System.nanoTime() - t1;
            if (yieldTime <= worstYieldTime) continue;
            worstYieldTime = yieldTime;
        }
        while (System.nanoTime() - tStart < nanos) {
        }
    }

    public static void wait(long nanos, ReentrantReadWriteLock lock) throws InterruptedException {
        long tStart = System.nanoTime();
        if (!lock.isWriteLockedByCurrentThread()) {
            HDTimer.sleepFromTime(nanos, tStart);
            return;
        }
        lock.writeLock().unlock();
        try {
            HDTimer.sleepFromTime(nanos, tStart);
        }
        finally {
            lock.writeLock().lock();
        }
    }
}

