/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.views.CallableView;
import greenfoot.Actor;
import greenfoot.ObjectTracker;
import greenfoot.World;
import greenfoot.actions.SaveWorldAction;
import greenfoot.core.ClassStateManager;
import greenfoot.core.GClass;
import greenfoot.core.GNamedValue;
import greenfoot.core.GProject;
import greenfoot.core.ImageCache;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.core.WorldInvokeListener;
import greenfoot.event.SimulationUIListener;
import greenfoot.gui.DragGlassPane;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.input.InputManager;
import greenfoot.localdebugger.LocalObject;
import greenfoot.platforms.WorldHandlerDelegate;
import greenfoot.record.GreenfootRecorder;
import greenfoot.record.InteractionListener;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RProject;

public class WorldHandlerDelegateIDE
implements WorldHandlerDelegate,
ObjectBenchInterface,
InteractionListener,
SimulationUIListener {
    protected final Color envOpColour = Config.ENV_COLOUR;
    private static final int WORLD_INITIALISING_TIMEOUT = 4000;
    private WorldHandler worldHandler;
    private GProject project;
    private GreenfootFrame frame;
    private InspectorManager inspectorManager;
    private GreenfootRecorder greenfootRecorder;
    private SaveWorldAction saveWorldAction;
    private boolean worldInitialising;
    private long startedInitialisingAt;
    private boolean worldInvocationError;
    private boolean missingConstructor;
    private boolean vmRestarted;

    public WorldHandlerDelegateIDE(GreenfootFrame frame, InspectorManager inspectorManager, ClassStateManager classStateManager) {
        this.frame = frame;
        this.inspectorManager = inspectorManager;
        this.greenfootRecorder = new GreenfootRecorder();
        this.saveWorldAction = new SaveWorldAction(this.greenfootRecorder, classStateManager);
        this.saveWorldAction.setRecordingValid(false);
    }

    public JPopupMenu makeActorPopupMenu(final Actor obj) {
        JPopupMenu menu = new JPopupMenu();
        ObjectWrapper.createMethodMenuItems((JPopupMenu)menu, obj.getClass(), (InvokeListener)new WorldInvokeListener((JFrame)this.frame, obj, (ObjectBenchInterface)this, this.inspectorManager, (InteractionListener)this, this.project), (DebuggerObject)LocalObject.getLocalObject(obj), null, (boolean)false);
        JMenuItem m = this.getInspectMenuItem(obj);
        menu.add(m);
        m = new JMenuItem(Config.getString((String)"world.handlerDelegate.remove"));
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldHandlerDelegateIDE.this.worldHandler.getWorld().removeObject(obj);
                WorldHandlerDelegateIDE.this.removedActor(obj);
                WorldHandlerDelegateIDE.this.worldHandler.repaint();
            }
        });
        m.setFont(PrefMgr.getStandoutMenuFont());
        m.setForeground(this.envOpColour);
        menu.add(m);
        return menu;
    }

    public JPopupMenu makeWorldPopupMenu(World world) {
        if (world == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        ObjectWrapper.createMethodMenuItems((JPopupMenu)menu, world.getClass(), (InvokeListener)new WorldInvokeListener((JFrame)this.frame, world, (ObjectBenchInterface)this, this.inspectorManager, (InteractionListener)this, this.project), (DebuggerObject)LocalObject.getLocalObject(world), null, (boolean)false);
        JMenuItem m = this.getInspectMenuItem(world);
        JMenuItem saveTheWorld = new JMenuItem(this.saveWorldAction);
        saveTheWorld.setFont(PrefMgr.getStandoutMenuFont());
        saveTheWorld.setForeground(this.envOpColour);
        menu.add(m);
        menu.add(saveTheWorld);
        return menu;
    }

    private JMenuItem getInspectMenuItem(final Object obj) {
        JMenuItem m = new JMenuItem(Config.getString((String)"world.handlerDelegate.inspect"));
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame parent = (JFrame)WorldHandlerDelegateIDE.this.worldHandler.getWorldCanvas().getTopLevelAncestor();
                LocalObject dObj = LocalObject.getLocalObject(obj);
                String instanceName = "";
                try {
                    RObject rObject = ObjectTracker.getRObject(obj);
                    if (rObject != null) {
                        instanceName = rObject.getInstanceName();
                    }
                }
                catch (RemoteException e1) {
                    Debug.reportError((String)"Could not get instance name for inspection", (Throwable)e1);
                }
                WorldHandlerDelegateIDE.this.inspectorManager.getInspectorInstance((DebuggerObject)dObj, instanceName, null, null, parent);
            }
        });
        m.setFont(PrefMgr.getStandoutMenuFont());
        m.setForeground(this.envOpColour);
        return m;
    }

    @Override
    public boolean maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Actor obj = this.worldHandler.getObject(e.getX(), e.getY());
            JPopupMenu menu = obj == null ? this.makeWorldPopupMenu(this.worldHandler.getWorld()) : this.makeActorPopupMenu(obj);
            if (menu != null) {
                menu.show(this.worldHandler.getWorldCanvas(), e.getX(), e.getY());
            }
            return true;
        }
        return false;
    }

    public void showWorldPopupMenu(MouseEvent e) {
        JPopupMenu menu = this.makeWorldPopupMenu(this.worldHandler.getWorld());
        if (menu != null) {
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void discardWorld(World world) {
        ObjectTracker.clearRObjectCache();
        this.frame.stopWaitingForAnswer();
    }

    @Override
    public void setWorld(World oldWorld, World newWorld) {
        String lastWorldClass;
        this.worldInvocationError = false;
        this.greenfootRecorder.clearCode(false);
        this.greenfootRecorder.setWorld(newWorld);
        if (oldWorld != null) {
            this.discardWorld(oldWorld);
        }
        GClass lastWorld = null;
        if (this.project != null && newWorld != null && (lastWorldClass = newWorld.getClass().getName()) != null) {
            lastWorld = this.project.getDefaultPackage().getClass(lastWorldClass);
        }
        this.saveWorldAction.setLastWorldGClass(lastWorld);
    }

    public void fireObjectEvent(Actor actor) {
        GNamedValue value = null;
        try {
            RObject rObj = ObjectTracker.getRObject(actor);
            if (rObj != null) {
                value = new GNamedValue(rObj.getInstanceName(), null);
            }
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Error when trying to get object instance name", (Throwable)e);
        }
        if (value != null) {
            Object[] listeners = this.worldHandler.getListenerList().getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == ObjectBenchListener.class) {
                    ((ObjectBenchListener)listeners[i + 1]).objectEvent(new ObjectBenchEvent((Object)this, 1, (NamedValue)value));
                }
                i -= 2;
            }
        }
    }

    public void addObjectBenchListener(ObjectBenchListener listener) {
        this.worldHandler.getListenerList().add(ObjectBenchListener.class, listener);
    }

    public void removeObjectBenchListener(ObjectBenchListener listener) {
        this.worldHandler.getListenerList().remove(ObjectBenchListener.class, listener);
    }

    public boolean hasObject(String name) {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Actor actor;
        if (SwingUtilities.isLeftMouseButton(e) && (actor = this.worldHandler.getObject(e.getX(), e.getY())) != null) {
            this.fireObjectEvent(actor);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.worldHandler.isDragging()) {
            Actor actor = this.worldHandler.getObject(e.getX(), e.getY());
            if (actor == null) {
                this.worldHandler.getWorldCanvas().setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.worldHandler.getWorldCanvas().setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    public void attachProject(Object project) {
        this.project = (GProject)project;
    }

    @Override
    public void setWorldHandler(WorldHandler handler) {
        this.worldHandler = handler;
    }

    @Override
    public void instantiateNewWorld() {
        RProject rProject = this.project.getRProject();
        try {
            if (!rProject.isVMRestarted()) {
                this.greenfootRecorder.reset();
                this.worldInitialising = true;
                this.worldInvocationError = false;
                Class<? extends World> cls = this.getLastWorldClass();
                GClass lastWorldGClass = this.getLastWorldGClass();
                if (lastWorldGClass == null) {
                    List<Class<? extends World>> worldClasses = this.project.getDefaultPackage().getWorldClasses();
                    if (worldClasses.isEmpty()) {
                        return;
                    }
                    for (Class<? extends World> wclass : worldClasses) {
                        try {
                            wclass.getConstructor(new Class[0]);
                            cls = wclass;
                            break;
                        }
                        catch (LinkageError linkageError) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (cls == null) {
                        this.missingConstructor = true;
                        return;
                    }
                }
                if (cls == null) {
                    return;
                }
                this.startedInitialisingAt = System.currentTimeMillis();
                this.frame.updateBackgroundMessage();
                final Timer timer = new Timer(4000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WorldHandlerDelegateIDE.this.worldInitialising) {
                            WorldHandlerDelegateIDE.this.frame.updateBackgroundMessage();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
                final Class<? extends World> icls = cls;
                Simulation.getInstance().runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Constructor cons = icls.getConstructor(new Class[0]);
                            WorldHandler.getInstance().clearWorldSet();
                            World newWorld = (World)Simulation.newInstance(cons);
                            if (!WorldHandler.getInstance().checkWorldSet()) {
                                ImageCache.getInstance().clearImageCache();
                                WorldHandler.getInstance().setWorld(newWorld);
                            }
                            WorldHandlerDelegateIDE.this.saveWorldAction.setRecordingValid(true);
                            WorldHandlerDelegateIDE.this.project.setLastWorldClassName(icls.getName());
                        }
                        catch (LinkageError cons) {
                        }
                        catch (NoSuchMethodException nsme) {
                            WorldHandlerDelegateIDE.this.missingConstructor = true;
                        }
                        catch (InstantiationException nsme) {
                        }
                        catch (IllegalAccessException e) {
                            WorldHandlerDelegateIDE.this.missingConstructor = true;
                        }
                        catch (InvocationTargetException ite) {
                            ite.getCause().printStackTrace();
                            WorldHandlerDelegateIDE.this.worldInvocationError = true;
                            WorldHandlerDelegateIDE.this.frame.updateBackgroundMessage();
                        }
                        catch (Exception e) {
                            System.err.println("Exception during World initialisation:");
                            e.printStackTrace();
                            WorldHandlerDelegateIDE.this.worldInvocationError = true;
                            WorldHandlerDelegateIDE.this.frame.updateBackgroundMessage();
                        }
                        WorldHandlerDelegateIDE.this.worldInitialising = false;
                        timer.stop();
                    }
                });
            } else {
                this.vmRestarted = true;
                rProject.setVmRestarted(false);
            }
        }
        catch (RemoteException ex) {
            Debug.reportError((String)"RemoteException checking VM state in WorldHandlerDelegateIDE", (Throwable)ex);
        }
    }

    public GClass getLastWorldGClass() {
        if (this.project == null) {
            return null;
        }
        String lastWorldClass = this.project.getLastWorldClassName();
        if (lastWorldClass == null) {
            return null;
        }
        return this.project.getDefaultPackage().getClass(lastWorldClass);
    }

    private Class<? extends World> getLastWorldClass() {
        Class<?> rclass;
        GClass gclass = this.getLastWorldGClass();
        if (gclass != null && GreenfootUtil.canBeInstantiated(rclass = gclass.getJavaClass())) {
            return rclass;
        }
        return null;
    }

    @Override
    public InputManager getInputManager() {
        InputManager inputManager = new InputManager();
        DragGlassPane.getInstance().addMouseListener(inputManager);
        DragGlassPane.getInstance().addMouseMotionListener(inputManager);
        DragGlassPane.getInstance().addKeyListener(inputManager);
        inputManager.setIdleListeners(this.worldHandler, this.worldHandler, this.worldHandler);
        inputManager.setDragListeners(null, DragGlassPane.getInstance(), DragGlassPane.getInstance());
        inputManager.setMoveListeners(this.worldHandler, this.worldHandler, this.worldHandler);
        return inputManager;
    }

    @Override
    public void beginCallExecution(CallableView callableView) {
        if (callableView.isConstructor() && World.class.isAssignableFrom(callableView.getDeclaringView().getViewClass())) {
            this.worldInitialising = true;
            this.greenfootRecorder.reset();
            this.saveWorldAction.setRecordingValid(true);
        }
    }

    @Override
    public void worldConstructed(Object world) {
        this.worldInitialising = false;
        if (this.project != null) {
            this.project.setLastWorldClassName(world.getClass().getName());
        }
    }

    @Override
    public void addActor(Actor actor, int x, int y) {
        this.greenfootRecorder.addActorToWorld(actor, x, y);
    }

    @Override
    public void createdActor(Object actor, String[] args, JavaType[] argTypes) {
        this.greenfootRecorder.createActor(actor, args, argTypes);
    }

    @Override
    public void methodCall(Object obj, String actorName, Method method, String[] args, JavaType[] argTypes) {
        if (obj != null) {
            this.greenfootRecorder.callActorMethod(obj, actorName, method, args, argTypes);
        } else {
            this.greenfootRecorder.callStaticMethod(actorName, method, args, argTypes);
        }
    }

    @Override
    public void actorDragged(Actor actor, int xCell, int yCell) {
        this.greenfootRecorder.moveActor(actor, xCell, yCell);
    }

    @Override
    public void removedActor(Actor obj) {
        this.greenfootRecorder.removeActor(obj);
    }

    @Override
    public void objectAddedToWorld(Actor object) {
        if (this.worldInitialising) {
            StackTraceElement[] methods = Thread.currentThread().getStackTrace();
            boolean gonePastUs = false;
            GClass lastWorldGClass = this.getLastWorldGClass();
            if (lastWorldGClass == null) {
                return;
            }
            String lastWorldClassName = this.getLastWorldGClass().getName();
            StackTraceElement[] stackTraceElementArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement item = stackTraceElementArray[n2];
                if ("prepare".equals(item.getMethodName()) && item.getClassName().equals(lastWorldClassName)) {
                    this.greenfootRecorder.nameActor(object);
                    return;
                }
                if (gonePastUs && item.getClassName().startsWith("java.")) {
                    return;
                }
                gonePastUs = gonePastUs || "objectAddedToWorld".equals(item.getMethodName());
                ++n2;
            }
        }
    }

    @Override
    public void simulationActive() {
        this.greenfootRecorder.clearCode(true);
        this.saveWorldAction.setRecordingValid(false);
    }

    public SaveWorldAction getSaveWorldAction() {
        return this.saveWorldAction;
    }

    public boolean initialising() {
        return this.worldInitialising;
    }

    public boolean initialisingForTooLong() {
        return this.worldInitialising && System.currentTimeMillis() > this.startedInitialisingAt + 4000L;
    }

    public boolean initialisationError() {
        return this.worldInvocationError;
    }

    public boolean isMissingConstructor() {
        return this.missingConstructor;
    }

    public void setMissingConstructor(boolean missingConstructor) {
        this.missingConstructor = missingConstructor;
    }

    public boolean isVmRestarted() {
        return this.vmRestarted;
    }

    public void setVmRestarted(boolean vmRestarted) {
        this.vmRestarted = vmRestarted;
    }

    @Override
    public String ask(final String prompt) {
        final AtomicReference c = new AtomicReference();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    c.set(WorldHandlerDelegateIDE.this.frame.ask(prompt));
                }
            });
        }
        catch (InvocationTargetException e) {
            Debug.reportError((Throwable)e);
        }
        catch (InterruptedException e) {
            Debug.reportError((Throwable)e);
        }
        try {
            return (String)((Callable)c.get()).call();
        }
        catch (Exception e) {
            Debug.reportError((Throwable)e);
            return null;
        }
    }
}

