/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.soundrecorder;

import bluej.BlueJTheme;
import bluej.Config;
import greenfoot.sound.SoundRecorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SaveState {
    private final SoundRecorder recorder;
    private Component parent;
    private boolean changedSinceSave = false;
    private String lastSaveName = null;
    private JTextField filenameField;
    private JButton saveButton;
    private JLabel messageLabel;
    private String savedText;
    private String notSavedText;

    SaveState(Component parent, SoundRecorder recorder) {
        this.parent = parent;
        this.recorder = recorder;
        this.savedText = Config.getString((String)"soundRecorder.saved");
        this.notSavedText = Config.getString((String)"soundRecorder.notSaved");
    }

    public boolean hasChangedSinceSave() {
        return this.changedSinceSave;
    }

    private void savedAs(String name) {
        this.changedSinceSave = false;
        this.lastSaveName = name;
        this.updateSaveButtonAndLabel();
    }

    public void changed() {
        this.changedSinceSave = true;
        this.updateSaveButtonAndLabel();
    }

    private void updateSaveButtonAndLabel() {
        boolean differentFromSaved;
        boolean bl = differentFromSaved = !this.filenameField.getText().equals(this.lastSaveName) || this.changedSinceSave;
        if (this.recorder.getRawSound() != null) {
            this.messageLabel.setText(differentFromSaved ? this.notSavedText : this.savedText);
        }
        this.saveButton.setEnabled(this.recorder.getRawSound() != null && !this.filenameField.getText().isEmpty() && differentFromSaved);
    }

    public Box buildSaveBox(final String projectSoundDir) {
        Box saveBox = new Box(0);
        saveBox.add(new JLabel(String.valueOf(Config.getString((String)"soundRecorder.filename")) + ": "));
        this.filenameField = new JTextField();
        this.filenameField.setMaximumSize(new Dimension(Short.MAX_VALUE, this.filenameField.getPreferredSize().height));
        this.filenameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SaveState.this.updateSaveButtonAndLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SaveState.this.updateSaveButtonAndLabel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        saveBox.add(this.filenameField);
        saveBox.add(new JLabel(".wav"));
        saveBox.add(Box.createHorizontalStrut(12));
        this.saveButton = new JButton(Config.getString((String)"soundRecorder.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (projectSoundDir != null) {
                    File destination = new File(String.valueOf(projectSoundDir) + SaveState.this.filenameField.getText() + ".wav");
                    if (destination.exists()) {
                        int overwrite;
                        Object[] options = null;
                        if (Config.isMacOS()) {
                            options = new String[]{BlueJTheme.getCancelLabel(), Config.getString((String)"soundRecorder.overwrite")};
                            overwrite = 1;
                        } else {
                            options = new String[]{Config.getString((String)"soundRecorder.overwrite"), BlueJTheme.getCancelLabel()};
                            overwrite = 0;
                        }
                        if (overwrite == JOptionPane.showOptionDialog(SaveState.this.parent, String.valueOf(Config.getString((String)"soundRecorder.overwrite.part1")) + destination.getName() + Config.getString((String)"soundRecorder.overwrite.part2"), Config.getString((String)"soundRecorder.overwrite.title"), 0, 3, null, options, options[overwrite])) {
                            SaveState.this.recorder.writeWAV(destination);
                            SaveState.this.savedAs(SaveState.this.filenameField.getText());
                        }
                    } else {
                        SaveState.this.recorder.writeWAV(destination);
                        SaveState.this.savedAs(SaveState.this.filenameField.getText());
                    }
                }
            }
        });
        saveBox.add(this.saveButton);
        return saveBox;
    }

    JLabel createLabel() {
        this.messageLabel = new JLabel("");
        this.messageLabel.setForeground(Color.GRAY);
        this.messageLabel.setHorizontalAlignment(4);
        Font font = this.messageLabel.getFont();
        font = font.deriveFont(10.0f);
        this.messageLabel.setFont(font);
        return this.messageLabel;
    }
}

