/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.GreenfootImage;
import greenfoot.core.GClass;
import greenfoot.core.ObjectDragProxy;
import greenfoot.core.WorldHandler;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.gui.DragListener;
import greenfoot.gui.DropTarget;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.SelectionManager;
import greenfoot.gui.classbrowser.role.ActorClassRole;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Modifier;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class DragGlassPane
extends JComponent
implements TriggeredMouseMotionListener,
TriggeredMouseListener,
DragListener {
    private static DragGlassPane instance;
    private Icon noParkingIcon;
    private boolean paintNoDropImage;
    private Object data;
    private Rectangle dragRect = new Rectangle();
    private Rectangle lastPaintRect = new Rectangle();
    private DropTarget lastDropTarget;
    private DragListener dragListener;
    private BufferedImage dragImage;
    private boolean isQuickAddActive;
    private SelectionManager classSelectionManager;
    private boolean listening;

    public void setSelectionManager(SelectionManager selectionManager) {
        this.classSelectionManager = selectionManager;
    }

    public static DragGlassPane getInstance() {
        if (instance == null) {
            instance = new DragGlassPane();
        }
        return instance;
    }

    private DragGlassPane() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        URL noParkingIconFile = this.getClass().getClassLoader().getResource("noParking.png");
        if (noParkingIconFile != null) {
            this.noParkingIcon = new ImageIcon(noParkingIconFile);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.dragImage != null && this.paintNoDropImage) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle currentClip = new Rectangle(this.dragRect.x, this.dragRect.y, this.dragImage.getWidth(), this.dragImage.getHeight());
            Rectangle temp = new Rectangle(currentClip);
            currentClip.add(this.lastPaintRect);
            this.lastPaintRect = temp;
            g2.clip(currentClip);
            g2.drawImage((Image)this.dragImage, this.dragRect.x, this.dragRect.y, null);
        }
    }

    private void startDrag(Actor object, DragListener dl, DropTarget initialDropTarget, boolean forcedDrag) {
        this.dragListener = dl;
        if (object == null) {
            this.endDrag();
            return;
        }
        GreenfootImage objectImage = ActorVisitor.getDragImage(object);
        MouseEvent e = LocationTracker.instance().getMouseMotionEvent();
        if (e == null) {
            this.endDrag();
            return;
        }
        this.setDragImage(objectImage);
        this.setDragObject(object);
        this.paintNoDropImage = true;
        this.storePosition(e);
        this.lastDropTarget = initialDropTarget;
        this.setVisible(true);
        if (initialDropTarget != null) {
            Point p = e.getPoint();
            boolean bl = this.paintNoDropImage = !initialDropTarget.drag(object, p);
            if (this.paintNoDropImage) {
                this.repaint();
            }
        }
    }

    private void cancelDrag() {
        this.isQuickAddActive = false;
        this.endDrag();
    }

    private void endDrag() {
        if (this.lastDropTarget != null) {
            this.lastDropTarget.dragEnded(this.data);
        }
        DragListener dl = this.dragListener;
        Object od = this.data;
        this.setVisible(false);
        this.data = null;
        this.dragImage = null;
        this.dragListener = null;
        if (dl != null) {
            dl.dragFinished(od);
        }
    }

    public void setDragImage(GreenfootImage image) {
        BufferedImage awtImage = image.getAwtImage();
        this.dragImage = GreenfootUtil.createDragShadow(awtImage);
        this.dragRect.width = image.getWidth();
        this.dragRect.height = image.getHeight();
        Graphics2D g = this.dragImage.createGraphics();
        int x = (image.getWidth() - this.noParkingIcon.getIconWidth()) / 2;
        int y = (image.getHeight() - this.noParkingIcon.getIconHeight()) / 2;
        g.setColor(Color.RED);
        this.noParkingIcon.paintIcon(this, g, x, y);
        g.dispose();
    }

    public void setDragObject(Object object) {
        this.data = object;
    }

    private void move(MouseEvent e) {
        if (this.dragImage == null) {
            return;
        }
        this.storePosition(e);
        boolean doRepaint = true;
        Component destination = this.getComponentBeneath(e);
        DropTarget dropTarget = null;
        if (destination instanceof DropTarget) {
            dropTarget = (DropTarget)((Object)destination);
            Point tp = e.getPoint().getLocation();
            Point p = SwingUtilities.convertPoint(e.getComponent(), tp, destination);
            if (dropTarget.drag(this.data, p)) {
                if (this.paintNoDropImage) {
                    this.paintNoDropImage = false;
                } else {
                    doRepaint = false;
                }
            } else {
                this.paintNoDropImage = true;
            }
        } else {
            this.paintNoDropImage = true;
        }
        if (this.lastDropTarget != null && dropTarget != this.lastDropTarget) {
            this.lastDropTarget.dragEnded(this.data);
        }
        this.lastDropTarget = dropTarget;
        if (this.isVisible() && doRepaint) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.move(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.move(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component destination = this.getComponentBeneath(e);
        if (destination != null && destination instanceof DropTarget) {
            DropTarget dropTarget = (DropTarget)((Object)destination);
            Point tp = e.getPoint().getLocation();
            Point destinationPoint = SwingUtilities.convertPoint(e.getComponent(), tp, destination);
            Object tmpData = this.data;
            dropTarget.drop(tmpData, destinationPoint);
            this.lastDropTarget = null;
        }
        this.endDrag();
    }

    private Component getComponentBeneath(MouseEvent e) {
        JMenuBar menuBar;
        RootPaneContainer frame = this.getRootPaneContainer(this);
        if (frame == null) {
            return null;
        }
        Container contentPane = frame.getContentPane();
        Component glassPane = e.getSource() instanceof Component ? (Component)e.getSource() : null;
        int menuBarHeight = 0;
        if (frame instanceof JFrame && (menuBar = ((JFrame)frame).getJMenuBar()) != null) {
            menuBarHeight = menuBar.getHeight();
        }
        Point glassPanePoint = e.getPoint();
        Container container = contentPane;
        Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, contentPane);
        if (containerPoint.y >= 0) {
            Component destination = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
            return destination;
        }
        int cfr_ignored_0 = containerPoint.y;
        return null;
    }

    private RootPaneContainer getRootPaneContainer(Component pane) {
        Component c = pane;
        while (c.getParent() != null && !(c instanceof RootPaneContainer)) {
            c = c.getParent();
        }
        return (RootPaneContainer)((Object)c);
    }

    private void storePosition(MouseEvent e) {
        e = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this);
        this.dragRect.x = (int)((double)e.getX() - this.dragRect.getWidth() / 2.0);
        this.dragRect.y = (int)((double)e.getY() - this.dragRect.getHeight() / 2.0);
    }

    private void quickAddIfActive() {
        if (this.isQuickAddActive) {
            WorldHandler worldHandler = WorldHandler.getInstance();
            ClassView cls = (ClassView)this.classSelectionManager.getSelected();
            if (this.canBeInstantiatedWithoutParams(cls)) {
                ActorClassRole role = (ActorClassRole)cls.getRole();
                ObjectDragProxy actor = role.createObjectDragProxy();
                DragGlassPane.getInstance().startDrag(actor, this, worldHandler.getWorldCanvas(), false);
            }
        }
    }

    private boolean canBeInstantiatedWithoutParams(ClassView cls) {
        if (cls == null) {
            return false;
        }
        if (!(cls.getRole() instanceof ActorClassRole)) {
            return false;
        }
        GClass gCls = cls.getGClass();
        if (!gCls.isCompiled()) {
            return false;
        }
        Class<?> realClass = gCls.getJavaClass();
        if (realClass == null) {
            return false;
        }
        if (Modifier.isAbstract(realClass.getModifiers())) {
            return false;
        }
        try {
            realClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    @Override
    public void dragFinished(Object o) {
        this.quickAddIfActive();
    }

    @Override
    public void listeningEnded() {
        this.listening = false;
        this.cancelDrag();
    }

    @Override
    public void listeningStarted(Object obj) {
        if (this.listening) {
            return;
        }
        this.listening = true;
        if (obj != null) {
            this.startDrag((Actor)obj, null, null, true);
            SwingUtilities.getWindowAncestor(this).toFront();
        } else {
            this.isQuickAddActive = true;
            this.quickAddIfActive();
        }
    }
}

