/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AskPanel
implements ActionListener {
    private static final Color BACKGROUND = new Color(222, 166, 41);
    private JLabel promptDisplay;
    private JPanel panel = new JPanel();
    private JTextField answer;
    private JButton ok;
    private AnswerListener answerListener;

    public AskPanel() {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setOpaque(false);
        this.promptDisplay = new JLabel("");
        this.promptDisplay.setOpaque(true);
        this.promptDisplay.setBackground(BACKGROUND);
        this.promptDisplay.setAlignmentX(0.0f);
        this.promptDisplay.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.DARK_GRAY), BorderFactory.createEmptyBorder(4, 20, 4, 20)));
        JPanel promptPanel = new JPanel();
        promptPanel.setLayout(new BorderLayout());
        promptPanel.setOpaque(false);
        promptPanel.add((Component)this.promptDisplay, "South");
        this.panel.add(promptPanel);
        JPanel answerPanel = new JPanel();
        answerPanel.setLayout(new BoxLayout(answerPanel, 0));
        answerPanel.setBackground(BACKGROUND);
        this.answer = new JTextField();
        this.answer.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.answer.getPreferredSize().height));
        this.answer.addActionListener(this);
        answerPanel.add(this.answer);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.ok.setMaximumSize(new Dimension(50, this.answer.getMaximumSize().height));
        answerPanel.add(this.ok);
        answerPanel.setBorder(BorderFactory.createEmptyBorder(3, 20, 8, 20));
        this.panel.add(answerPanel);
        this.hidePanel();
    }

    public void showPanel(int width, String prompt, AnswerListener listener) {
        this.answerListener = listener;
        this.panel.setVisible(true);
        this.answer.setText("");
        this.promptDisplay.setText("<html>" + prompt + "</html>");
        this.answer.requestFocusInWindow();
    }

    public void hidePanel() {
        this.panel.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hidePanel();
        if (this.answerListener != null) {
            this.answerListener.answered(this.answer.getText());
        }
    }

    public boolean isPanelShowing() {
        return this.panel.isVisible();
    }

    public JPanel getComponent() {
        return this.panel;
    }

    public static interface AnswerListener {
        public void answered(String var1);
    }
}

