/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.sound.Sound;
import greenfoot.sound.SoundFactory;

public class GreenfootSound {
    private Sound sound;
    private String filename;

    public GreenfootSound(String filename) {
        this.filename = filename;
        this.sound = SoundFactory.getInstance().createSound(filename, false);
    }

    public void play() {
        this.sound.play();
    }

    public void playLoop() {
        this.sound.loop();
    }

    public void stop() {
        this.sound.stop();
    }

    public void pause() {
        this.sound.pause();
    }

    public boolean isPlaying() {
        return this.sound.isPlaying();
    }

    public int getVolume() {
        return this.sound.getVolume();
    }

    public void setVolume(int level) {
        this.sound.setVolume(level);
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + " file: " + this.filename + " ";
        s = this.sound != null ? String.valueOf(s) + ". Is playing: " + this.isPlaying() : String.valueOf(s) + ". Not found.";
        return s;
    }
}

