/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.GreenfootImage;
import greenfoot.World;
import greenfoot.collision.ibsp.Rect;
import greenfoot.core.WorldHandler;
import greenfoot.platforms.ActorDelegate;
import greenfoot.util.GreenfootUtil;
import java.util.List;

public abstract class Actor {
    private static final String NO_WORLD = "An actor is trying to access the world, when no world has been instantiated.";
    private static final String ACTOR_NOT_IN_WORLD = "Actor not in world. An attempt was made to use the actor's location while it is not in the world. Either it has not yet been inserted, or it has been removed.";
    private static int sequenceNumber = 0;
    int x;
    int y;
    private int mySequenceNumber;
    private int lastPaintSequenceNumber;
    int rotation = 0;
    World world;
    private GreenfootImage image;
    private Object data;
    static GreenfootImage greenfootImage;
    private Rect boundingRect;
    private int[] boundingXs = new int[4];
    private int[] boundingYs = new int[4];
    private static ActorDelegate delegate;

    static {
        try {
            greenfootImage = new GreenfootImage(GreenfootUtil.getGreenfootLogoPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Greenfoot installation is broken - reinstalling Greenfoot might help.");
        }
    }

    public Actor() {
        this.mySequenceNumber = sequenceNumber++;
        GreenfootImage image = this.getClassImage();
        if (image == null) {
            image = greenfootImage;
        }
        image = image.getCopyOnWriteClone();
        this.setImage(image);
    }

    public void act() {
    }

    public int getX() throws IllegalStateException {
        this.failIfNotInWorld();
        return this.x;
    }

    public int getY() {
        this.failIfNotInWorld();
        return this.y;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        if (rotation >= 360) {
            rotation = rotation < 720 ? (rotation -= 360) : (rotation %= 360);
        } else if (rotation < 0) {
            rotation = rotation >= -360 ? (rotation += 360) : 360 + rotation % 360;
        }
        if (this.rotation != rotation) {
            this.rotation = rotation;
            this.boundingRect = null;
            this.sizeChanged();
        }
    }

    public void turnTowards(int x, int y) {
        double a = Math.atan2(y - this.y, x - this.x);
        this.setRotation((int)Math.toDegrees(a));
    }

    public boolean isAtEdge() {
        this.failIfNotInWorld();
        return this.x <= 0 || this.y <= 0 || this.x >= this.getWorld().getWidth() - 1 || this.y >= this.getWorld().getHeight() - 1;
    }

    public void setLocation(int x, int y) {
        this.setLocationDrag(x, y);
    }

    public void move(int distance) {
        double radians = Math.toRadians(this.rotation);
        int dx = (int)Math.round(Math.cos(radians) * (double)distance);
        int dy = (int)Math.round(Math.sin(radians) * (double)distance);
        this.setLocation(this.x + dx, this.y + dy);
    }

    public void turn(int amount) {
        this.setRotation(this.rotation + amount);
    }

    private void setLocationDrag(int x, int y) {
        if (this.world != null) {
            int oldX = this.x;
            int oldY = this.y;
            if (this.world.isBounded()) {
                this.x = this.limitValue(x, this.world.width);
                this.y = this.limitValue(y, this.world.height);
            } else {
                this.x = x;
                this.y = y;
            }
            if (this.x != oldX || this.y != oldY) {
                if (this.boundingRect != null) {
                    int dx = (this.x - oldX) * this.world.cellSize;
                    int dy = (this.y - oldY) * this.world.cellSize;
                    this.boundingRect.setX(this.boundingRect.getX() + dx);
                    this.boundingRect.setY(this.boundingRect.getY() + dy);
                    int i = 0;
                    while (i < 4) {
                        int n = i;
                        this.boundingXs[n] = this.boundingXs[n] + dx;
                        int n2 = i++;
                        this.boundingYs[n2] = this.boundingYs[n2] + dy;
                    }
                }
                this.locationChanged(oldX, oldY);
            }
        }
    }

    private int limitValue(int v, int limit) {
        if (v < 0) {
            v = 0;
        }
        if (limit <= v) {
            v = limit - 1;
        }
        return v;
    }

    public World getWorld() {
        return this.world;
    }

    protected void addedToWorld(World world) {
    }

    public GreenfootImage getImage() {
        return this.image;
    }

    public void setImage(String filename) throws IllegalArgumentException {
        this.setImage(new GreenfootImage(filename));
    }

    public void setImage(GreenfootImage image) {
        if (image == null && this.image == null) {
            return;
        }
        boolean sizeChanged = true;
        if (image != null && this.image != null && image.getWidth() == this.image.getWidth() && image.getHeight() == this.image.getHeight()) {
            sizeChanged = false;
        }
        this.image = image;
        if (sizeChanged) {
            this.boundingRect = null;
            this.sizeChanged();
        }
    }

    void setLocationInPixels(int x, int y) {
        int xCell = this.world.toCellFloor(x);
        int yCell = this.world.toCellFloor(y);
        if (xCell == this.x && yCell == this.y) {
            return;
        }
        this.setLocationDrag(xCell, yCell);
    }

    void setWorld(World world) {
        this.world = world;
    }

    void addToWorld(int x, int y, World world) {
        if (world.isBounded()) {
            x = this.limitValue(x, world.getWidth());
            y = this.limitValue(y, world.getHeight());
        }
        this.x = x;
        this.y = y;
        this.boundingRect = null;
        this.setWorld(world);
        this.setLocation(x, y);
    }

    Rect getBoundingRect() {
        if (this.boundingRect == null) {
            this.calcBounds();
        }
        return this.boundingRect;
    }

    private void calcBounds() {
        World w = this.getActiveWorld();
        if (w == null) {
            return;
        }
        int cellSize = w.getCellSize();
        if (this.image == null) {
            int wx = this.x * cellSize + cellSize / 2;
            int wy = this.y * cellSize + cellSize / 2;
            this.boundingRect = new Rect(wx, wy, 0, 0);
            int i = 0;
            while (i < 4) {
                this.boundingXs[i] = wx;
                this.boundingYs[i] = wy;
                ++i;
            }
            return;
        }
        if (this.rotation % 90 == 0) {
            int width = 0;
            int height = 0;
            if (this.rotation % 180 == 0) {
                width = this.image.getWidth();
                height = this.image.getHeight();
            } else {
                width = this.image.getHeight();
                height = this.image.getWidth();
            }
            int x = cellSize * this.x + (cellSize - width - 1) / 2;
            int y = cellSize * this.y + (cellSize - height - 1) / 2;
            this.boundingRect = new Rect(x, y, width, height);
            this.boundingXs[0] = x;
            this.boundingYs[0] = y;
            this.boundingXs[1] = x + width - 1;
            this.boundingYs[1] = y;
            this.boundingXs[2] = this.boundingXs[1];
            this.boundingYs[2] = y + height - 1;
            this.boundingXs[3] = x;
            this.boundingYs[3] = this.boundingYs[2];
        } else {
            this.getRotatedCorners(this.boundingXs, this.boundingYs, cellSize);
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            int i = 0;
            while (i < 4) {
                minX = Math.min(this.boundingXs[i] - 1, minX);
                maxX = Math.max(this.boundingXs[i] + 1, maxX);
                minY = Math.min(this.boundingYs[i] - 1, minY);
                maxY = Math.max(this.boundingYs[i] + 1, maxY);
                ++i;
            }
            this.boundingRect = new Rect(minX, minY, maxX - minX + 1, maxY - minY + 1);
        }
    }

    void setData(Object o) {
        this.data = o;
    }

    Object getData() {
        return this.data;
    }

    int toPixel(int x) {
        World aWorld = this.getActiveWorld();
        if (aWorld == null) {
            throw new IllegalStateException(NO_WORLD);
        }
        return x * aWorld.getCellSize() + aWorld.getCellSize() / 2;
    }

    private GreenfootImage getClassImage() {
        Class<?> clazz = this.getClass();
        while (clazz != null) {
            GreenfootImage image = null;
            try {
                image = this.getImage(clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (image != null) {
                return image;
            }
            clazz = clazz.getSuperclass();
        }
        return greenfootImage;
    }

    private void sizeChanged() {
        if (this.world != null) {
            this.world.updateObjectSize(this);
        }
    }

    private void locationChanged(int oldX, int oldY) {
        if (this.world != null) {
            this.world.updateObjectLocation(this, oldX, oldY);
        }
    }

    private void failIfNotInWorld() {
        if (this.world == null) {
            throw new IllegalStateException(ACTOR_NOT_IN_WORLD);
        }
    }

    private void getRotatedCorners(int[] xs, int[] ys, int cellSize) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        xs[0] = -width / 2;
        xs[1] = xs[0] + width - 1;
        xs[2] = xs[1];
        xs[3] = xs[0];
        ys[0] = -height / 2;
        ys[1] = ys[0];
        ys[2] = ys[1] + height - 1;
        ys[3] = ys[2];
        double rotR = Math.toRadians(this.rotation);
        double sinR = Math.sin(rotR);
        double cosR = Math.cos(rotR);
        double xc = (double)(cellSize * this.x) + (double)cellSize / 2.0;
        double yc = (double)(cellSize * this.y) + (double)cellSize / 2.0;
        int i = 0;
        while (i < 4) {
            int nx = (int)((double)xs[i] * cosR - (double)ys[i] * sinR + xc);
            int ny = (int)((double)ys[i] * cosR + (double)xs[i] * sinR + yc);
            xs[i] = nx;
            ys[i] = ny;
            ++i;
        }
    }

    private static boolean checkOutside(int[] myX, int[] myY, int[] otherX, int[] otherY) {
        int v = 0;
        while (v < 4) {
            block4: {
                int v1 = v + 1 & 3;
                int edgeX = myX[v] - myX[v1];
                int edgeY = myY[v] - myY[v1];
                int reX = -edgeY;
                int reY = edgeX;
                if (reX != 0 || reY != 0) {
                    int e = 0;
                    while (e < 4) {
                        int scalar = reX * (otherX[e] - myX[v1]) + reY * (otherY[e] - myY[v1]);
                        if (scalar >= 0) {
                            ++e;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++v;
        }
        return false;
    }

    protected boolean intersects(Actor other) {
        if (this.image == null) {
            if (other.image == null) {
                return this.x == other.x && this.y == other.y;
            }
            int cellSize = this.world.getCellSize();
            return other.containsPoint(this.x * cellSize + cellSize / 2, this.y * cellSize + cellSize / 2);
        }
        if (other.image == null) {
            int cellSize = this.world.getCellSize();
            return this.containsPoint(other.x * cellSize + cellSize / 2, other.y * cellSize + cellSize / 2);
        }
        Rect thisBounds = this.getBoundingRect();
        Rect otherBounds = other.getBoundingRect();
        if (this.rotation == 0 && other.rotation == 0) {
            return thisBounds.intersects(otherBounds);
        }
        if (!thisBounds.intersects(otherBounds)) {
            return false;
        }
        int[] myX = this.boundingXs;
        int[] myY = this.boundingYs;
        int[] otherX = other.boundingXs;
        int[] otherY = other.boundingYs;
        if (Actor.checkOutside(myX, myY, otherX, otherY)) {
            return false;
        }
        return !Actor.checkOutside(otherX, otherY, myX, myY);
    }

    protected List getNeighbours(int distance, boolean diagonal, Class cls) {
        this.failIfNotInWorld();
        return this.world.getNeighbours(this, distance, diagonal, cls);
    }

    protected List getObjectsAtOffset(int dx, int dy, Class cls) {
        this.failIfNotInWorld();
        return this.world.getObjectsAt(this.x + dx, this.y + dy, cls);
    }

    protected Actor getOneObjectAtOffset(int dx, int dy, Class cls) {
        this.failIfNotInWorld();
        return this.world.getOneObjectAt(this, this.x + dx, this.y + dy, cls);
    }

    protected List getObjectsInRange(int radius, Class cls) {
        this.failIfNotInWorld();
        List inRange = this.world.getObjectsInRange(this.x, this.y, radius, cls);
        inRange.remove(this);
        return inRange;
    }

    protected List getIntersectingObjects(Class cls) {
        this.failIfNotInWorld();
        List l = this.world.getIntersectingObjects(this, cls);
        l.remove(this);
        return l;
    }

    protected Actor getOneIntersectingObject(Class cls) {
        this.failIfNotInWorld();
        return this.world.getOneIntersectingObject(this, cls);
    }

    protected boolean isTouching(Class cls) {
        this.failIfNotInWorld();
        return this.getOneIntersectingObject(cls) != null;
    }

    protected void removeTouching(Class cls) {
        this.failIfNotInWorld();
        Actor a = this.getOneIntersectingObject(cls);
        if (a != null) {
            this.world.removeObject(a);
        }
    }

    boolean containsPoint(int px, int py) {
        this.failIfNotInWorld();
        if (this.image == null) {
            return false;
        }
        if (this.boundingRect == null) {
            this.calcBounds();
        }
        if (this.rotation == 0 || this.rotation == 90 || this.rotation == 270) {
            return px >= this.boundingRect.getX() && px < this.boundingRect.getRight() && py >= this.boundingRect.getY() && py < this.boundingRect.getTop();
        }
        int v = 0;
        while (v < 4) {
            int scalar;
            int v1 = v + 1 & 3;
            int edgeX = this.boundingXs[v] - this.boundingXs[v1];
            int edgeY = this.boundingYs[v] - this.boundingYs[v1];
            int reX = -edgeY;
            int reY = edgeX;
            if ((reX != 0 || reY != 0) && (scalar = reX * (px - this.boundingXs[v1]) + reY * (py - this.boundingYs[v1])) >= 0) {
                return false;
            }
            ++v;
        }
        return true;
    }

    final int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    final int getLastPaintSeqNum() {
        return this.lastPaintSequenceNumber;
    }

    final void setLastPaintSeqNum(int num) {
        this.lastPaintSequenceNumber = num;
    }

    static void setDelegate(ActorDelegate d) {
        delegate = d;
    }

    static ActorDelegate getDelegate() {
        return delegate;
    }

    GreenfootImage getImage(Class<?> clazz) {
        return delegate.getImage(clazz.getName());
    }

    World getActiveWorld() {
        if (this.world != null) {
            return this.world;
        }
        WorldHandler handler = WorldHandler.getInstance();
        if (handler != null) {
            return handler.getWorld();
        }
        return null;
    }
}

