/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions.event;

import bluej.extensions.event.ExtensionEvent;
import java.io.File;

public class CompileEvent
implements ExtensionEvent {
    public static final int COMPILE_START_EVENT = 1;
    public static final int COMPILE_WARNING_EVENT = 2;
    public static final int COMPILE_ERROR_EVENT = 3;
    public static final int COMPILE_DONE_EVENT = 4;
    public static final int COMPILE_FAILED_EVENT = 5;
    private int eventId;
    private File[] fileNames;
    private int errorLineNumber;
    private int errorColumn;
    private int endErrorLine;
    private int endErrorColumn;
    private String errorMessage;

    public CompileEvent(int anEventId, File[] aFileNames) {
        this.eventId = anEventId;
        this.fileNames = aFileNames;
    }

    public int getEvent() {
        return this.eventId;
    }

    public File[] getFiles() {
        return this.fileNames;
    }

    public void setErrorLineNumber(int aLineNumber) {
        this.errorLineNumber = aLineNumber;
    }

    public void setErrorPosition(int[] errorPosition) {
        this.errorLineNumber = errorPosition[0];
        this.errorColumn = errorPosition[1];
        this.endErrorLine = errorPosition[2];
        this.endErrorColumn = errorPosition[3];
    }

    public int getErrorLineNumber() {
        return this.errorLineNumber;
    }

    public int[] getErrorPosition() {
        int[] r = new int[]{this.errorLineNumber, this.errorColumn, this.endErrorLine, this.endErrorColumn};
        return r;
    }

    public void setErrorMessage(String anErrorMessage) {
        this.errorMessage = anErrorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        StringBuffer aRisul = new StringBuffer(500);
        aRisul.append("CompileEvent:");
        if (this.eventId == 1) {
            aRisul.append(" COMPILE_START_EVENT");
        }
        if (this.eventId == 2) {
            aRisul.append(" COMPILE_WARNING_EVENT");
        }
        if (this.eventId == 3) {
            aRisul.append(" COMPILE_ERROR_EVENT");
        }
        if (this.eventId == 4) {
            aRisul.append(" COMPILE_DONE_EVENT");
        }
        if (this.eventId == 5) {
            aRisul.append(" COMPILE_FAILED_EVENT");
        }
        aRisul.append(" getFiles().length=");
        aRisul.append(this.fileNames.length);
        for (int i = 0; i < this.fileNames.length; ++i) {
            aRisul.append(" getFiles()[" + i + "]=");
            aRisul.append(this.fileNames[i]);
        }
        if (this.eventId == 2 || this.eventId == 3) {
            aRisul.append(" errorLineNumber=" + this.errorLineNumber);
            aRisul.append(" errorMessage=" + this.errorMessage);
        }
        return aRisul.toString();
    }
}

