/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.taglets;

import bluej.doclet.doclets.internal.toolkit.taglets.BaseTaglet;
import bluej.doclet.doclets.internal.toolkit.taglets.InheritableTaglet;
import bluej.doclet.doclets.internal.toolkit.taglets.TagletOutput;
import bluej.doclet.doclets.internal.toolkit.taglets.TagletWriter;
import bluej.doclet.doclets.internal.toolkit.util.DocFinder;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ParamTaglet
extends BaseTaglet
implements InheritableTaglet {
    public ParamTaglet() {
        this.name = "param";
    }

    private static Map getRankMap(Object[] params) {
        if (params == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            String name = params[i] instanceof Parameter ? ((Parameter)params[i]).name() : ((TypeVariable)params[i]).typeName();
            result.put(name, String.valueOf(i));
        }
        return result;
    }

    @Override
    public void inherit(DocFinder.Input input, DocFinder.Output output) {
        int i;
        if (input.tagId == null) {
            input.isTypeVariableParamTag = ((ParamTag)input.tag).isTypeParameter();
            Object[] parameters = input.isTypeVariableParamTag ? (Object[])((MethodDoc)input.tag.holder()).typeParameters() : (Object[])((MethodDoc)input.tag.holder()).parameters();
            String target = ((ParamTag)input.tag).parameterName();
            for (i = 0; i < parameters.length; ++i) {
                String name;
                String string = name = parameters[i] instanceof Parameter ? ((Parameter)parameters[i]).name() : ((TypeVariable)parameters[i]).typeName();
                if (!name.equals(target)) continue;
                input.tagId = String.valueOf(i);
                break;
            }
            if (i == parameters.length) {
                return;
            }
        }
        ParamTag[] tags = input.isTypeVariableParamTag ? input.method.typeParamTags() : input.method.paramTags();
        Map rankMap = ParamTaglet.getRankMap(input.isTypeVariableParamTag ? (Object[])input.method.typeParameters() : (Object[])input.method.parameters());
        for (i = 0; i < tags.length; ++i) {
            if (!rankMap.containsKey(tags[i].parameterName()) || !rankMap.get(tags[i].parameterName()).equals(input.tagId)) continue;
            output.holder = input.method;
            output.holderTag = tags[i];
            output.inlineTags = input.isFirstSentence ? tags[i].firstSentenceTags() : tags[i].inlineTags();
            return;
        }
    }

    @Override
    public boolean inField() {
        return false;
    }

    @Override
    public boolean inMethod() {
        return true;
    }

    @Override
    public boolean inOverview() {
        return false;
    }

    @Override
    public boolean inPackage() {
        return false;
    }

    @Override
    public boolean inType() {
        return true;
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public TagletOutput getTagletOutput(Doc holder, TagletWriter writer) {
        if (holder instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc member = (ExecutableMemberDoc)holder;
            TagletOutput output = this.getTagletOutput(false, (Doc)member, writer, member.typeParameters(), member.typeParamTags());
            output.appendOutput(this.getTagletOutput(true, (Doc)member, writer, member.parameters(), member.paramTags()));
            return output;
        }
        ClassDoc classDoc = (ClassDoc)holder;
        return this.getTagletOutput(false, (Doc)classDoc, writer, classDoc.typeParameters(), classDoc.typeParamTags());
    }

    private TagletOutput getTagletOutput(boolean isNonTypeParams, Doc holder, TagletWriter writer, Object[] formalParameters, ParamTag[] paramTags) {
        TagletOutput result = writer.getOutputInstance();
        HashSet alreadyDocumented = new HashSet();
        if (paramTags.length > 0) {
            result.appendOutput(this.processParamTags(isNonTypeParams, paramTags, ParamTaglet.getRankMap(formalParameters), writer, alreadyDocumented));
        }
        if (alreadyDocumented.size() != formalParameters.length) {
            result.appendOutput(this.getInheritedTagletOutput(isNonTypeParams, holder, writer, formalParameters, alreadyDocumented));
        }
        return result;
    }

    private TagletOutput getInheritedTagletOutput(boolean isNonTypeParams, Doc holder, TagletWriter writer, Object[] formalParameters, Set alreadyDocumented) {
        TagletOutput result = writer.getOutputInstance();
        if (!alreadyDocumented.contains(null) && holder instanceof MethodDoc) {
            for (int i = 0; i < formalParameters.length; ++i) {
                if (alreadyDocumented.contains(String.valueOf(i))) continue;
                DocFinder.Output inheritedDoc = DocFinder.search(new DocFinder.Input((MethodDoc)holder, this, String.valueOf(i), !isNonTypeParams));
                if (inheritedDoc.inlineTags != null && inheritedDoc.inlineTags.length > 0) {
                    result.appendOutput(this.processParamTag(isNonTypeParams, writer, (ParamTag)inheritedDoc.holderTag, isNonTypeParams ? ((Parameter)formalParameters[i]).name() : ((TypeVariable)formalParameters[i]).typeName(), alreadyDocumented.size() == 0));
                }
                alreadyDocumented.add(String.valueOf(i));
            }
        }
        return result;
    }

    private TagletOutput processParamTags(boolean isNonTypeParams, ParamTag[] paramTags, Map rankMap, TagletWriter writer, Set alreadyDocumented) {
        TagletOutput result = writer.getOutputInstance();
        if (paramTags.length > 0) {
            for (int i = 0; i < paramTags.length; ++i) {
                String rank;
                String paramName;
                ParamTag pt = paramTags[i];
                String string = paramName = isNonTypeParams ? pt.parameterName() : "<" + pt.parameterName() + ">";
                if (!rankMap.containsKey(pt.parameterName())) {
                    writer.getMsgRetriever().warning(pt.position(), isNonTypeParams ? "doclet.Parameters_warn" : "doclet.Type_Parameters_warn", paramName);
                }
                if ((rank = (String)rankMap.get(pt.parameterName())) != null && alreadyDocumented.contains(rank)) {
                    writer.getMsgRetriever().warning(pt.position(), isNonTypeParams ? "doclet.Parameters_dup_warn" : "doclet.Type_Parameters_dup_warn", paramName);
                }
                result.appendOutput(this.processParamTag(isNonTypeParams, writer, pt, pt.parameterName(), alreadyDocumented.size() == 0));
                alreadyDocumented.add(rank);
            }
        }
        return result;
    }

    private TagletOutput processParamTag(boolean isNonTypeParams, TagletWriter writer, ParamTag paramTag, String name, boolean isFirstParam) {
        TagletOutput result = writer.getOutputInstance();
        String header = writer.configuration().getText(isNonTypeParams ? "doclet.Parameters" : "doclet.TypeParameters");
        if (isFirstParam) {
            result.appendOutput(writer.getParamHeader(header));
        }
        result.appendOutput(writer.paramTagOutput(paramTag, name));
        return result;
    }
}

