/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.builders;

import bluej.doclet.doclets.internal.toolkit.AnnotationTypeWriter;
import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.builders.AbstractBuilder;
import bluej.doclet.doclets.internal.toolkit.builders.LayoutParser;
import bluej.doclet.doclets.internal.toolkit.util.DirectoryManager;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private AnnotationTypeDoc annotationTypeDoc;
    private AnnotationTypeWriter writer;

    private AnnotationTypeBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeBuilder getInstance(Configuration configuration, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter writer) throws Exception {
        AnnotationTypeBuilder builder = new AnnotationTypeBuilder(configuration);
        builder.configuration = configuration;
        builder.annotationTypeDoc = annotationTypeDoc;
        builder.writer = writer;
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return builder;
    }

    @Override
    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    @Override
    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(List elements) throws Exception {
        this.build(elements);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.annotationTypeDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.annotationTypeDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildAnnotationTypeHeader() {
        this.writer.writeHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
    }

    public void buildDeprecationInfo() {
        this.writer.writeAnnotationTypeDeprecationInfo();
    }

    public void buildAnnotationTypeSignature() {
        StringBuffer modifiers = new StringBuffer(this.annotationTypeDoc.modifiers() + " ");
        this.writer.writeAnnotationTypeSignature(Util.replaceText(modifiers.toString(), "interface", "@interface"));
    }

    public void buildAnnotationTypeDescription() {
        this.writer.writeAnnotationTypeDescription();
    }

    public void buildAnnotationTypeTagInfo() {
        this.writer.writeAnnotationTypeTagInfo();
    }

    public void buildMemberSummary(List elements) throws Exception {
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).build(elements);
        this.writer.completeMemberSummaryBuild();
    }

    public void buildAnnotationTypeOptionalMemberDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).build(elements);
    }

    public void buildAnnotationTypeRequiredMemberDetails(List elements) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).build(elements);
    }

    public void buildAnnotationTypeFooter() {
        this.writer.writeFooter();
    }
}

