/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.HtmlDocletWriter;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class FrameOutputWriter
extends HtmlDocletWriter {
    int noOfPackages;

    public FrameOutputWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
        this.noOfPackages = configuration.packages.length;
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "";
        try {
            filename = "index.html";
            FrameOutputWriter framegen = new FrameOutputWriter(configuration, filename);
            framegen.generateFrameFile();
            framegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateFrameFile() {
        if (this.configuration.windowtitle.length() > 0) {
            this.printFramesetHeader(this.configuration.windowtitle, this.configuration.notimestamp);
        } else {
            this.printFramesetHeader(this.configuration.getText("doclet.Generated_Docs_Untitled"), this.configuration.notimestamp);
        }
        this.printFrameDetails();
        this.printFrameFooter();
    }

    protected void printFrameWarning() {
        this.noFrames();
        this.h2();
        this.printText("doclet.Frame_Alert");
        this.h2End();
        this.p();
        this.printText("doclet.Frame_Warning_Message");
        this.br();
        this.printText("doclet.Link_To");
        this.printHyperLink(this.configuration.topFile, this.configuration.getText("doclet.Non_Frame_Version"));
        this.println("");
        this.noFramesEnd();
    }

    protected void printFrameDetails() {
        this.frameSet("cols=\"20%,80%\" title=\"\" onLoad=\"top.loadFrames()\"");
        if (this.noOfPackages <= 1) {
            this.printAllClassesFrameTag();
        } else if (this.noOfPackages > 1) {
            this.frameSet("rows=\"30%,70%\" title=\"\" onLoad=\"top.loadFrames()\"");
            this.printAllPackagesFrameTag();
            this.printAllClassesFrameTag();
            this.frameSetEnd();
        }
        this.printClassFrameTag();
        this.printFrameWarning();
        this.frameSetEnd();
    }

    private void printAllPackagesFrameTag() {
        this.frame("src=\"overview-frame.html\" name=\"packageListFrame\" title=\"" + this.configuration.getText("doclet.All_Packages") + "\"");
    }

    private void printAllClassesFrameTag() {
        this.frame("src=\"allclasses-frame.html\" name=\"packageFrame\" title=\"" + this.configuration.getText("doclet.All_classes_and_interfaces") + "\"");
    }

    private void printClassFrameTag() {
        this.frame("src=\"" + this.configuration.topFile + "\"" + " name=\"classFrame\"" + " title=\"" + this.configuration.getText("doclet.Package_class_and_interface_descriptions") + "\" scrolling=\"yes\"");
    }
}

