/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.TarFileSet;
import org.eclipse.pde.internal.build.ant.ZipFileSet;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.PluginEntry;

public class AssembleConfigScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected String featureId;
    protected Config configInfo;
    protected IFeature[] features;
    protected IFeature[] allFeatures;
    protected BundleDescription[] plugins;
    protected String filename;
    protected Collection rootFileProviders;
    protected Properties pluginsPostProcessingSteps;
    protected Properties featuresPostProcessingSteps;
    protected ArrayList addedByPermissions = new ArrayList();
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_ELEMENT_NAME = "elementName";
    private static final String UPDATEJAR = "updateJar";
    private static final String FLAT = "flat";
    private static final byte BUNDLE = 0;
    private static final byte FEATURE = 1;
    private static final String FOLDER = "folder";
    private static final String FILE = "file";
    protected String PROPERTY_ECLIPSE_PLUGINS = "eclipse.plugins";
    protected String PROPERTY_ECLIPSE_FEATURES = "eclipse.features";
    private boolean signJars;
    private boolean generateJnlp;
    private String archiveFormat;
    private boolean groupConfigs = false;
    private String product;
    private ProductFile productFile = null;

    public void initialize(String directoryName, String feature, Config configurationInformation, Collection elementList, Collection featureList, Collection allFeaturesList, Collection rootProviders) throws CoreException {
        this.directory = directoryName;
        this.featureId = feature;
        this.configInfo = configurationInformation;
        this.rootFileProviders = rootProviders != null ? rootProviders : new ArrayList(0);
        this.features = new IFeature[featureList.size()];
        featureList.toArray(this.features);
        this.allFeatures = new IFeature[allFeaturesList.size()];
        allFeaturesList.toArray(this.allFeatures);
        this.plugins = new BundleDescription[elementList.size()];
        this.plugins = elementList.toArray(this.plugins);
        this.openScript(directoryName, String.valueOf(this.getTargetName()) + ".xml");
        this.loadPostProcessingSteps();
    }

    private void loadProduct() {
        File f;
        if (this.product == null || this.product.startsWith("${")) {
            this.productFile = null;
            return;
        }
        String productPath = this.findFile(this.product, false);
        if (productPath == null) {
            productPath = this.product;
        }
        if ((f = new File(productPath)).exists() && f.isFile()) {
            try {
                this.productFile = new ProductFile(productPath, this.configInfo.getOs());
            }
            catch (CoreException coreException) {}
        }
    }

    private String computeIconsList() {
        String result = Utils.getPropertyFormat("launcherIcons");
        if (this.productFile == null) {
            return result;
        }
        String[] icons = this.productFile.getIcons();
        int i = 0;
        while (i < icons.length) {
            String location = this.findFile(icons[i], true);
            if (location != null) {
                result = String.valueOf(result) + ", " + Utils.getPropertyFormat("basedir") + '/' + location;
            }
            ++i;
        }
        return result;
    }

    private void loadPostProcessingSteps() {
        try {
            this.pluginsPostProcessingSteps = AssembleConfigScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "plugins.postProcessingSteps.properties", 1);
            this.featuresPostProcessingSteps = AssembleConfigScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "features.postProcessingSteps.properties", 1);
        }
        catch (CoreException coreException) {}
    }

    public void generate() {
        this.loadProduct();
        this.generatePrologue();
        this.generateInitializationSteps();
        this.generateGatherBinPartsCalls();
        if (embeddedSource) {
            this.generateGatherSourceCalls();
        }
        this.generatePostProcessingSteps();
        this.generateBrandingCalls();
        this.generateArchivingSteps();
        this.generateEpilogue();
    }

    private void generateBrandingCalls() {
        String install = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
        this.script.printBrandTask(install, this.computeIconsList(), Utils.getPropertyFormat("launcherName"), Utils.getPropertyFormat("os"));
    }

    private void generateArchivingSteps() {
        if (FOLDER.equalsIgnoreCase(this.archiveFormat)) {
            this.generateMoveRootFiles();
            return;
        }
        if ("zip".equalsIgnoreCase(this.archiveFormat)) {
            this.generateZipTarget();
            return;
        }
        if ("antZip".equalsIgnoreCase(this.archiveFormat)) {
            this.generateAntZipTarget();
            return;
        }
        if ("antTar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateAntTarTarget();
            return;
        }
        if ("tar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateTarGZTasks(true);
            return;
        }
    }

    private void generateMoveRootFiles() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            Properties featureProperties = null;
            try {
                featureProperties = AbstractScriptGenerator.readProperties(new Path(((IFeature)iter.next()).getURL().getFile()).removeLastSegments(1).toOSString(), "build.properties", 0);
                Utils.generatePermissions(featureProperties, this.configInfo, "eclipse.base", this.script);
            }
            catch (CoreException coreException) {}
        }
        if (Platform.getOS().equals("win32")) {
            FileSet[] rootFiles = new FileSet[]{new FileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder"), null, "**/**", null, null, null, null)};
            this.script.printMoveTask(Utils.getPropertyFormat("eclipse.base"), rootFiles, false);
            this.script.printDeleteTask(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), null, null);
        } else {
            ArrayList<String> params = new ArrayList<String>(3);
            params.add("-R");
            params.add(".");
            params.add(String.valueOf('\'') + Utils.getPropertyFormat("eclipse.base") + '\'');
            String rootFileFolder = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY");
            this.script.printExecTask("cp", String.valueOf(rootFileFolder) + '/' + Utils.getPropertyFormat("collectingFolder"), params, null);
            this.script.printDeleteTask(rootFileFolder, null, null);
        }
    }

    protected void generateGatherSourceCalls() {
        String placeToGather;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            Properties bundleProperties = (Properties)plugin.getUserObject();
            if (bundleProperties.get("withDot") == Boolean.TRUE) {
                String targetLocation = String.valueOf(Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS)) + '/' + ModelBuildScriptGenerator.getNormalizedName(plugin);
                String targetLocationSrc = String.valueOf(targetLocation) + "/src";
                this.script.println("<unzip dest=\"" + targetLocationSrc + "\">");
                this.script.println("\t<fileset dir=\"" + targetLocation + "\" includes=\"**/*src.zip\" casesensitive=\"false\"/>");
                this.script.println("</unzip>");
                this.script.printDeleteTask(null, null, new FileSet[]{new FileSet(targetLocation, null, "**/*src.zip", null, null, null, "false")});
            }
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", Utils.getPropertyFormat("eclipse.base"));
        i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            int j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            ++i;
        }
    }

    protected void generatePackagingTargets() {
        String fileName = String.valueOf(Utils.getPropertyFormat(PROPERTY_SOURCE)) + '/' + Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME);
        String fileExists = String.valueOf(Utils.getPropertyFormat(PROPERTY_SOURCE)) + '/' + Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME) + "_exists";
        this.script.printComment("Beginning of the jarUp task");
        this.script.printTargetDeclaration("jarUp", null, null, null, Messages.assemble_jarUp);
        this.script.printAvailableTask(fileExists, fileName);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(PROPERTY_SOURCE, Utils.getPropertyFormat(PROPERTY_SOURCE));
        params.put(PROPERTY_ELEMENT_NAME, Utils.getPropertyFormat(PROPERTY_ELEMENT_NAME));
        this.script.printAntCallTask("jarIng", true, params);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("jarIng", null, fileExists, null, null);
        this.script.printZipTask(String.valueOf(fileName) + ".jar", fileName, false, false, null);
        this.script.printDeleteTask(fileName, null, null);
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
        this.script.printComment("Beginning of the jar signing  target");
        this.script.printTargetDeclaration("jarSigning", null, null, null, Messages.sign_Jar);
        this.script.println("<signjar jar=\"" + fileName + ".jar" + "\" alias=\"" + Utils.getPropertyFormat("sign.alias") + "\" keystore=\"" + Utils.getPropertyFormat("sign.keystore") + "\" storepass=\"" + Utils.getPropertyFormat("sign.storepass") + "\"/>");
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
    }

    protected void generateGZipTarget(boolean assembling) {
        this.script.printTargetDeclaration("gzipResults", null, null, assembling ? "runPackager" : null, null);
        this.script.println("<move file=\"" + Utils.getPropertyFormat("archiveFullPath") + "\" tofile=\"" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + "/tmp.tar\"/>");
        this.script.printGZip(String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("collectingFolder") + "/tmp.tar", Utils.getPropertyFormat("archiveFullPath"));
        this.script.printTargetEnd();
    }

    protected void generatePrologue() {
        this.script.printProjectDeclaration("Assemble " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
        this.script.printProperty("os", this.configInfo.getOs());
        this.script.printProperty("ws", this.configInfo.getWs());
        this.script.printProperty("arch", this.configInfo.getArch());
        this.script.printProperty("assemblyTempDir", String.valueOf(Utils.getPropertyFormat("buildDirectory")) + "/tmp");
        this.script.printProperty("eclipse.base", String.valueOf(Utils.getPropertyFormat("assemblyTempDir")) + '/' + Utils.getPropertyFormat("collectingFolder"));
        this.script.printProperty(this.PROPERTY_ECLIPSE_PLUGINS, String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins");
        this.script.printProperty(this.PROPERTY_ECLIPSE_FEATURES, String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features");
        this.script.printProperty("archiveFullPath", String.valueOf(Utils.getPropertyFormat("basedir")) + '/' + Utils.getPropertyFormat("buildLabel") + '/' + Utils.getPropertyFormat("archiveName"));
        if (this.productFile != null && this.productFile.getLauncherName() != null) {
            this.script.printProperty("launcherName", this.productFile.getLauncherName());
        }
        this.script.printProperty("tarargs", "");
        this.generatePackagingTargets();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateInitializationSteps() {
        if (BundleHelper.getDefault().isDebugging()) {
            this.script.printEchoTask("basedir : " + Utils.getPropertyFormat("basedir"));
            this.script.printEchoTask("assemblyTempDir : " + Utils.getPropertyFormat("assemblyTempDir"));
            this.script.printEchoTask("eclipse.base : " + Utils.getPropertyFormat("eclipse.base"));
            this.script.printEchoTask("collectingFolder : " + Utils.getPropertyFormat("collectingFolder"));
            this.script.printEchoTask("archivePrefix : " + Utils.getPropertyFormat("archivePrefix"));
        }
        this.script.println("<condition property=\"pluginArchivePrefix\" value=\"plugins\">");
        this.script.println("\t<equals arg1=\"" + Utils.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginArchivePrefix", String.valueOf(Utils.getPropertyFormat("archivePrefix")) + '/' + "plugins");
        this.script.println();
        this.script.println("<condition property=\"featureArchivePrefix\" value=\"features\">");
        this.script.println("\t<equals arg1=\"" + Utils.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("featureArchivePrefix", String.valueOf(Utils.getPropertyFormat("archivePrefix")) + '/' + "features");
        this.script.println();
        this.script.printDirName("archiveParentFolder", Utils.getPropertyFormat("archiveFullPath"));
        this.script.printMkdirTask(Utils.getPropertyFormat("archiveParentFolder"));
        this.script.printMkdirTask(Utils.getPropertyFormat("assemblyTempDir"));
        this.script.printMkdirTask(Utils.getPropertyFormat("buildLabel"));
    }

    protected void generatePostProcessingSteps() {
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            this.generatePostProcessingSteps(plugin.getSymbolicName(), plugin.getVersion().toString(), (String)this.getFinalShape(plugin)[1], (byte)0);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            this.generatePostProcessingSteps(feature.getVersionedIdentifier().getIdentifier(), feature.getVersionedIdentifier().getVersion().toString(), (String)this.getFinalShape(feature)[1], (byte)1);
            ++i;
        }
    }

    protected void generateGatherBinPartsCalls() {
        int j;
        IFeature feature;
        String placeToGather;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", Utils.getPropertyFormat("eclipse.base"));
        i = 0;
        while (i < this.features.length) {
            feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", Utils.getPropertyFormat("eclipse.base"));
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            feature = (IFeature)iter.next();
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
        }
    }

    private void generateSignJarCall(String name, String version, byte type) {
        if (!this.signJars) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, String.valueOf(name) + '_' + version);
        this.script.printAntCallTask("jarSigning", true, properties);
    }

    private void generatePostProcessingSteps(String name, String version, String style, byte type) {
        if (FOLDER.equalsIgnoreCase(style)) {
            return;
        }
        if (FILE.equalsIgnoreCase(style)) {
            this.generateJarUpCall(name, version, type);
            this.generateSignJarCall(name, version, type);
            this.generateJNLPCall(name, version, type);
            return;
        }
    }

    private void generateJNLPCall(String name, String version, byte type) {
        if (!this.generateJnlp) {
            return;
        }
        if (type != 1) {
            return;
        }
        String dir = type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES);
        String location = String.valueOf(dir) + '/' + name + '_' + version + ".jar";
        this.script.println("<eclipse.jnlpGenerator feature=\"" + location + "\"  codebase=\"" + Utils.getPropertyFormat("jnlp.codebase") + "\" j2se=\"" + Utils.getPropertyFormat("jnlp.j2se") + "\"/>");
    }

    private boolean getUnpackClause(BundleDescription bundle) {
        Set entries = (Set)((Properties)bundle.getUserObject()).get("pluginEntry");
        return ((PluginEntry)entries.iterator().next()).isUnpack();
    }

    protected Object[] getFinalShape(BundleDescription bundle) {
        String style = this.getUnpackClause(bundle) ? FLAT : UPDATEJAR;
        return this.getFinalShape(bundle.getSymbolicName(), bundle.getVersion().toString(), style, (byte)0);
    }

    protected Object[] getFinalShape(IFeature feature) {
        return this.getFinalShape(feature.getVersionedIdentifier().getIdentifier(), feature.getVersionedIdentifier().getVersion().toString(), FLAT, (byte)1);
    }

    protected Object[] getFinalShape(String name, String version, String initialShape, byte type) {
        String style = initialShape;
        if (FLAT.equalsIgnoreCase(style = this.getShapeOverride(name, type, style))) {
            return new Object[]{String.valueOf(name) + '_' + version, FOLDER};
        }
        if (UPDATEJAR.equalsIgnoreCase(style)) {
            return new Object[]{String.valueOf(name) + '_' + version + ".jar", FILE};
        }
        return new Object[]{String.valueOf(name) + '_' + version, FOLDER};
    }

    private String getShapeOverride(String name, byte type, String initialStyle) {
        Properties currentProperties;
        String result = initialStyle;
        Properties properties = currentProperties = type == 0 ? this.pluginsPostProcessingSteps : this.featuresPostProcessingSteps;
        if (currentProperties.size() > 0) {
            String styleFromFile = currentProperties.getProperty(name);
            if (styleFromFile == null) {
                styleFromFile = currentProperties.getProperty("*");
            }
            result = styleFromFile;
        }
        if (forceUpdateJarFormat) {
            result = UPDATEJAR;
        }
        return result;
    }

    private void generateJarUpCall(String name, String version, byte type) {
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : Utils.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, String.valueOf(name) + '_' + version);
        this.script.printAntCallTask("jarUp", true, properties);
    }

    private void generateEpilogue() {
        if (!FOLDER.equalsIgnoreCase(this.archiveFormat)) {
            this.script.printDeleteTask(Utils.getPropertyFormat("assemblyTempDir"), null, null);
        }
        this.script.printTargetEnd();
        if ("tar".equalsIgnoreCase(this.archiveFormat)) {
            this.generateGZipTarget(true);
        }
        this.script.printProjectEnd();
        this.script.close();
        this.script = null;
    }

    public String getTargetName() {
        return "assemble" + (this.featureId.equals("") ? "" : String.valueOf('.') + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : String.valueOf('.') + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private void generateZipTarget() {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)this.getFinalShape(this.plugins[i])[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)this.getFinalShape(this.features[i])[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        this.createZipRootFileCommand();
    }

    private void createZipRootFileCommand() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-r -q ${zipargs} '" + Utils.getPropertyFormat("archiveFullPath") + "' . ");
        this.script.printExecTask("zip", String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), parameters, null);
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + Utils.getPropertyFormat("zipargs") + " '" + Utils.getPropertyFormat("archiveFullPath") + '\'');
        this.script.printExecTask("zip", Utils.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    protected String computeArchiveName() {
        String extension = "tar".equalsIgnoreCase(this.archiveFormat) || "antTar".equalsIgnoreCase(this.archiveFormat) ? ".tar.gz" : ".zip";
        return String.valueOf(this.featureId) + "-" + Utils.getPropertyFormat("buildId") + (this.configInfo.equals(Config.genericConfig()) ? "" : "-" + this.configInfo.toStringReplacingAny(".", "ANY")) + extension;
    }

    public void generateTarGZTasks(boolean assembling) {
        ArrayList<String> parameters = new ArrayList<String>(2);
        if (this.rootFileProviders.size() > 0) {
            parameters.add("-r '" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder") + "' '" + Utils.getPropertyFormat("assemblyTempDir") + '\'');
            this.script.printExecTask("cp", Utils.getPropertyFormat("basedir"), parameters, null);
            parameters.clear();
            parameters.add("-rf '" + Utils.getPropertyFormat("assemblyTempDir") + '/' + Utils.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '\'');
            this.script.printExecTask("rm", Utils.getPropertyFormat("basedir"), parameters, null);
        }
        parameters.clear();
        String tarArgs = assembling ? "-cvf '" : "-rvf '";
        parameters.add(String.valueOf(Utils.getPropertyFormat("tarargs")) + tarArgs + Utils.getPropertyFormat("archiveFullPath") + "' " + Utils.getPropertyFormat("archivePrefix") + ' ');
        this.script.printExecTask("tar", Utils.getPropertyFormat("assemblyTempDir"), parameters, null);
        this.script.printAntCallTask("gzipResults", true, null);
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-rf");
        args.add(String.valueOf('\'') + Utils.getPropertyFormat("assemblyTempDir") + '\'');
        this.script.printExecTask("rm", null, args, null);
    }

    protected void generateAntZipTarget() {
        FileSet[] rootFiles;
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.getFinalShape(this.plugins[i]);
            filesPlugins[i] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.getFinalShape(this.features[i2]);
            filesFeatures[i2] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        if (this.groupConfigs) {
            List allConfigs = AssembleConfigScriptGenerator.getConfigInfos();
            rootFiles = new FileSet[allConfigs.size()];
            int i3 = 0;
            Iterator iter = allConfigs.iterator();
            while (iter.hasNext()) {
                Config elt = (Config)iter.next();
                rootFiles[i3++] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + elt.toStringReplacingAny(".", "ANY"), false, null, "**/**", null, null, null, elt.toStringReplacingAny(".", "ANY"), null, null);
            }
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
        } else {
            FileSet[] permissionSets = this.generatePermissions(true);
            rootFiles = new FileSet[permissionSets.length + 1];
            String toExcludeFromArchive = Utils.getStringFromCollection(this.addedByPermissions, ",");
            System.arraycopy(permissionSets, 0, rootFiles, 1, permissionSets.length);
            rootFiles[0] = new ZipFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder"), false, null, "**/**", null, toExcludeFromArchive, null, Utils.getPropertyFormat("archivePrefix"), null, null);
            this.script.printZipTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
        }
    }

    protected FileSet[] generatePermissions(boolean zip) {
        String configInfix = this.configInfo.toString(".");
        String prefixPermissions = "root." + configInfix + '.' + "permissions" + '.';
        String commonPermissions = "root.permissions.";
        ArrayList<ZipFileSet> fileSets = new ArrayList<ZipFileSet>();
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            Properties featureProperties = null;
            try {
                featureProperties = AbstractScriptGenerator.readProperties(new Path(((IFeature)iter.next()).getURL().getFile()).removeLastSegments(1).toOSString(), "build.properties", 0);
            }
            catch (CoreException coreException) {
                return new FileSet[0];
            }
            Iterator<Map.Entry<Object, Object>> iter2 = featureProperties.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry<Object, Object> permission = iter2.next();
                String instruction = (String)permission.getKey();
                String parameters = (String)permission.getValue();
                String[] values = Utils.getArrayFromString(parameters);
                int i = 0;
                while (i < values.length) {
                    boolean isFile = !values[i].endsWith("/");
                    String prefix = String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder");
                    if (instruction.startsWith(prefixPermissions)) {
                        this.addedByPermissions.add(values[i]);
                        if (zip) {
                            fileSets.add(new ZipFileSet(String.valueOf(prefix) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(prefixPermissions.length())));
                        } else {
                            fileSets.add(new TarFileSet(String.valueOf(prefix) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(prefixPermissions.length())));
                        }
                    } else if (instruction.startsWith(commonPermissions)) {
                        this.addedByPermissions.add(values[i]);
                        if (zip) {
                            fileSets.add(new ZipFileSet(String.valueOf(prefix) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(commonPermissions.length())));
                        } else {
                            fileSets.add(new TarFileSet(String.valueOf(prefix) + (isFile ? String.valueOf('/') + values[i] : ""), isFile, null, isFile ? null : String.valueOf(values[i]) + "/**", null, null, null, String.valueOf(Utils.getPropertyFormat("archivePrefix")) + (isFile ? String.valueOf('/') + values[i] : ""), null, instruction.substring(commonPermissions.length())));
                        }
                    }
                    ++i;
                }
            }
        }
        return fileSets.toArray(new FileSet[fileSets.size()]);
    }

    private void generateAntTarTarget() {
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.getFinalShape(this.plugins[i]);
            filesPlugins[i] = new TarFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.getFinalShape(this.features[i2]);
            filesFeatures[i2] = new TarFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(Utils.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null, null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        FileSet[] permissionSets = this.generatePermissions(false);
        FileSet[] rootFiles = new FileSet[permissionSets.length + 1];
        System.arraycopy(permissionSets, 0, rootFiles, 1, permissionSets.length);
        rootFiles[0] = new TarFileSet(String.valueOf(Utils.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + Utils.getPropertyFormat("collectingFolder"), false, null, "**/**", null, null, null, Utils.getPropertyFormat("archivePrefix"), null, null);
        this.script.printTarTask(Utils.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
    }

    public void setGenerateJnlp(boolean value) {
        this.generateJnlp = value;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    public void setProduct(String value) {
        this.product = value;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setGroupConfigs(boolean group) {
        this.groupConfigs = group;
    }
}

