/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class InvertedColorScheme
implements ColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public InvertedColorScheme(ColorScheme origScheme) {
        this.origScheme = origScheme;
        this.foregroundColor = SubstanceColorUtilities.invertColor(origScheme.getForegroundColor());
        this.mainUltraDarkColor = SubstanceColorUtilities.invertColor(origScheme.getUltraLightColor());
        this.mainDarkColor = SubstanceColorUtilities.invertColor(origScheme.getExtraLightColor());
        this.mainMidColor = SubstanceColorUtilities.invertColor(origScheme.getLightColor());
        this.mainLightColor = SubstanceColorUtilities.invertColor(origScheme.getMidColor());
        this.mainExtraLightColor = SubstanceColorUtilities.invertColor(origScheme.getDarkColor());
        this.mainUltraLightColor = SubstanceColorUtilities.invertColor(origScheme.getUltraDarkColor());
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }
}

