/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceListUI
extends BasicListUI {
    protected boolean isFileList;
    protected boolean isLeftToRight;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    public static ComponentUI createUI(JComponent list) {
        return new SubstanceListUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        if (SubstanceLookAndFeel.toBleedWatermark()) {
            this.list.setOpaque(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.isFileList) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                cx += cw - w;
            }
            cw = w;
        }
        if (isSelected) {
            backgroundDelegate.update(g, rendererComponent, new Rectangle(cx, cy, cw, ch), SubstanceLookAndFeel.getColorScheme(), true);
        }
        if (rendererComponent instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)rendererComponent;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl = newOpaque = !isSelected;
                if (SubstanceLookAndFeel.toBleedWatermark()) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
    }
}

