/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    protected PropertyChangeListener propertyListener;
    protected PropertyChangeListener winModifiedListener;
    private static WeakHashMap<JInternalFrame, BufferedImage> snapshots = new WeakHashMap();

    public SubstanceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        this.setToolTipText(f.getTitle());
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("title".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.setToolTipText((String)evt.getNewValue());
                }
                if ("ancestor".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.updateSnapshot(SubstanceInternalFrameTitlePane.this.frame);
                }
            }
        };
        this.frame.addPropertyChangeListener(this.propertyListener);
        this.winModifiedListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("windowModified".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        SubstanceInternalFrameTitlePane.this.closeButton.setToolTipText(UIManager.getString("InternalFrame.closeButtonToolTip") + " [" + SubstanceLookAndFeel.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]");
                    } else {
                        SubstanceInternalFrameTitlePane.this.closeButton.setToolTipText(UIManager.getString("InternalFrame.closeButtonToolTip"));
                    }
                }
            }
        };
        this.frame.addPropertyChangeListener(this.winModifiedListener);
        this.frame.getRootPane().addPropertyChangeListener(this.winModifiedListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
        this.frame.removePropertyChangeListener(this.winModifiedListener);
        this.frame.getRootPane().removePropertyChangeListener(this.winModifiedListener);
        this.winModifiedListener = null;
        super.uninstallListeners();
    }

    public void paintComponent(Graphics g) {
        String clippedTitle;
        int titleWidth;
        FontMetrics fm;
        Rectangle rect;
        int iconY;
        Icon icon;
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        boolean isSelected = this.frame.isSelected();
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight() + 2;
        ColorScheme colorScheme = isSelected ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
        SubstanceImageCreator.paintRectangularBackground(graphics, 0, 0, width, height, colorScheme, false, false);
        if (!Boolean.TRUE.equals(this.getClientProperty("substancelaf.previewMode"))) {
            SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, this, 0, 0, width, height);
        }
        Composite oldComp = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        SubstanceImageCreator.paintRectangularBackground(graphics, 0, 0, width, height + 1, colorScheme, false, false);
        graphics.setComposite(oldComp);
        int xOffset = 0;
        String theTitle = this.frame.getTitle();
        if (leftToRight) {
            xOffset = 5;
            icon = this.frame.getFrameIcon();
            if (icon != null) {
                iconY = height / 2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.frame, graphics, xOffset, iconY);
                xOffset += icon.getIconWidth() + 5;
            }
            int leftEnd = this.menuBar == null ? 0 : this.menuBar.getWidth() + 30;
            xOffset += leftEnd;
            int rightEnd = width - 5;
            JButton leftmostButton = null;
            if (this.frame.isIconifiable()) {
                leftmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                leftmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                leftmostButton = this.closeButton;
            }
            if (leftmostButton != null) {
                rect = leftmostButton.getBounds();
                rightEnd = rect.getBounds().x - 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 30, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
            }
        } else {
            xOffset = width - 5;
            icon = this.frame.getFrameIcon();
            if (icon != null) {
                iconY = height / 2 - icon.getIconHeight() / 2;
                icon.paintIcon(this.frame, graphics, width - 5 - icon.getIconWidth(), iconY);
                xOffset -= icon.getIconWidth() + 5;
            }
            int rightEnd = this.menuBar == null ? xOffset : xOffset - this.menuBar.getWidth() - 20;
            JButton rightmostButton = null;
            if (this.frame.isIconifiable()) {
                rightmostButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                rightmostButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                rightmostButton = this.closeButton;
            }
            int leftEnd = 5;
            if (rightmostButton != null) {
                rect = rightmostButton.getBounds();
                leftEnd = rect.getBounds().x + 5;
            }
            if (theTitle != null) {
                fm = this.frame.getFontMetrics(graphics.getFont());
                clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth = rightEnd - leftEnd - 30, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
                xOffset = rightEnd - fm.stringWidth(theTitle);
            }
        }
        if (theTitle != null) {
            FontMetrics fm2 = this.frame.getFontMetrics(graphics.getFont());
            int yOffset = (height - fm2.getHeight()) / 2 + fm2.getAscent();
            Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            SubstanceTheme.ThemeKind themeKind = SubstanceLookAndFeel.getTheme().getKind();
            boolean isDark = themeKind == SubstanceTheme.ThemeKind.DARK;
            Color foregroundColor = isDark ? colorScheme.getForegroundColor() : colorScheme.getUltraDarkColor().darker();
            BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
            gBlurred.setFont(graphics.getFont());
            gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            gBlurred.setColor(SubstanceColorUtilities.getNegativeColor(foregroundColor));
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.05f, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.1f, 0.1f}), 1, null);
            gBlurred.drawString(theTitle, xOffset + 1, yOffset + 1);
            blurred = convolve.filter(blurred, null);
            graphics.drawImage((Image)blurred, 0, 0, null);
            graphics.setColor(foregroundColor);
            graphics.drawString(theTitle, xOffset, yOffset);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
        graphics.dispose();
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        SubstanceTheme iconTheme = SubstanceLookAndFeel.getTheme();
        Icon minIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, iconTheme);
        Icon maxIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, iconTheme);
        Icon iconIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, iconTheme);
        Icon closeIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, iconTheme);
        if (this.frame.isIcon()) {
            if (minIcon != null) {
                this.iconButton.setIcon(minIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        } else if (this.frame.isMaximum()) {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (minIcon != null) {
                this.maxButton.setIcon(minIcon);
            }
        } else {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        }
        if (closeIcon != null) {
            this.closeButton.setIcon(closeIcon);
        }
    }

    protected void createButtons() {
        super.createButtons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener listener : this.maxButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        ButtonBackgroundDelegate.trackTitleButton(this.iconButton, SubstanceConstants.ButtonTitleKind.REGULAR);
        ButtonBackgroundDelegate.trackTitleButton(this.maxButton, SubstanceConstants.ButtonTitleKind.REGULAR);
        ButtonBackgroundDelegate.trackTitleButton(this.closeButton, SubstanceConstants.ButtonTitleKind.CLOSE);
    }

    public static synchronized BufferedImage getSnapshot(JInternalFrame frame) {
        BufferedImage result = snapshots.get(frame);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static void updateSnapshot(JInternalFrame frame) {
        if (!frame.isShowing()) {
            return;
        }
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int dx = 0;
        int dy = 0;
        Border internalFrameBorder = UIManager.getBorder("InternalFrame.border");
        Insets borderInsets = internalFrameBorder.getBorderInsets(frame);
        dx += borderInsets.left;
        dy += borderInsets.top;
        frameHeight -= borderInsets.top + borderInsets.bottom;
        BasicInternalFrameUI frameUI = (BasicInternalFrameUI)frame.getUI();
        JComponent frameTitlePane = frameUI.getNorthPane();
        dy += frameTitlePane.getHeight();
        if ((frameWidth -= borderInsets.left + borderInsets.right) > 0 && (frameHeight -= frameTitlePane.getHeight()) > 0) {
            int maxWidth;
            BufferedImage tempCanvas = new BufferedImage(frameWidth, frameHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            tempCanvasGraphics.translate(-dx, -dy);
            frame.paint(tempCanvasGraphics);
            int maxHeight = maxWidth = UIManager.getInt("DesktopIcon.width");
            double coef = Math.min((double)maxWidth / (double)frameWidth, (double)maxHeight / (double)frameHeight);
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)frameWidth);
                BufferedImage scaledDown = SubstanceCoreUtilities.createThumbnail(tempCanvas, sdWidth);
                snapshots.put(frame, scaledDown);
            } else {
                snapshots.put(frame, tempCanvas);
            }
        }
    }

    public static class ClickListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

