/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MixBiColorScheme;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceMixBiTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubstanceImageCreator {
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    public static void paintBorder(Graphics g, int x, int y, int width, int height, ColorScheme borderScheme, SubstanceTheme theme) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme);
        Color topBorderColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(borderScheme.getExtraLightColor(), borderScheme.getForegroundColor(), 0.5) : borderScheme.getDarkColor();
        Color bottomBorderColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(borderScheme.getExtraLightColor(), borderScheme.getForegroundColor(), 0.8) : borderScheme.getMidColor();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(x, y, topBorderColor, x, y + height - 1, bottomBorderColor);
        graphics.setPaint(gradient);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.drawLine(x, y, x + width - 1, y);
        graphics.drawLine(x, y, x, y + height - 1);
        graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        graphics.dispose();
    }

    public static void paintBorder(Graphics g, int x, int y, int width, int height, SubstanceTheme theme) {
        SubstanceImageCreator.paintBorder(g, x, y, width, height, theme.getColorScheme(), theme);
    }

    private static BufferedImage getCheckMark(int dimension, boolean isEnabled, ColorScheme colorScheme, float checkMarkVisibility) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorScheme.getForegroundColor());
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics.setStroke(stroke);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.25f * (float)dimension, 0.5f * (float)dimension);
        path.quadTo(0.4f * (float)dimension, 0.6f * (float)dimension, 0.5f * (float)dimension, 0.8f * (float)dimension);
        path.quadTo(0.55f * (float)dimension, 0.5f * (float)dimension, 0.85f * (float)dimension, 0.0f);
        float xClipStart = 0.15f * (float)dimension;
        float xClipEnd = 0.95f * (float)dimension;
        float xClipRealEnd = xClipStart + (xClipEnd - xClipStart) * checkMarkVisibility;
        graphics.setClip(0, 0, (int)Math.ceil(xClipRealEnd), dimension);
        graphics.draw(path);
        return result;
    }

    public static Icon getArrowIcon(int width, int height, int direction, ColorScheme colorScheme) {
        BufferedImage arrowImage = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)arrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorScheme.getForegroundColor());
        BasicStroke stroke = new BasicStroke(2.0f, 0, 0);
        graphics.setStroke(stroke);
        if (direction == 0) {
            GeneralPath gp = new GeneralPath();
            float h2 = (float)height / 2.0f;
            float w2 = 0.5f * (float)(width - 1);
            gp.moveTo(0.0f, h2 - 1.0f);
            gp.lineTo(w2, 2.0f);
            gp.lineTo(width - 1, h2 - 1.0f);
            gp.moveTo(width - 1, h2 + 1.0f);
            gp.lineTo(w2, height - 2);
            gp.lineTo(0.0f, h2 + 1.0f);
            graphics.draw(gp);
            return new ImageIcon(arrowImage);
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.5f * (float)(width - 1), height - 2);
        gp.lineTo(width - 1, 0.0f);
        graphics.draw(gp);
        int quadrantCounterClockwise = 0;
        switch (direction) {
            case 1: {
                quadrantCounterClockwise = 2;
                break;
            }
            case 7: {
                quadrantCounterClockwise = 1;
                break;
            }
            case 5: {
                quadrantCounterClockwise = 0;
                break;
            }
            case 3: {
                quadrantCounterClockwise = 3;
            }
        }
        BufferedImage rotatedImage = SubstanceImageCreator.getRotated(arrowImage, quadrantCounterClockwise);
        return new ImageIcon(rotatedImage);
    }

    public static Icon getDoubleArrowIcon(int width, int height, int direction, ColorScheme colorScheme) {
        BufferedImage downArrowImage = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorScheme.getForegroundColor());
        BasicStroke stroke = new BasicStroke(1.5f, 0, 0);
        graphics.setStroke(stroke);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.5f * (float)(width - 1), height - 4);
        gp.lineTo(width - 1, 0.0f);
        graphics.draw(gp);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(0.0f, 3.0f);
        gp2.lineTo(0.5f * (float)(width - 1), height - 1);
        gp2.lineTo(width - 1, 3.0f);
        graphics.draw(gp2);
        int quadrantCounterClockwise = 0;
        switch (direction) {
            case 1: {
                quadrantCounterClockwise = 2;
                break;
            }
            case 7: {
                quadrantCounterClockwise = 1;
                break;
            }
            case 5: {
                quadrantCounterClockwise = 0;
                break;
            }
            case 3: {
                quadrantCounterClockwise = 3;
            }
        }
        BufferedImage arrowImage = SubstanceImageCreator.getRotated(downArrowImage, quadrantCounterClockwise);
        return new ImageIcon(arrowImage);
    }

    public static BufferedImage getRotated(BufferedImage bi, int quadrantClockwise) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        if ((quadrantClockwise %= 4) == 1 || quadrantClockwise == 3) {
            width = bi.getHeight();
            height = bi.getWidth();
        }
        BufferedImage biRot = SubstanceCoreUtilities.getBlankImage(width, height);
        switch (quadrantClockwise) {
            case 0: {
                return bi;
            }
            case 1: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(row, width - col - 1));
                    }
                }
                return biRot;
            }
            case 2: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(width - col - 1, height - row - 1));
                    }
                }
                return biRot;
            }
            case 3: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(height - row - 1, col));
                    }
                }
                return biRot;
            }
        }
        return null;
    }

    public static Icon toGreyscale(Icon icon) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = color >>> 24 & 0xFF;
                int oldR = color >>> 16 & 0xFF;
                int oldG = color >>> 8 & 0xFF;
                int oldB = color >>> 0 & 0xFF;
                int newComp = (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
                int newColor = transp << 24 | newComp << 16 | newComp << 8 | newComp;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    public static Icon makeTransparent(Icon icon, double alpha) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = (int)(alpha * (double)(color >>> 24 & 0xFF));
                int r = color >>> 16 & 0xFF;
                int g = color >>> 8 & 0xFF;
                int b = color >>> 0 & 0xFF;
                int newColor = transp << 24 | r << 16 | g << 8 | b;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState, int offsetX) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        ColorScheme scheme = SubstanceLookAndFeel.getColorScheme(SubstanceLookAndFeel.getColorScheme(), kind);
        return SubstanceImageCreator.getRadioButton(dimension, componentState, offsetX, scheme, scheme, 0, componentState.isSelected() ? 1.0f : 0.0f);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState, int offsetX, ColorScheme colorScheme1, ColorScheme colorScheme2, int interpolationCyclePos, float checkMarkVisibility) {
        int cyclePos = colorScheme1 != colorScheme2 ? interpolationCyclePos : componentState.getCycleCount();
        Ellipse2D.Float contour = new Ellipse2D.Float(0.0f, 0.0f, dimension - 1, dimension - 1);
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        BufferedImage background = painter.getContourBackground(dimension, dimension, contour, false, colorScheme1, colorScheme2, cyclePos, true, colorScheme1 != colorScheme2);
        BufferedImage offBackground = SubstanceCoreUtilities.getBlankImage(dimension + offsetX, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offsetX, 0, null);
        float rc = (float)dimension / 2.0f;
        float radius = (float)dimension / 4.5f;
        graphics.translate(offsetX, 0);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (componentState.isSelected() || (double)checkMarkVisibility > 0.0) {
            graphics.setComposite(AlphaComposite.getInstance(3, checkMarkVisibility));
            graphics.setColor(colorScheme1.getForegroundColor());
            Ellipse2D.Double markOval = new Ellipse2D.Double(rc - radius, rc - radius, 2.0f * radius, 2.0f * radius);
            graphics.fill(markOval);
        } else {
            graphics.setPaint(new GradientPaint(rc + radius, rc - radius, colorScheme1.getDarkColor(), rc - radius, rc + radius, colorScheme1.getLightColor()));
            Ellipse2D.Double markOval = new Ellipse2D.Double(rc - radius, rc - radius, 2.0f * radius, 2.0f * radius);
            graphics.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics.fill(markOval);
        }
        graphics.translate(-offsetX, 0);
        return offBackground;
    }

    public static BufferedImage getCheckBox(int dimension, ComponentState componentState) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        ColorScheme scheme = SubstanceLookAndFeel.getColorScheme(SubstanceLookAndFeel.getColorScheme(), kind);
        return SubstanceImageCreator.getCheckBox(dimension, componentState, scheme, scheme, 0, componentState.isSelected() ? 1.0f : 0.0f);
    }

    public static BufferedImage getCheckBox(int dimension, ComponentState componentState, ColorScheme colorScheme1, ColorScheme colorScheme2, int interpolationCyclePos, float checkMarkVisibility) {
        int offset = 2;
        int cornerRadius = 2;
        if (dimension <= 10) {
            offset = 1;
            cornerRadius = 2;
        }
        int cyclePos = colorScheme1 != colorScheme2 ? interpolationCyclePos : componentState.getCycleCount();
        GeneralPath contour = BaseButtonShaper.getBaseOutline(dimension - offset, dimension - offset, cornerRadius, null);
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        BufferedImage background = painter.getContourBackground(dimension - offset, dimension - offset, contour, false, colorScheme1, colorScheme2, cyclePos, true, colorScheme1 != colorScheme2);
        BufferedImage offBackground = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offset, offset, null);
        if (componentState.isSelected() || (double)checkMarkVisibility > 0.0) {
            BufferedImage checkMark = SubstanceImageCreator.getCheckMark(dimension - offset, componentState.isEnabled(), colorScheme1, checkMarkVisibility);
            graphics.drawImage((Image)checkMark, offset, 0, null);
        }
        return offBackground;
    }

    public static BufferedImage getCompositeRoundedBackground(int width, int height, int cornerRadius, ComponentState compDecrState, ComponentState compIncrState, boolean flipSides) {
        return SubstanceImageCreator.getCompositeRoundedBackground(SubstanceLookAndFeel.getColorScheme(), SubstanceLookAndFeel.getGrayColorScheme(), width, height, cornerRadius, compDecrState, compIncrState, flipSides);
    }

    public static BufferedImage getCompositeRoundedBackground(ColorScheme colorScheme, ColorScheme grayColorScheme, int width, int height, int cornerRadius, ComponentState compDecrState, ComponentState compIncrState, boolean flipSides) {
        ComponentState.ColorSchemeKind decrKind = compDecrState.getColorSchemeKind();
        int decrCyclePos = compDecrState.getCycleCount();
        ColorScheme decrColorScheme = SubstanceLookAndFeel.getColorScheme(colorScheme, decrKind);
        HashSet<SubstanceConstants.Side> left = new HashSet<SubstanceConstants.Side>();
        left.add(SubstanceConstants.Side.LEFT);
        HashSet<SubstanceConstants.Side> right = new HashSet<SubstanceConstants.Side>();
        right.add(SubstanceConstants.Side.RIGHT);
        int delta = 3;
        StandardGradientPainter painter = new StandardGradientPainter();
        BufferedImage decrLayer = painter.getContourBackground(width + 2 * delta, height, BaseButtonShaper.getBaseOutline(width + 2 * delta, height, 0.0f, flipSides ? right : left), false, decrColorScheme, decrColorScheme, decrCyclePos, true, false);
        ComponentState.ColorSchemeKind incrKind = compIncrState.getColorSchemeKind();
        int incrCyclePos = compIncrState.getCycleCount();
        ColorScheme incrColorScheme = SubstanceLookAndFeel.getColorScheme(colorScheme, incrKind);
        BufferedImage incrLayer = painter.getContourBackground(width + 2 * delta, height, BaseButtonShaper.getBaseOutline(width + 2 * delta, height, 0.0f, flipSides ? left : right), false, incrColorScheme, incrColorScheme, incrCyclePos, true, false);
        BufferedImage mainLayer = painter.getContourBackground(width, height, BaseButtonShaper.getBaseOutline(width, height, cornerRadius, null), false, grayColorScheme, grayColorScheme, 0, true, false);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        if (!flipSides) {
            graphics.drawImage(decrLayer, -delta, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(incrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        } else {
            graphics.drawImage(incrLayer, -delta, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(decrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        }
        graphics.drawImage((Image)mainLayer, 0, 0, null);
        return result;
    }

    public static BufferedImage getOneLineGradient(int width, Color colorLeft, Color colorRight, Map<Integer, Color> waypoints) {
        BufferedImage image = new BufferedImage(width, 1, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ArrayList<Integer> waypointMarkers = new ArrayList<Integer>();
        if (waypoints != null) {
            for (Integer marker : waypoints.keySet()) {
                waypointMarkers.add(marker);
            }
        }
        Collections.sort(waypointMarkers);
        int[] markers = new int[waypointMarkers.size() + 2];
        Color[] colors = new Color[waypointMarkers.size() + 2];
        markers[0] = 0;
        colors[0] = colorLeft;
        int index = 1;
        for (Integer marker : waypointMarkers) {
            markers[index] = marker;
            colors[index] = waypoints.get(marker);
            ++index;
        }
        markers[index] = width - 1;
        colors[index] = colorRight;
        for (int i = 0; i < markers.length - 1; ++i) {
            GradientPaint gradient = new GradientPaint(markers[i], 0.0f, colors[i], markers[i + 1], 0.0f, colors[i + 1]);
            graphics.setPaint(gradient);
            graphics.fillRect(markers[i], 0, markers[i + 1] - markers[i], 1);
        }
        return image;
    }

    public static void paintOneLineGradient(Graphics2D graphics, int x, int y, int dimension, boolean isVertical, Color colorLeft, Color colorRight, Map<Integer, Color> waypoints) {
        GradientPaint gradient;
        graphics.translate(x, y);
        ArrayList<Integer> waypointMarkers = new ArrayList<Integer>();
        if (waypoints != null) {
            for (Integer marker : waypoints.keySet()) {
                waypointMarkers.add(marker);
            }
        }
        Collections.sort(waypointMarkers);
        int[] markers = new int[waypointMarkers.size() + 2];
        Color[] colors = new Color[waypointMarkers.size() + 2];
        markers[0] = 0;
        colors[0] = colorLeft;
        int index = 1;
        for (Integer marker : waypointMarkers) {
            markers[index] = marker;
            colors[index] = waypoints.get(marker);
            ++index;
        }
        markers[index] = dimension - 1;
        colors[index] = colorRight;
        if (!isVertical) {
            for (int i = 0; i < markers.length - 1; ++i) {
                gradient = new GradientPaint(markers[i], 0.0f, colors[i], markers[i + 1], 0.0f, colors[i + 1]);
                graphics.setPaint(gradient);
                graphics.fillRect(markers[i], 0, markers[i + 1] - markers[i], 1);
            }
        } else {
            for (int i = 0; i < markers.length - 1; ++i) {
                gradient = new GradientPaint(0.0f, markers[i], colors[i], 0.0f, markers[i + 1], colors[i + 1]);
                graphics.setPaint(gradient);
                graphics.fillRect(0, markers[i], 1, markers[i + 1] - markers[i]);
            }
        }
        graphics.translate(-x, -y);
    }

    private static BufferedImage overlayEcho(BufferedImage image, int offsetX, int offsetY) {
        int width = image.getWidth();
        int height = image.getHeight();
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.0f, 0.2f, 0.2f, 0.2f, 0.2f}), 1, null);
        BufferedImage echo = convolve.filter(image, null);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                int color = echo.getRGB(col, row);
                int transp = color >>> 24 & 0xFF;
                int r = color >>> 16 & 0xFF;
                int g = color >>> 8 & 0xFF;
                int b = color >>> 0 & 0xFF;
                echo.setRGB(col, row, transp << 24 | 255 - r << 16 | 255 - g << 8 | 255 - b);
            }
        }
        echo.getGraphics().drawImage(image, 0, 0, null);
        return echo;
    }

    public static Icon getMinimizeIcon(SubstanceTheme theme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(theme.getColorScheme().getForegroundColor());
        graphics.fillRect(start + 2, end - 2, size, 3);
        return new ImageIcon(SubstanceImageCreator.overlayEcho(image, 1, 1));
    }

    public static Icon getRestoreIcon(SubstanceTheme theme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(theme.getColorScheme().getForegroundColor());
        graphics.drawRect(start, end - size + 1, size, size);
        graphics.drawLine(start, end - size + 2, start + size, end - size + 2);
        graphics.fillRect(end - size, start + 1, size + 1, 2);
        graphics.drawLine(end, start + 1, end, start + size + 1);
        graphics.drawLine(start + size + 2, start + size + 1, end, start + size + 1);
        return new ImageIcon(SubstanceImageCreator.overlayEcho(image, 1, 1));
    }

    public static Icon getMaximizeIcon(SubstanceTheme theme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 3;
        int end = 12;
        graphics.setColor(theme.getColorScheme().getForegroundColor());
        graphics.drawRect(start, start, end - start, end - start);
        graphics.drawLine(start, start + 1, end - start + 2, start + 1);
        return new ImageIcon(SubstanceImageCreator.overlayEcho(image, 1, 1));
    }

    public static Icon getCloseIcon(SubstanceTheme theme) {
        return SubstanceImageCreator.getCloseIcon(16, theme);
    }

    public static Icon getCloseIcon(int dimension, SubstanceTheme theme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int start = dimension / 4;
        int end = dimension + 1 - start / 2;
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        graphics.setStroke(stroke);
        graphics.setColor(theme.getColorScheme().getForegroundColor());
        graphics.drawLine(start, start, end - start, end - start);
        graphics.drawLine(start, end - start, end - start, start);
        return new ImageIcon(SubstanceImageCreator.overlayEcho(image, 1, 1));
    }

    public static void paintRectangularBackground(Graphics g, int startX, int startY, int width, int height, ColorScheme colorScheme, boolean hasDarkBorder, boolean isVertical) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        if (colorScheme instanceof MixBiColorScheme) {
            ColorScheme scheme1 = ((MixBiColorScheme)colorScheme).getOrigMainScheme();
            ColorScheme scheme2 = ((MixBiColorScheme)colorScheme).getOrigSecondaryScheme();
            if (!isVertical) {
                HashMap<Integer, Color> gradColors1 = new HashMap<Integer, Color>();
                gradColors1.put((int)(0.4 * (double)height), scheme1.getLightColor());
                gradColors1.put((int)(0.5 * (double)height), scheme1.getMidColor());
                BufferedImage horLine1 = SubstanceImageCreator.getOneLineGradient(height, scheme1.getUltraLightColor(), scheme1.getUltraLightColor(), gradColors1);
                HashMap<Integer, Color> gradColors2 = new HashMap<Integer, Color>();
                gradColors2.put((int)(0.4 * (double)height), scheme2.getLightColor());
                gradColors2.put((int)(0.5 * (double)height), scheme2.getMidColor());
                BufferedImage horLine2 = SubstanceImageCreator.getOneLineGradient(height, scheme2.getUltraLightColor(), scheme2.getUltraLightColor(), gradColors2);
                BufferedImage verLine1 = SubstanceImageCreator.getRotated(horLine1, 1);
                BufferedImage verLine2 = SubstanceImageCreator.getRotated(horLine2, 1);
                int col = 0;
                while ((double)col < 0.7 * (double)width) {
                    graphics.drawImage((Image)verLine1, col, 0, null);
                    ++col;
                }
                col = (int)(0.3 * (double)width);
                while ((double)col < 0.7 * (double)width) {
                    float alpha = ((float)col - 0.3f * (float)width) / (0.4f * (float)width);
                    alpha = Math.min(alpha, 1.0f);
                    alpha = Math.max(alpha, 0.0f);
                    graphics.setComposite(AlphaComposite.getInstance(3, alpha));
                    graphics.drawImage((Image)verLine2, col, 0, null);
                    ++col;
                }
                graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
                for (col = (int)(0.7 * (double)width); col < width; ++col) {
                    graphics.drawImage((Image)verLine2, col, 0, null);
                }
            } else {
                HashMap<Integer, Color> gradColors1 = new HashMap<Integer, Color>();
                gradColors1.put((int)(0.4 * (double)width), scheme1.getLightColor());
                gradColors1.put((int)(0.5 * (double)width), scheme1.getMidColor());
                BufferedImage horLine1 = SubstanceImageCreator.getOneLineGradient(width, scheme1.getUltraLightColor(), scheme1.getUltraLightColor(), gradColors1);
                HashMap<Integer, Color> gradColors2 = new HashMap<Integer, Color>();
                gradColors2.put((int)(0.4 * (double)width), scheme2.getLightColor());
                gradColors2.put((int)(0.5 * (double)width), scheme2.getMidColor());
                BufferedImage horLine2 = SubstanceImageCreator.getOneLineGradient(width, scheme2.getUltraLightColor(), scheme2.getUltraLightColor(), gradColors2);
                BufferedImage horLine = SubstanceCoreUtilities.blendImages(horLine1, horLine2, 0.3, 0.7);
                for (int row = 1; row < height; ++row) {
                    graphics.drawImage((Image)horLine, 0, row, null);
                }
            }
        } else if (!isVertical) {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.4 * (double)height), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
            BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
            for (int col = 0; col < width; ++col) {
                graphics.drawImage((Image)verLine, col, 0, null);
            }
        } else {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.4 * (double)width), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)width), colorScheme.getMidColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(width, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
            for (int row = 1; row < height; ++row) {
                graphics.drawImage((Image)horLine, 0, row, null);
            }
        }
        if (hasDarkBorder) {
            graphics.setColor(colorScheme.getMidColor());
            graphics.drawLine(0, 0, width - 1, 0);
            graphics.drawLine(0, 0, 0, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.drawLine(width - 1, 0, width - 1, height - 1);
        }
        graphics.dispose();
    }

    public static void paintRectangularStripedBackground(Graphics g, int startX, int startY, int width, int height, ColorScheme colorScheme, BufferedImage stripeImage, int stripeOffset, boolean isVertical) {
        Graphics2D graphics = (Graphics2D)g.create(startX, startY, width, height);
        if (!isVertical) {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.2 * (double)height), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
            gradColors.put((int)(0.8 * (double)height), colorScheme.getLightColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getDarkColor(), colorScheme.getDarkColor(), gradColors);
            BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
            for (int col = 0; col < width; ++col) {
                graphics.drawImage((Image)verLine, col, 0, null);
            }
            if (stripeImage != null) {
                int stripeSize = stripeImage.getHeight();
                int stripeCount = width / stripeSize;
                stripeOffset %= 2 * stripeSize;
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = stripe * stripeSize + stripeOffset;
                    graphics.drawImage((Image)stripeImage, stripePos, 0, null);
                }
            }
        } else {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.2 * (double)width), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)width), colorScheme.getMidColor());
            gradColors.put((int)(0.8 * (double)width), colorScheme.getLightColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(width, colorScheme.getDarkColor(), colorScheme.getDarkColor(), gradColors);
            for (int row = 0; row < height; ++row) {
                graphics.drawImage((Image)horLine, 0, row, null);
            }
            if (stripeImage != null) {
                int stripeSize = stripeImage.getWidth();
                int stripeCount = height / stripeSize;
                stripeOffset %= 2 * stripeSize;
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = stripe * stripeSize + stripeOffset;
                    graphics.drawImage((Image)stripeImage, 0, stripePos, null);
                }
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getStripe(int baseSize, Color color) {
        int width = (int)(1.8 * (double)baseSize);
        int height = baseSize;
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(width - 1 - baseSize, 0);
        polygon.addPoint(width - 1, height - 1);
        polygon.addPoint(baseSize, height - 1);
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
        float[] BLUR = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.3f, 0.1f, 0.1f, 0.1f, 0.1f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDragImage(int width, int height) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        int bumpCellSize = 4;
        int bumpRows = height / bumpCellSize;
        int bumpColumns = (width - 2) / bumpCellSize;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : 2;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(colorScheme.getLightColor());
                graphics.fillOval(cx + 1, cy + 1, 2, 2);
                graphics.setColor(colorScheme.getDarkColor());
                graphics.fillOval(cx, cy, 2, 2);
            }
        }
        return result;
    }

    public static BufferedImage getTreeIcon(ColorScheme colorScheme, boolean isDark, boolean isCollapsed) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(10, 10);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Polygon pol = new Polygon();
        pol.addPoint(2, 1);
        pol.addPoint(8, 1);
        pol.addPoint(9, 2);
        pol.addPoint(9, 8);
        pol.addPoint(8, 9);
        pol.addPoint(2, 9);
        pol.addPoint(1, 8);
        pol.addPoint(1, 2);
        Color tlFillColor = isDark ? colorScheme.getMidColor().brighter() : Color.white;
        Color brFillColor = isDark ? colorScheme.getDarkColor().brighter() : colorScheme.getLightColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, tlFillColor, 9.0f, 9.0f, brFillColor));
        graphics.fillPolygon(pol);
        Color borderColor = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        Color signColor = isDark ? colorScheme.getUltraLightColor().brighter().brighter() : colorScheme.getUltraDarkColor();
        graphics.setColor(borderColor);
        graphics.drawPolygon(pol);
        graphics.setColor(signColor);
        graphics.drawLine(3, 5, 7, 5);
        if (isCollapsed) {
            graphics.drawLine(5, 3, 5, 7);
        }
        return result;
    }

    public static BufferedImage getTreeNodeIcon(boolean isDark, SubstanceConstants.TreeIcon treeIconKind) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        Polygon backFolder = new Polygon();
        backFolder.addPoint(2, 3);
        backFolder.addPoint(7, 3);
        backFolder.addPoint(8, 4);
        backFolder.addPoint(14, 4);
        backFolder.addPoint(15, 5);
        backFolder.addPoint(15, 13);
        backFolder.addPoint(14, 14);
        backFolder.addPoint(2, 14);
        backFolder.addPoint(1, 13);
        backFolder.addPoint(1, 4);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(backFolder);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = isDark ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(backFolder);
        switch (treeIconKind) {
            case CLOSED: {
                Polygon closedFolder = new Polygon();
                closedFolder.addPoint(1, 8);
                closedFolder.addPoint(9, 8);
                closedFolder.addPoint(10, 7);
                closedFolder.addPoint(15, 7);
                closedFolder.addPoint(15, 13);
                closedFolder.addPoint(14, 14);
                closedFolder.addPoint(2, 14);
                closedFolder.addPoint(1, 13);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(closedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(closedFolder);
                break;
            }
            case OPENED: {
                Polygon openedFolder = new Polygon();
                openedFolder.addPoint(2, 13);
                openedFolder.addPoint(5, 7);
                openedFolder.addPoint(11, 7);
                openedFolder.addPoint(12, 8);
                openedFolder.addPoint(17, 8);
                openedFolder.addPoint(14, 14);
                openedFolder.addPoint(2, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(openedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(openedFolder);
                break;
            }
            case UP: {
                Polygon arrow = new Polygon();
                arrow.addPoint(6, 14);
                arrow.addPoint(6, 10);
                arrow.addPoint(5, 10);
                arrow.addPoint(8, 7);
                arrow.addPoint(11, 10);
                arrow.addPoint(10, 10);
                arrow.addPoint(10, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(arrow);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(arrow);
                break;
            }
            case NONE: {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setStroke(new BasicStroke(1.2f));
                graphics.drawLine(5, 9, 11, 9);
                graphics.drawLine(8, 6, 8, 12);
                graphics.drawLine(6, 7, 10, 11);
                graphics.drawLine(6, 11, 10, 7);
            }
        }
        return result;
    }

    public static BufferedImage getTreeLeafIcon(boolean isDark) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(16, 20);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        Polygon polygon = new Polygon();
        polygon.addPoint(13, 8);
        polygon.addPoint(13, 16);
        polygon.addPoint(12, 17);
        polygon.addPoint(3, 17);
        polygon.addPoint(2, 16);
        polygon.addPoint(2, 3);
        polygon.addPoint(3, 2);
        polygon.addPoint(9, 2);
        polygon.addPoint(13, 8);
        polygon.addPoint(6, 5);
        polygon.addPoint(9, 2);
        graphics.setClip(2, 2, 12, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(polygon);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = isDark ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(polygon);
        return result;
    }

    public static BufferedImage getHomeIcon(boolean isDark) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        Polygon outline = new Polygon();
        outline.addPoint(4, 16);
        outline.addPoint(4, 8);
        outline.addPoint(9, 2);
        outline.addPoint(12, 6);
        outline.addPoint(12, 2);
        outline.addPoint(14, 2);
        outline.addPoint(14, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(outline);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = isDark ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(outline);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawLine(3, 9, 9, 2);
        graphics.drawLine(9, 2, 15, 9);
        graphics.setStroke(new BasicStroke(1.2f));
        graphics.drawLine(7, 16, 7, 10);
        graphics.drawLine(7, 10, 11, 10);
        graphics.drawLine(11, 16, 11, 10);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.drawRect(8, 6, 2, 2);
        return result;
    }

    public static BufferedImage getComputerIcon() {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRect(1, 4, 4, 11);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRect(1, 4, 4, 11);
        graphics.drawLine(2, 6, 4, 6);
        graphics.drawLine(2, 8, 4, 8);
        graphics.drawLine(3, 12, 3, 12);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRoundRect(8, 4, 9, 8, 2, 2);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRoundRect(7, 4, 9, 8, 2, 2);
        graphics.drawRoundRect(9, 6, 5, 4, 2, 2);
        graphics.fillRect(11, 12, 2, 3);
        graphics.drawLine(9, 15, 14, 15);
        float[] BLUR = new float[]{0.03f, 0.03f, 0.03f, 0.03f, 0.86f, 0.03f, 0.03f, 0.03f, 0.03f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDiskIcon(boolean isDark) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor1 = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillRect(3, 4, 10, 10);
        graphics.fillArc(3, 2, 10, 4, 0, 180);
        graphics.fillArc(3, 12, 10, 4, 180, 180);
        Color gradColor3 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = isDark ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawOval(3, 2, 10, 4);
        graphics.drawArc(3, 12, 10, 4, 180, 180);
        graphics.drawArc(3, 9, 10, 4, 180, 180);
        graphics.drawArc(3, 6, 10, 4, 180, 180);
        graphics.drawLine(3, 4, 3, 14);
        graphics.drawLine(13, 4, 13, 14);
        return result;
    }

    public static BufferedImage getFloppyIcon(boolean isDark) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon outline = new Polygon();
        outline.addPoint(3, 3);
        outline.addPoint(13, 3);
        outline.addPoint(14, 4);
        outline.addPoint(14, 15);
        outline.addPoint(2, 15);
        outline.addPoint(2, 4);
        Color gradColor1 = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(outline);
        Color gradColor3 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = isDark ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(outline);
        graphics.drawRect(5, 3, 6, 3);
        graphics.fillRect(9, 3, 3, 3);
        graphics.drawRect(4, 9, 8, 6);
        graphics.drawLine(6, 11, 10, 11);
        graphics.drawLine(6, 13, 10, 13);
        return result;
    }

    public static void paintProgressBar(Graphics g, int startX, int startY, int width, int height, ColorScheme colorScheme, boolean isVertical) {
        SubstanceImageCreator.paintRectangularBackground(g, startX, startY, width, height, colorScheme, true, isVertical);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        Color ud = colorScheme.getMidColor();
        int rUd = ud.getRed();
        int gUd = ud.getGreen();
        int bUd = ud.getBlue();
        int tUd = 255;
        if (!isVertical) {
            int topY = (int)Math.floor(0.45 * (double)height);
            int endY = (int)Math.ceil(0.67 * (double)height);
            int xs = (int)(0.1 * (double)(width - 2));
            int xe = (int)(0.9 * (double)(width - 2));
            int fx = (width - 2) / 2 - xs + 1;
            int dfx = fx / 4;
            for (int y = topY; y < endY; ++y) {
                HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
                gradColors.put(xs, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                gradColors.put(xe, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                int dx = dfx + (y - startY) * (fx - dfx) / (endY - startY);
                gradColors.put(xs + dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                gradColors.put(xe - dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                SubstanceImageCreator.paintOneLineGradient(graphics, 0, y, width, isVertical, new Color(rUd, gUd, bUd, tUd), new Color(rUd, gUd, bUd, tUd), gradColors);
            }
        } else {
            int leftX = (int)Math.floor(0.45 * (double)width);
            int rightX = (int)Math.ceil(0.67 * (double)width);
            int ys = (int)(0.1 * (double)(height - 2));
            int ye = (int)(0.9 * (double)(height - 2));
            int fy = (height - 2) / 2 - ys + 1;
            int dfy = fy / 4;
            for (int x = leftX; x < rightX; ++x) {
                HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
                gradColors.put(ys, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                gradColors.put(ye, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                int dy = dfy + (x - startX) * (fy - dfy) / (rightX - startX);
                gradColors.put(ys + dy, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                gradColors.put(ye - dy, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                SubstanceImageCreator.paintOneLineGradient(graphics, x, 0, height - 1, isVertical, new Color(rUd, gUd, bUd, tUd), new Color(rUd, gUd, bUd, tUd), gradColors);
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getSingleCrayon(Color mainColor, int width, int height) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        int baseTop = (int)(0.2 * (double)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = mainColor.getRed();
        int g = mainColor.getGreen();
        int b = mainColor.getBlue();
        double lc = 0.8;
        int lr = (int)((double)r + (double)(255 - r) * lc);
        int lg = (int)((double)g + (double)(255 - g) * lc);
        int lb = (int)((double)b + (double)(255 - b) * lc);
        double dc = 0.05;
        int dr = (int)((1.0 - dc) * (double)r);
        int dg = (int)((1.0 - dc) * (double)g);
        int db = (int)((1.0 - dc) * (double)b);
        Color lightColor = new Color(lr, lg, lb);
        Color darkColor = new Color(dr, dg, db);
        HashMap<Integer, Color> fillColorsColor = new HashMap<Integer, Color>();
        fillColorsColor.put((int)(0.3 * (double)width), darkColor);
        fillColorsColor.put((int)(0.5 * (double)width), darkColor);
        fillColorsColor.put((int)(0.9 * (double)width), lightColor);
        BufferedImage fillLineColor = SubstanceImageCreator.getOneLineGradient(width, lightColor, lightColor, fillColorsColor);
        for (int y = baseTop; y < height; ++y) {
            graphics.drawImage((Image)fillLineColor, 0, y, null);
        }
        int dbwr = lr;
        int dbwg = lg;
        int dbwb = lb;
        int lbwr = 128 + dr / 4;
        int lbwg = 128 + dg / 4;
        int lbwb = 128 + db / 4;
        HashMap<Integer, Color> fillColorsBW = new HashMap<Integer, Color>();
        fillColorsBW.put((int)(0.3 * (double)width), new Color(dbwr, dbwg, dbwb));
        fillColorsBW.put((int)(0.5 * (double)width), new Color(dbwr, dbwg, dbwb));
        fillColorsBW.put((int)(0.9 * (double)width), new Color(lbwr, lbwg, lbwb));
        BufferedImage fillLineBW = SubstanceImageCreator.getOneLineGradient(width, new Color(lbwr, lbwg, lbwb), new Color(lbwr, lbwg, lbwb), fillColorsBW);
        int stripeTop = (int)(0.35 * (double)height);
        int stripeHeight = (int)(0.04 * (double)height);
        for (int y = stripeTop; y < stripeTop + stripeHeight; ++y) {
            graphics.drawImage((Image)fillLineBW, 0, y, null);
        }
        graphics.setColor(new Color(lbwr, lbwg, lbwb));
        graphics.drawRect(0, stripeTop, width - 1, stripeHeight);
        GeneralPath capPath = new GeneralPath();
        capPath.moveTo(0.5f * (float)width - 3.0f, 4.0f);
        capPath.quadTo(0.5f * (float)width, 0.0f, 0.5f * (float)width + 3.0f, 4.0f);
        capPath.lineTo(width - 3, baseTop);
        capPath.lineTo(2.0f, baseTop);
        capPath.lineTo(0.5f * (float)width - 3.0f, 4.0f);
        graphics.setClip(capPath);
        graphics.setPaint(new GradientPaint(0.0f, baseTop / 2, lightColor, (int)(0.6 * (double)width), baseTop, mainColor));
        graphics.fillRect(0, 0, width / 2, baseTop);
        graphics.setPaint(new GradientPaint(width, baseTop / 2, lightColor, (int)(0.4 * (double)width), baseTop, mainColor));
        graphics.fillRect(width / 2, 0, width / 2, baseTop);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.setClip(null);
        graphics.setColor(new Color(64 + dr / 2, 64 + dg / 2, 64 + db / 2, 200));
        graphics.drawRect(0, baseTop, width - 1, height - baseTop - 1);
        graphics.draw(capPath);
        graphics.dispose();
        return image;
    }

    private static int crayonX(int i) {
        return i % 8 * 22 + 4 + i / 8 % 2 * 11;
    }

    private static int crayonY(int i) {
        return i / 8 * 20 + 23;
    }

    public static Image getCrayonsImage() {
        int iw = 195;
        int ih = 208;
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iw, ih);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, iw, ih);
        for (int i = 0; i < crayonColors.length; ++i) {
            Color crayonColor = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage crayonImage = SubstanceImageCreator.getSingleCrayon(crayonColor, 22, 120);
            graphics.drawImage((Image)crayonImage, SubstanceImageCreator.crayonX(i), SubstanceImageCreator.crayonY(i), null);
        }
        graphics.setColor(new Color(190, 190, 190));
        graphics.drawRoundRect(0, 1, iw - 1, ih - 2, 4, 4);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getErrorMarker(int dimension, ColorScheme colorScheme) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorScheme.getMidColor());
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        float ds = 0.28f * (float)(dimension - 1);
        float de = 0.72f * (float)(dimension - 1);
        GeneralPath gp1 = new GeneralPath();
        gp1.moveTo(ds, ds);
        gp1.lineTo(de, de);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(de, ds);
        gp2.lineTo(ds, de);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorScheme.getUltraLightColor().brighter());
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.dispose();
        return image;
    }

    public static Icon getErrorMarkerIcon(int dimension, ColorScheme colorScheme) {
        return new ImageIcon(SubstanceImageCreator.getErrorMarker(dimension, colorScheme));
    }

    public static BufferedImage getWarningMarker(int dimension, ColorScheme colorScheme) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(colorScheme.getMidColor());
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.6f * height);
        markerPath.moveTo(0.5f * d, 0.85f * height);
        markerPath.lineTo(0.5f * d, 0.85f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorScheme.getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getInfoMarker(int dimension, ColorScheme colorScheme) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(colorScheme.getMidColor());
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.3f * height);
        markerPath.moveTo(0.5f * d, 0.55f * height);
        markerPath.lineTo(0.5f * d, 0.8f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorScheme.getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static Icon getInfoMarkerIcon(int dimension, ColorScheme colorScheme) {
        return new ImageIcon(SubstanceImageCreator.getInfoMarker(dimension, colorScheme));
    }

    public static Icon getWarningMarkerIcon(int dimension, ColorScheme colorScheme) {
        return new ImageIcon(SubstanceImageCreator.getWarningMarker(dimension, colorScheme));
    }

    public static BufferedImage getQuestionMarker(int dimension, ColorScheme colorScheme) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorScheme.getMidColor());
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float d = dimension - 1;
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.3f * d, 0.32f * d);
        markerPath.quadTo(0.3f * d, 0.18f * d, 0.5f * d, 0.18f * d);
        markerPath.quadTo(0.7f * d, 0.18f * d, 0.7f * d, 0.32f * d);
        markerPath.quadTo(0.7f * d, 0.45f * d, 0.6f * d, 0.45f * d);
        markerPath.quadTo(0.5f * d, 0.45f * d, 0.5f * d, 0.6f * d);
        markerPath.moveTo(0.5f * d, 0.85f * d);
        markerPath.lineTo(0.5f * d, 0.85f * d);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorScheme.getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static Icon getQuestionMarkerIcon(int dimension, ColorScheme colorScheme) {
        return new ImageIcon(SubstanceImageCreator.getQuestionMarker(dimension, colorScheme));
    }

    public static Icon getHexaMarker(int value, SubstanceTheme theme) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(9, 9);
        value %= 16;
        Color offColor = null;
        Color onColor = null;
        if (theme == null) {
            return new ImageIcon(result);
        }
        ColorScheme colorScheme = theme.getColorScheme();
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme);
        offColor = isDark ? colorScheme.getMidColor() : colorScheme.getMidColor().darker();
        onColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.2) : colorScheme.getUltraDarkColor().darker();
        boolean bit1 = (value & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Image getBigHexaMarker(int value, SubstanceTheme theme) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(16, 16);
        value %= 16;
        Color offColor = null;
        Color onColor = null;
        if (theme == null) {
            return result;
        }
        ColorScheme colorScheme = theme.getColorScheme();
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme);
        offColor = isDark ? colorScheme.getMidColor() : colorScheme.getMidColor().darker();
        onColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.2) : colorScheme.getUltraDarkColor().darker();
        boolean bit1 = (value & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(9, 9, 6, 6);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(9, 2, 6, 6);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(2, 9, 6, 6);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(2, 2, 6, 6);
        graphics.dispose();
        return result;
    }

    public static Icon getSearchIcon(int dimension, ColorScheme colorScheme, boolean leftToRight) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = colorScheme.getForegroundColor();
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(1.5f));
        if (leftToRight) {
            int xc = (int)(0.6 * (double)dimension);
            int yc = (int)(0.45 * (double)dimension);
            int r = (int)(0.3 * (double)dimension);
            graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
            graphics.setStroke(new BasicStroke(3.0f));
            GeneralPath handle = new GeneralPath();
            handle.moveTo((float)((double)xc - (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
            handle.lineTo(1.8f, (float)dimension - 2.2f);
            graphics.draw(handle);
        } else {
            int xc = (int)(0.4 * (double)dimension);
            int yc = (int)(0.45 * (double)dimension);
            int r = (int)(0.3 * (double)dimension);
            graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
            graphics.setStroke(new BasicStroke(3.0f));
            GeneralPath handle = new GeneralPath();
            handle.moveTo((float)((double)xc + (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
            handle.lineTo((float)dimension - 2.5f, (float)dimension - 2.2f);
            graphics.draw(handle);
        }
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Icon getThemeIcon(SubstanceTheme theme) {
        boolean isMixed;
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = isMixed = theme != null && theme.getKind() == SubstanceTheme.ThemeKind.MIXED;
        if (!isMixed) {
            Color color1 = theme == null ? Color.red : theme.getColorScheme().getUltraDarkColor();
            Color color2 = theme == null ? Color.green : theme.getColorScheme().getMidColor();
            Color color3 = theme == null ? Color.blue : theme.getColorScheme().getExtraLightColor();
            graphics.setColor(color1);
            graphics.fillOval(5, 2, 6, 6);
            graphics.setColor(color1.darker());
            graphics.drawOval(5, 2, 6, 6);
            graphics.setColor(color2);
            graphics.fillOval(1, 9, 6, 6);
            graphics.setColor(color2.darker());
            graphics.drawOval(1, 9, 6, 6);
            graphics.setColor(color3);
            graphics.fillOval(9, 9, 6, 6);
            graphics.setColor(color3.darker());
            graphics.drawOval(9, 9, 6, 6);
        } else {
            SubstanceTheme theme1 = ((SubstanceMixBiTheme)theme).getOriginalFirstTheme();
            SubstanceTheme theme2 = ((SubstanceMixBiTheme)theme).getOriginalSecondTheme();
            Color color1_1 = theme1.getColorScheme().getUltraDarkColor();
            Color color2_1 = theme1.getColorScheme().getMidColor();
            Color color3_1 = theme1.getColorScheme().getExtraLightColor();
            Color color1_2 = theme2.getColorScheme().getUltraDarkColor();
            Color color2_2 = theme2.getColorScheme().getMidColor();
            Color color3_2 = theme2.getColorScheme().getExtraLightColor();
            graphics.setClip(5, 2, 3, 7);
            graphics.setColor(color1_1);
            graphics.fillOval(5, 2, 6, 7);
            graphics.setColor(color1_1.darker());
            graphics.drawOval(5, 2, 6, 6);
            graphics.setClip(8, 2, 4, 7);
            graphics.setColor(color1_2);
            graphics.fillOval(5, 2, 6, 6);
            graphics.setColor(color1_2.darker());
            graphics.drawOval(5, 2, 6, 6);
            graphics.setClip(1, 9, 3, 7);
            graphics.setColor(color2_1);
            graphics.fillOval(1, 9, 6, 6);
            graphics.setColor(color2_1.darker());
            graphics.drawOval(1, 9, 6, 6);
            graphics.setClip(4, 9, 4, 7);
            graphics.setColor(color2_2);
            graphics.fillOval(1, 9, 6, 6);
            graphics.setColor(color2_2.darker());
            graphics.drawOval(1, 9, 6, 6);
            graphics.setClip(9, 9, 3, 7);
            graphics.setColor(color3_1);
            graphics.fillOval(9, 9, 6, 6);
            graphics.setColor(color3_1.darker());
            graphics.drawOval(9, 9, 6, 6);
            graphics.setClip(12, 9, 4, 7);
            graphics.setColor(color3_2);
            graphics.fillOval(9, 9, 6, 6);
            graphics.setColor(color3_2.darker());
            graphics.drawOval(9, 9, 6, 6);
        }
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Icon getWatermarkIcon(SubstanceWatermark watermark) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        watermark.previewWatermark(graphics, 0, 0, 16, 16);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Icon getSmallLockIcon(ColorScheme scheme) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(6, 8);
        Color fore = scheme.getForegroundColor();
        Color fill = new Color(208, 208, 48);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(fill);
        graphics.fillRect(1, 3, 4, 4);
        graphics.setColor(fore);
        graphics.drawLine(0, 3, 0, 7);
        graphics.drawLine(5, 3, 5, 7);
        graphics.drawLine(0, 7, 5, 7);
        graphics.drawLine(1, 2, 4, 2);
        graphics.drawLine(1, 1, 1, 2);
        graphics.drawLine(4, 1, 4, 2);
        graphics.drawLine(2, 0, 3, 0);
        graphics.drawLine(2, 4, 3, 4);
        graphics.drawLine(2, 5, 3, 5);
        graphics.dispose();
        return new ImageIcon(result);
    }
}

