/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODDesktopIconUI;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class NimRODInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static final long serialVersionUID = 3569530640592496710L;
    private MiML miml;
    private Icon resizeIcon;
    private Icon antIcon;
    private int litWidth = UIManager.getInt("NimRODInternalFrameIconLit.width");
    private int litHeight = UIManager.getInt("NimRODInternalFrameIconLit.height");

    public NimRODInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
        this.closeButton.setOpaque(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setFocusPainted(false);
        this.maxButton.setOpaque(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setFocusPainted(false);
        this.iconButton.setOpaque(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setFocusPainted(false);
        HackML hackML = new HackML();
        this.closeButton.addMouseListener(hackML);
        this.maxButton.addMouseListener(hackML);
        this.iconButton.addMouseListener(hackML);
    }

    public void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.addMouseListener(this.miml);
        this.addMouseMotionListener(this.miml);
        this.frame.addMouseListener(this.miml);
        this.frame.addMouseMotionListener(this.miml);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeMouseListener(this.miml);
        this.removeMouseMotionListener(this.miml);
        this.frame.removeMouseListener(this.miml);
        this.frame.removeMouseMotionListener(this.miml);
        this.miml = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new NimRODPropertyChangeHandler();
    }

    public void paintComponent(Graphics graphics) {
        String string;
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.getInstance(3, NimRODUtils.getFrameOpacityFloat()));
        GradientPaint gradientPaint = this.frame.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getPrimaryControlDarkShadow(), n2, 0.0f, NimRODLookAndFeel.getPrimaryControl()) : new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getControl(), n2, 0.0f, NimRODLookAndFeel.getControlDarkShadow());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 1, n2, n3);
        graphics2D.dispose();
        int n4 = n = this.frame.getComponentOrientation().isLeftToRight() ? 5 : n2 - 5;
        if (this.frame.getFrameIcon() != this.antIcon) {
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, this.litWidth, this.litHeight);
        }
        if (this.resizeIcon != null) {
            int n5 = n3 / 2 - this.resizeIcon.getIconHeight() / 2;
            this.resizeIcon.paintIcon(this.frame, graphics, n, n5);
            n += 5 + this.resizeIcon.getIconWidth();
        }
        if ((string = this.frame.getTitle()) != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n6 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            int n7 = n2;
            if (this.frame.isIconifiable()) {
                n7 = this.iconButton.getBounds().x;
            } else if (this.frame.isMaximizable()) {
                n7 -= this.maxButton.getBounds().x;
            } else if (this.frame.isClosable()) {
                n7 -= this.closeButton.getBounds().x;
            }
            n7 = n7 - n - this.getInsets().left;
            string = this.getTitle(string, fontMetrics, n7);
            if (this.frame.isSelected()) {
                NimRODUtils.paintShadowTitleFat(graphics, string, n, n6, Color.white);
            } else {
                NimRODUtils.paintShadowTitleFat(graphics, string, n, n6, NimRODLookAndFeel.getControl());
            }
        }
    }

    class NimRODPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        NimRODPropertyChangeHandler() {
            super(NimRODInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                NimRODInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", bl);
                NimRODInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", bl);
                NimRODInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", bl);
            } else if ("JInternalFrame.messageType".equals(string)) {
                NimRODInternalFrameTitlePane.this.frame.repaint();
            } else if ("icon".equals(string)) {
                NimRODInternalFrameTitlePane.this.iconButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.closeButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.maxButton.getModel().setRollover(false);
                ((NimRODDesktopIconUI)((NimRODInternalFrameTitlePane)NimRODInternalFrameTitlePane.this).frame.getDesktopIcon().getUI()).hasFocus = false;
            } else if ("frameIcon".equals(string) && NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
        }
    }

    private class MiML
    extends MouseInputAdapter {
        Insets ins;

        private MiML() {
            this.ins = NimRODInternalFrameTitlePane.this.frame.getBorder().getBorderInsets(NimRODInternalFrameTitlePane.this.frame);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        void dodo(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() instanceof NimRODInternalFrameTitlePane) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            } else {
                int n = mouseEvent.getX();
                int n2 = NimRODInternalFrameTitlePane.this.frame.getWidth();
                int n3 = mouseEvent.getY();
                int n4 = NimRODInternalFrameTitlePane.this.frame.getHeight();
                if (n <= 5 || n >= n2 - this.ins.right || n3 >= n4 - this.ins.bottom) {
                    NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
                }
            }
        }
    }
}

