/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;

public class ClasspathHelper {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDevEntriesProperties(String fileName, boolean checkExcluded) {
        Object var8_10;
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase[] models = manager.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            String entry;
            String id = models[i].getPluginBase().getId();
            if (id != null && (entry = ClasspathHelper.writeEntry(ClasspathHelper.getOutputFolders(models[i], checkExcluded))).length() > 0) {
                properties.put(id, entry);
            }
            ++i;
        }
        properties.put("@ignoredot@", "true");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            properties.store(stream, "");
            stream.flush();
            String string = new URL("file:" + fileName).toString();
            var8_10 = null;
            try {
                if (stream == null) return string;
                stream.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException e) {
                PDECore.logException(e);
            }
            var8_10 = null;
        }
        catch (Throwable throwable) {
            var8_10 = null;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return ClasspathHelper.getDevEntries(checkExcluded);
        }
        if (stream == null) return ClasspathHelper.getDevEntries(checkExcluded);
        stream.close();
        return ClasspathHelper.getDevEntries(checkExcluded);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDevEntriesProperties(String fileName, Map map) {
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            String entry;
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (model.getUnderlyingResource() == null || (entry = ClasspathHelper.writeEntry(ClasspathHelper.getOutputFolders(model, true))).length() <= 0) continue;
            properties.put(model.getPluginBase().getId(), entry);
        }
        properties.put("@ignoredot@", "true");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            properties.store(stream, "");
            stream.flush();
            String string = new URL("file:" + fileName).toString();
            Object var7_9 = null;
            try {
                if (stream == null) return string;
                stream.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException e) {
                PDECore.logException(e);
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return ClasspathHelper.getDevEntries(true);
        }
        if (stream == null) return ClasspathHelper.getDevEntries(true);
        stream.close();
        return ClasspathHelper.getDevEntries(true);
    }

    public static String getDevEntries(boolean checkExcluded) {
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getWorkspaceModels();
        ArrayList<IPath> list = new ArrayList<IPath>();
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id != null && id.trim().length() != 0) {
                IPath[] paths = ClasspathHelper.getOutputFolders(models[i], checkExcluded);
                int j = 0;
                while (j < paths.length) {
                    list.add(paths[j]);
                    ++j;
                }
            }
            ++i;
        }
        String entry = ClasspathHelper.writeEntry(list.toArray(new IPath[list.size()]));
        return entry.length() > 0 ? entry : "bin";
    }

    private static String writeEntry(IPath[] paths) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            buffer.append(paths[i].toString());
            if (i < paths.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static Dictionary getDevDictionary(IPluginModelBase model) {
        if (model.getUnderlyingResource() == null) {
            return null;
        }
        String id = model.getPluginBase().getId();
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        IPath[] paths = ClasspathHelper.getOutputFolders(model, false);
        String entry = ClasspathHelper.writeEntry(paths);
        Hashtable<String, String> map = new Hashtable<String, String>(2);
        map.put("@ignoredot@", "true");
        map.put(id, entry.length() > 0 ? entry : "bin");
        return map;
    }

    private static IPath[] getOutputFolders(IPluginModelBase model, boolean checkExcluded) {
        ArrayList result = new ArrayList();
        IProject project = model.getUnderlyingResource().getProject();
        HashSet<String> set = new HashSet<String>();
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            set.add(libraries[i].getName());
            ++i;
        }
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                List excluded = ClasspathHelper.getFoldersToExclude(project, checkExcluded);
                IPath path = jProject.getOutputLocation();
                if (path != null && !excluded.contains(path)) {
                    ClasspathHelper.addPath(result, project, path);
                }
                IClasspathEntry[] entries = jProject.getRawClasspath();
                int i2 = 0;
                while (i2 < entries.length) {
                    path = null;
                    if (entries[i2].getEntryKind() == 3) {
                        path = entries[i2].getOutputLocation();
                    } else if (entries[i2].getEntryKind() == 1) {
                        IPath candidate = entries[i2].getPath().removeFirstSegments(1);
                        if (candidate.segmentCount() == 0) {
                            if (set.isEmpty() || set.contains(".")) {
                                path = entries[i2].getPath();
                            }
                        } else if (set.contains(candidate.toString())) {
                            path = entries[i2].getPath();
                        }
                    }
                    if (path != null && !excluded.contains(path)) {
                        ClasspathHelper.addPath(result, project, path);
                    }
                    ++i2;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return result.toArray(new IPath[result.size()]);
    }

    private static void addPath(ArrayList result, IProject project, IPath path) {
        if (path.segmentCount() > 0 && path.segment(0).equals(project.getName())) {
            if ((path = path.removeFirstSegments(1)).segmentCount() == 0) {
                path = new Path(".");
            } else {
                IResource resource = project.findMember(path);
                if (resource != null) {
                    if (resource.isLinked()) {
                        path = resource.getLocation();
                    }
                } else {
                    path = null;
                }
            }
        }
        if (path != null && !result.contains(path)) {
            result.add(path);
        }
    }

    private static List getFoldersToExclude(IProject project, boolean checkExcluded) {
        IEclipsePreferences pref;
        ArrayList<Path> list = new ArrayList<Path>();
        if (checkExcluded && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            String binExcludes = pref.get("selfhosting.binExcludes", "");
            StringTokenizer tokenizer = new StringTokenizer(binExcludes, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(new Path(tokenizer.nextToken().trim()));
            }
        }
        return list;
    }
}

