/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.DiffOperation;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IWorkbenchPart;

public class FileDiffOperation
extends DiffOperation {
    FileOutputStream os;
    PrintStream printStream;
    File file;
    File tempFile;

    public FileDiffOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, File file, boolean isMultiPatch, boolean includeFullPathInformation, IPath patchRoot) {
        super(part, mappings, options, isMultiPatch, includeFullPathInformation, patchRoot);
        IPath teamLocation = TeamPlugin.getPlugin().getStateLocation();
        IPath tempFilePath = teamLocation.append((IPath)new Path("/tempDiff" + System.currentTimeMillis()));
        this.tempFile = tempFilePath.toFile();
        this.file = file;
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        super.execute(monitor);
        if (this.tempFile.length() == 0L) {
            this.tempFile.delete();
            this.reportEmptyDiff();
            return;
        }
        if (this.isMultiPatch && !this.patchHasContents && !this.patchHasNewFiles) {
            this.tempFile.delete();
            this.reportEmptyDiff();
            return;
        }
        this.copyFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyFile() throws CVSException {
        AbstractInterruptibleChannel fileChannel;
        block17: {
            FileChannel tempFileChannel = null;
            fileChannel = null;
            try {
                try {
                    tempFileChannel = new FileInputStream(this.tempFile).getChannel();
                    fileChannel = new FileOutputStream(this.file).getChannel();
                    long size = tempFileChannel.size();
                    long bytesTransferred = ((FileChannel)fileChannel).transferFrom(tempFileChannel, 0L, size);
                    while (bytesTransferred != size) {
                        bytesTransferred += ((FileChannel)fileChannel).transferFrom(tempFileChannel, bytesTransferred, size);
                    }
                }
                catch (IOException e) {
                    throw CVSException.wrapException((Exception)e);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (tempFileChannel != null) {
                    try {
                        tempFileChannel.close();
                    }
                    catch (IOException e) {
                        throw CVSException.wrapException((Exception)e);
                    }
                }
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException e) {
                        throw CVSException.wrapException((Exception)e);
                    }
                }
                if (this.tempFile == null) throw throwable;
                this.tempFile.delete();
                throw throwable;
            }
            {
                Object var7_8 = null;
                if (tempFileChannel == null) break block17;
            }
            try {}
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
            tempFileChannel.close();
        }
        if (fileChannel != null) {
            try {}
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
            fileChannel.close();
        }
        if (this.tempFile == null) return;
        this.tempFile.delete();
    }

    protected PrintStream openStream() throws CVSException {
        try {
            this.os = new FileOutputStream(this.tempFile);
            return new PrintStream(this.os);
        }
        catch (FileNotFoundException e) {
            throw new CVSException(CVSUIMessages.GenerateDiffFileOperation_0, (Throwable)e);
        }
    }
}

