/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.util.ViewerPane;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    protected static final String PREVIOUS_CHANGE_ID = "org.eclipse.ltk.ui.refactoring.previousChange";
    protected static final String NEXT_CHANGE_ID = "org.eclipse.ltk.ui.refactoring.nextChange";
    protected Change fChange;
    private List fActiveGroupCategories;
    protected CompositeChange fTreeViewerInputChange;
    private PreviewNode fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    protected Action fFilterDropDownAction;
    protected Action fNextAction;
    protected Action fPreviousAction;
    protected ViewerPane fTreeViewerPane;
    protected CheckboxTreeViewer fTreeViewer;
    private PageBook fPreviewContainer;
    private ChangePreviewViewerDescriptor fCurrentDescriptor;
    private IChangePreviewViewer fCurrentPreviewViewer;
    private IChangePreviewViewer fNullPreviewer;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringUIMessages.PreviewWizardPage_description);
    }

    public PreviewWizardPage(boolean wizard) {
        super("PreviewPage", wizard);
        this.setDescription(RefactoringUIMessages.PreviewWizardPage_description);
    }

    public void setChange(Change change) {
        if (this.fChange == change) {
            return;
        }
        this.fChange = change;
        if (this.fChange instanceof CompositeChange) {
            this.fTreeViewerInputChange = (CompositeChange)this.fChange;
        } else {
            this.fTreeViewerInputChange = new CompositeChange("Dummy Change");
            this.fTreeViewerInputChange.add(this.fChange);
        }
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite parent) {
        return new ChangeElementTreeViewer(parent);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider();
    }

    protected boolean performFinish() {
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), this.fChange, this.getContainer());
        FinishResult result = this.getRefactoringWizard().internalPerformFinish(InternalAPI.INSTANCE, operation);
        if (result.isException()) {
            return true;
        }
        if (result.isInterrupted()) {
            return false;
        }
        RefactoringStatus fValidationStatus = operation.getValidationStatus();
        if (fValidationStatus != null && fValidationStatus.hasFatalError()) {
            RefactoringWizard wizard = this.getRefactoringWizard();
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)Messages.format(RefactoringUIMessages.RefactoringUI_cannot_execute, fValidationStatus.getMessageMatchingSeverity(4)));
            return true;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fPageContainer = new PageBook(parent, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(result, 512);
        this.fTreeViewerPane = new ViewerPane((Composite)sashForm, 0x800800);
        this.fTreeViewerPane.setText(RefactoringUIMessages.PreviewWizardPage_changes);
        ToolBarManager tbm = this.fTreeViewerPane.getToolBarManager();
        this.fNextAction = new NextChange();
        tbm.add((IAction)this.fNextAction);
        this.fPreviousAction = new PreviousChange();
        tbm.add((IAction)this.fPreviousAction);
        tbm.add((IContributionItem)new Separator());
        this.fFilterDropDownAction = new FilterDropDownAction();
        this.fFilterDropDownAction.setEnabled(false);
        tbm.add((IAction)this.fFilterDropDownAction);
        tbm.update(true);
        this.fTreeViewer = this.createTreeViewer((Composite)this.fTreeViewerPane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        this.fTreeViewerPane.setContent(this.fTreeViewer.getControl());
        this.setTreeViewerInput();
        this.fPreviewContainer = new PageBook((Composite)sashForm, 0);
        this.fNullPreviewer = new NullPreviewer();
        this.fNullPreviewer.createControl((Composite)this.fPreviewContainer);
        this.fPreviewContainer.showPage(this.fNullPreviewer.getControl());
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fCurrentDescriptor = null;
        sashForm.setWeights(new int[]{33, 67});
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createNullPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0x1000000);
        label.setText(RefactoringUIMessages.PreviewWizardPage_no_source_code_change);
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void setVisible(boolean visible) {
        this.fCurrentSelection = null;
        RefactoringWizard refactoringWizard = this.getRefactoringWizard();
        if (this.hasChanges()) {
            ITreeContentProvider provider;
            PreviewNode element;
            IStructuredSelection selection;
            this.fPageContainer.showPage(this.fStandardPage);
            AbstractChangeNode treeViewerInput = (AbstractChangeNode)this.fTreeViewer.getInput();
            if (visible && treeViewerInput != null && (selection = (IStructuredSelection)this.fTreeViewer.getSelection()).isEmpty() && (element = this.getFirstNonCompositeChange(provider = (ITreeContentProvider)this.fTreeViewer.getContentProvider(), treeViewerInput)) != null) {
                Object[] subElements;
                if (refactoringWizard != null && refactoringWizard.internalGetExpandFirstNode(InternalAPI.INSTANCE) && (subElements = provider.getElements((Object)element)) != null && subElements.length > 0) {
                    this.fTreeViewer.expandToLevel((Object)element, 999);
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
            ((FilterDropDownAction)this.fFilterDropDownAction).initialize(this.collectGroupCategories());
            super.setVisible(visible);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(visible);
        }
        if (refactoringWizard != null) {
            refactoringWizard.internalSetPreviewShown(InternalAPI.INSTANCE, visible);
        }
    }

    private PreviewNode getFirstNonCompositeChange(ITreeContentProvider provider, AbstractChangeNode input) {
        PreviewNode focus = input;
        Change change = input.getChange();
        while (change != null && change instanceof CompositeChange) {
            PreviewNode[] children = (PreviewNode[])provider.getElements((Object)focus);
            if (children == null || children.length == 0) {
                return null;
            }
            focus = children[0];
            Change change2 = change = focus instanceof AbstractChangeNode ? ((AbstractChangeNode)focus).getChange() : null;
        }
        return focus;
    }

    protected void setTreeViewerInput() {
        if (this.fTreeViewer == null) {
            return;
        }
        PreviewNode input = null;
        if (this.fTreeViewerInputChange != null) {
            input = AbstractChangeNode.createNode(null, (Change)this.fTreeViewerInputChange);
        }
        this.fTreeViewer.setInput(input);
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PreviewNode element = (PreviewNode)event.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, element) || this.isChild(element, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(PreviewNode element, PreviewNode child) {
                while (child != null) {
                    if (child == element) {
                        return true;
                    }
                    child = child.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    PreviewNode newSelection = (PreviewNode)sel.getFirstElement();
                    if (newSelection != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = newSelection;
                        PreviewWizardPage.this.showPreview(newSelection);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(PreviewNode element) {
        try {
            if (element == null) {
                this.showNullPreviewer();
            } else {
                ChangePreviewViewerDescriptor descriptor = element.getChangePreviewViewerDescriptor();
                if (this.fCurrentDescriptor != descriptor) {
                    IChangePreviewViewer newViewer;
                    if (descriptor != null) {
                        newViewer = descriptor.createViewer();
                        newViewer.createControl((Composite)this.fPreviewContainer);
                    } else {
                        newViewer = this.fNullPreviewer;
                    }
                    this.fCurrentDescriptor = descriptor;
                    element.feedInput(newViewer, this.fActiveGroupCategories);
                    if (this.fCurrentPreviewViewer != null && this.fCurrentPreviewViewer != this.fNullPreviewer) {
                        this.fCurrentPreviewViewer.getControl().dispose();
                    }
                    this.fCurrentPreviewViewer = newViewer;
                    this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
                } else {
                    element.feedInput(this.fCurrentPreviewViewer, this.fActiveGroupCategories);
                }
            }
        }
        catch (CoreException e) {
            this.showNullPreviewer();
            ExceptionHandler.handle(e, this.getShell(), RefactoringUIMessages.PreviewWizardPage_refactoring, RefactoringUIMessages.PreviewWizardPage_Internal_error);
        }
    }

    private void showNullPreviewer() {
        this.fCurrentDescriptor = null;
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof CompositeChange) {
            return this.hasChanges((CompositeChange)this.fChange);
        }
        return true;
    }

    private boolean hasChanges(CompositeChange change) {
        Change[] children = change.getChildren();
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof CompositeChange) {
                if (this.hasChanges((CompositeChange)children[index])) {
                    return true;
                }
            } else {
                return true;
            }
            ++index;
        }
        return false;
    }

    private Collection collectGroupCategories() {
        HashSet result = new HashSet();
        this.collectGroupCategories(result, this.fChange);
        return result;
    }

    private void collectGroupCategories(Set result, Change change) {
        block3: {
            block2: {
                if (!(change instanceof TextEditBasedChange)) break block2;
                TextEditBasedChangeGroup[] groups = ((TextEditBasedChange)change).getChangeGroups();
                int i = 0;
                while (i < groups.length) {
                    result.addAll(groups[i].getGroupCategorySet().asList());
                    ++i;
                }
                break block3;
            }
            if (!(change instanceof CompositeChange)) break block3;
            Change[] children = ((CompositeChange)change).getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectGroupCategories(result, children[i]);
                ++i;
            }
        }
    }

    private void setActiveGroupCategory(GroupCategory category) {
        if (this.fActiveGroupCategories == null) {
            this.fActiveGroupCategories = new ArrayList(1);
        } else {
            this.fActiveGroupCategories.clear();
        }
        this.fActiveGroupCategories.add(category);
        ((ChangeElementTreeViewer)this.fTreeViewer).setGroupCategory(this.fActiveGroupCategories);
        this.fTreeViewerPane.setText(Messages.format(RefactoringUIMessages.PreviewWizardPage_changes_filtered, category.getName()));
    }

    private void clearGroupCategories() {
        this.fActiveGroupCategories = null;
        ((ChangeElementTreeViewer)this.fTreeViewer).setGroupCategory(null);
        this.fTreeViewerPane.setText(RefactoringUIMessages.PreviewWizardPage_changes);
    }

    public Change getChange() {
        return this.fChange;
    }

    static /* synthetic */ void access$0(PreviewWizardPage previewWizardPage, GroupCategory groupCategory) {
        previewWizardPage.setActiveGroupCategory(groupCategory);
    }

    static /* synthetic */ void access$1(PreviewWizardPage previewWizardPage) {
        previewWizardPage.clearGroupCategories();
    }

    private static class NullPreviewer
    implements IChangePreviewViewer {
        private Label fLabel;

        private NullPreviewer() {
        }

        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringUIMessages.PreviewWizardPage_no_preview);
        }

        public void refresh() {
        }

        public Control getControl() {
            return this.fLabel;
        }

        public void setInput(ChangePreviewViewerInput input) {
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setId(PreviewWizardPage.NEXT_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_next_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.next_change_action");
        }

        public void run() {
            ((ChangeElementTreeViewer)PreviewWizardPage.this.fTreeViewer).revealNext();
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setId(PreviewWizardPage.PREVIOUS_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_previous_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.previous_change_action");
        }

        public void run() {
            ((ChangeElementTreeViewer)PreviewWizardPage.this.fTreeViewer).revealPrevious();
        }
    }

    private class FilterAction
    extends Action {
        private FilterDropDownAction fOwner;
        private GroupCategory fGroupCategory;

        public FilterAction(FilterDropDownAction owner, GroupCategory category) {
            super(category.getName(), 8);
            this.setToolTipText(category.getDescription());
            this.fOwner = owner;
            this.fGroupCategory = category;
        }

        public void run() {
            BusyIndicator.showWhile((Display)PreviewWizardPage.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ FilterAction this$1;
                {
                    this.this$1 = filterAction;
                }

                public void run() {
                    PreviewWizardPage.access$0(FilterAction.access$2(this.this$1), FilterAction.access$0(this.this$1));
                    FilterAction.access$1(this.this$1).executed(this.this$1);
                }
            });
        }

        static /* synthetic */ GroupCategory access$0(FilterAction filterAction) {
            return filterAction.fGroupCategory;
        }

        static /* synthetic */ FilterDropDownAction access$1(FilterAction filterAction) {
            return filterAction.fOwner;
        }

        static /* synthetic */ PreviewWizardPage access$2(FilterAction filterAction) {
            return filterAction.PreviewWizardPage.this;
        }
    }

    private class ShowAllAction
    extends Action {
        private FilterDropDownAction fOwner;

        public ShowAllAction(FilterDropDownAction owner) {
            super(RefactoringUIMessages.PreviewWizardPage_showAll_text, 8);
            super.setToolTipText(RefactoringUIMessages.PreviewWizardPage_showAll_description);
            this.fOwner = owner;
            this.setChecked(true);
        }

        public void run() {
            BusyIndicator.showWhile((Display)PreviewWizardPage.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ ShowAllAction this$1;
                {
                    this.this$1 = showAllAction;
                }

                public final void run() {
                    PreviewWizardPage.access$1(ShowAllAction.access$1(this.this$1));
                    ShowAllAction.access$0(this.this$1).executed(this.this$1);
                }
            });
        }

        static /* synthetic */ FilterDropDownAction access$0(ShowAllAction showAllAction) {
            return showAllAction.fOwner;
        }

        static /* synthetic */ PreviewWizardPage access$1(ShowAllAction showAllAction) {
            return showAllAction.PreviewWizardPage.this;
        }
    }

    private class FilterDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private ShowAllAction fShowAllAction;
        private FilterAction[] fFilterActions;
        private Action fActiveAction;

        public FilterDropDownAction() {
            this.setImageDescriptor(RefactoringPluginImages.DESC_ELCL_FILTER);
            this.setDisabledImageDescriptor(RefactoringPluginImages.DESC_DLCL_FILTER);
            this.setText(RefactoringUIMessages.PreviewWizardPage_filterChanges);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_filterChanges);
            this.setMenuCreator(this);
        }

        public void initialize(Collection groupCategories) {
            ArrayList list = new ArrayList(groupCategories);
            Collections.sort(list, new Comparator(this){
                private Collator fCollator;
                final /* synthetic */ FilterDropDownAction this$1;
                {
                    this.this$1 = filterDropDownAction;
                    this.fCollator = Collator.getInstance();
                }

                public final int compare(Object first, Object second) {
                    GroupCategory left = (GroupCategory)first;
                    GroupCategory right = (GroupCategory)second;
                    return this.fCollator.compare(left.getName(), right.getName());
                }
            });
            this.fShowAllAction = new ShowAllAction(this);
            this.fActiveAction = this.fShowAllAction;
            this.fFilterActions = new FilterAction[list.size()];
            int i = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                this.fFilterActions[i++] = new FilterAction(this, (GroupCategory)iter.next());
            }
            this.setEnabled(list.size() > 0);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            this.dispose();
            this.fMenu = new Menu(parent);
            new ActionContributionItem((IAction)this.fShowAllAction).fill(this.fMenu, -1);
            new MenuItem(this.fMenu, 2);
            int i = 0;
            while (i < this.fFilterActions.length) {
                new ActionContributionItem((IAction)this.fFilterActions[i]).fill(this.fMenu, -1);
                ++i;
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event event) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Menu menu = this.getMenu((Control)toolBar);
            Rectangle toolItemBounds = toolItem.getBounds();
            Point location = toolBar.toDisplay(toolItemBounds.x, toolItemBounds.y + toolItemBounds.height);
            menu.setLocation(location);
            menu.setVisible(true);
        }

        public void executed(Action action) {
            if (this.fActiveAction == action) {
                return;
            }
            this.fActiveAction.setChecked(false);
            this.fActiveAction = action;
            this.fActiveAction.setChecked(true);
        }
    }
}

