/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.TextStatusContextViewer;
import org.eclipse.swt.widgets.Composite;

public class FileStatusContextViewer
extends TextStatusContextViewer {
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getSourceViewer().configure(new SourceViewerConfiguration());
    }

    public void setInput(RefactoringStatusContext context) {
        FileStatusContext fc = (FileStatusContext)context;
        IFile file = fc.getFile();
        this.updateTitle((IAdaptable)file);
        IDocument document = this.getDocument(file);
        IRegion region = fc.getTextRegion();
        if (document.getLength() >= region.getOffset() + region.getLength()) {
            this.setInput(document, region);
        } else {
            this.setInput(document, (IRegion)new Region(0, 0));
        }
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        return new SourceViewer(parent, null, 66306);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocument getDocument(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        try {
            block5: {
                IDocument iDocument;
                try {
                    manager.connect(path, (IProgressMonitor)new NullProgressMonitor());
                    ITextFileBuffer buffer = manager.getTextFileBuffer(path);
                    if (buffer == null) break block5;
                    iDocument = buffer.getDocument();
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    manager.disconnect(path, (IProgressMonitor)new NullProgressMonitor());
                    throw throwable;
                }
                manager.disconnect(path, (IProgressMonitor)new NullProgressMonitor());
                return iDocument;
            }
            Object var5_9 = null;
            manager.disconnect(path, (IProgressMonitor)new NullProgressMonitor());
            return new Document(RefactoringUIMessages.FileStatusContextViewer_error_reading_file);
        }
        catch (CoreException e) {
            RefactoringUIPlugin.log(e);
        }
        return new Document(RefactoringUIMessages.FileStatusContextViewer_error_reading_file);
    }
}

