/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search2.internal.ui.QueryManager;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.SearchViewManager;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class InternalSearchUI {
    private static InternalSearchUI fgInstance;
    private HashMap fSearchJobs;
    private QueryManager fSearchResultsManager;
    private PositionTracker fPositionTracker;
    private SearchViewManager fSearchViewManager;
    public static final Object FAMILY_SEARCH;
    static /* synthetic */ Class class$0;

    static {
        FAMILY_SEARCH = new Object();
    }

    private void searchJobStarted(SearchJobRecord record) {
        record.isRunning = true;
        this.getSearchManager().queryStarting(record.query);
    }

    private void searchJobFinished(SearchJobRecord record) {
        record.isRunning = false;
        this.fSearchJobs.remove(record);
        this.getSearchManager().queryFinished(record.query);
    }

    public InternalSearchUI() {
        fgInstance = this;
        this.fSearchJobs = new HashMap();
        this.fSearchResultsManager = new QueryManager();
        this.fPositionTracker = new PositionTracker();
        this.fSearchViewManager = new SearchViewManager(this.fSearchResultsManager);
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(SearchPluginImages.DESC_VIEW_SEARCHRES, FAMILY_SEARCH);
    }

    public static InternalSearchUI getInstance() {
        if (fgInstance == null) {
            fgInstance = new InternalSearchUI();
        }
        return fgInstance;
    }

    public ISearchResultViewPart getSearchView() {
        return this.getSearchViewManager().getActiveSearchView();
    }

    private IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchPartSite site;
        ISearchResultViewPart view = this.getSearchView();
        if (view != null && (site = view.getSite()) != null) {
            IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean runSearchInBackground(ISearchQuery query, ISearchResultViewPart view) {
        if (this.isQueryRunning(query)) {
            return false;
        }
        if (view == null) {
            this.getSearchViewManager().activateSearchView(true);
        } else {
            this.getSearchViewManager().activateSearchView(view);
        }
        this.addQuery(query);
        SearchJobRecord sjr = new SearchJobRecord(query, true);
        this.fSearchJobs.put(query, sjr);
        InternalSearchJob job = new InternalSearchJob(sjr);
        job.setPriority(40);
        job.setUser(true);
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.schedule((Job)job, 0L, true);
        } else {
            job.schedule();
        }
        return true;
    }

    public boolean isQueryRunning(ISearchQuery query) {
        SearchJobRecord sjr = (SearchJobRecord)this.fSearchJobs.get(query);
        return sjr != null && sjr.isRunning;
    }

    public IStatus runSearchInForeground(IRunnableContext context, ISearchQuery query, ISearchResultViewPart view) {
        if (this.isQueryRunning(query)) {
            return Status.CANCEL_STATUS;
        }
        if (view == null) {
            this.getSearchViewManager().activateSearchView(true);
        } else {
            this.getSearchViewManager().activateSearchView(view);
        }
        this.addQuery(query);
        SearchJobRecord sjr = new SearchJobRecord(query, false);
        this.fSearchJobs.put(query, sjr);
        if (context == null) {
            context = new ProgressMonitorDialog(null);
        }
        return this.doRunSearchInForeground(sjr, context);
    }

    private IStatus doRunSearchInForeground(final SearchJobRecord rec, IRunnableContext context) {
        try {
            context.run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    InternalSearchUI.this.searchJobStarted(rec);
                    try {
                        try {
                            IStatus status = rec.query.run(monitor);
                            if (status.matches(8)) {
                                throw new InterruptedException();
                            }
                            if (!status.isOK()) {
                                throw new InvocationTargetException(new CoreException(status));
                            }
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        InternalSearchUI.this.searchJobFinished(rec);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    InternalSearchUI.this.searchJobFinished(rec);
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable innerException = e.getTargetException();
            if (innerException instanceof CoreException) {
                return ((CoreException)innerException).getStatus();
            }
            return new Status(4, SearchPlugin.getID(), 0, SearchMessages.InternalSearchUI_error_unexpected, innerException);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static void shutdown() {
        InternalSearchUI instance = fgInstance;
        if (instance != null) {
            instance.doShutdown();
        }
    }

    private void doShutdown() {
        Iterator jobRecs = this.fSearchJobs.values().iterator();
        while (jobRecs.hasNext()) {
            SearchJobRecord element = (SearchJobRecord)jobRecs.next();
            if (element.job == null) continue;
            element.job.cancel();
        }
        this.fPositionTracker.dispose();
        this.fSearchViewManager.dispose(this.fSearchResultsManager);
    }

    public void cancelSearch(ISearchQuery job) {
        SearchJobRecord rec = (SearchJobRecord)this.fSearchJobs.get(job);
        if (rec != null && rec.job != null) {
            rec.job.cancel();
        }
    }

    public QueryManager getSearchManager() {
        return this.fSearchResultsManager;
    }

    public SearchViewManager getSearchViewManager() {
        return this.fSearchViewManager;
    }

    public PositionTracker getPositionTracker() {
        return this.fPositionTracker;
    }

    public void addQueryListener(IQueryListener l) {
        this.getSearchManager().addQueryListener(l);
    }

    public ISearchQuery[] getQueries() {
        return this.getSearchManager().getQueries();
    }

    public void removeQueryListener(IQueryListener l) {
        this.getSearchManager().removeQueryListener(l);
    }

    public void removeQuery(ISearchQuery query) {
        this.cancelSearch(query);
        this.getSearchManager().removeQuery(query);
        this.fSearchJobs.remove(query);
    }

    public void addQuery(ISearchQuery query) {
        int historyLimit = SearchPreferencePage.getHistoryLimit();
        QueryManager searchManager = this.getSearchManager();
        ISearchQuery[] queries = searchManager.getQueries();
        int i = historyLimit - 1;
        while (i < queries.length) {
            this.removeQuery(queries[i]);
            ++i;
        }
        searchManager.addQuery(query);
    }

    public void removeAllQueries() {
        Iterator queries = this.fSearchJobs.keySet().iterator();
        while (queries.hasNext()) {
            ISearchQuery query = (ISearchQuery)queries.next();
            this.cancelSearch(query);
        }
        this.fSearchJobs.clear();
        this.getSearchManager().removeAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showSearchResult(SearchView searchView, ISearchResult result, boolean openInNew) {
        if (!openInNew) {
            this.showSearchResult(searchView, result);
            return;
        }
        boolean isPinned = searchView.isPinned();
        searchView.setPinned(true);
        try {
            SearchView newPart = (SearchView)InternalSearchUI.getInstance().getSearchViewManager().activateSearchView(true);
            this.showSearchResult(newPart, result);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            searchView.setPinned(isPinned);
            throw throwable;
        }
        {
            Object var6_8 = null;
            searchView.setPinned(isPinned);
            return;
        }
    }

    private void showSearchResult(SearchView searchView, ISearchResult result) {
        this.getSearchManager().touch(result.getQuery());
        searchView.showSearchResult(result);
    }

    private class SearchJobRecord {
        public ISearchQuery query;
        public Job job;
        public boolean background;
        public boolean isRunning;

        public SearchJobRecord(ISearchQuery job, boolean bg) {
            this.query = job;
            this.background = bg;
            this.isRunning = false;
            this.job = null;
        }
    }

    private class InternalSearchJob
    extends Job {
        private SearchJobRecord fSearchJobRecord;

        public InternalSearchJob(SearchJobRecord sjr) {
            super(sjr.query.getLabel());
            this.fSearchJobRecord = sjr;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            this.fSearchJobRecord.job = this;
            InternalSearchUI.this.searchJobStarted(this.fSearchJobRecord);
            IStatus status = null;
            int origPriority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
            }
            catch (SecurityException securityException) {}
            try {
                status = this.fSearchJobRecord.query.run(monitor);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    Thread.currentThread().setPriority(origPriority);
                }
                catch (SecurityException securityException) {}
                InternalSearchUI.this.searchJobFinished(this.fSearchJobRecord);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            try {}
            catch (SecurityException securityException) {}
            Thread.currentThread().setPriority(origPriority);
            InternalSearchUI.this.searchJobFinished(this.fSearchJobRecord);
            this.fSearchJobRecord.job = null;
            return status;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_SEARCH;
        }
    }
}

