/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;

public class TextSearchEngineRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.search.textSearchEngine";
    private static final String ENGINE_NODE_NAME = "textSearchEngine";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_LABEL = "label";
    private static final String ATTRIB_CLASS = "class";
    private TextSearchEngine fPreferredEngine = null;
    private String fPreferredEngineId = null;

    public TextSearchEngine getPreferred() {
        String preferredId = this.getPreferredEngineID();
        if (!preferredId.equals(this.fPreferredEngineId)) {
            this.updateEngine(preferredId);
        }
        return this.fPreferredEngine;
    }

    private void updateEngine(String preferredId) {
        if (preferredId.length() != 0) {
            TextSearchEngine engine = this.createFromExtension(preferredId);
            if (engine != null) {
                this.fPreferredEngineId = preferredId;
                this.fPreferredEngine = engine;
                return;
            }
            this.setPreferredEngineID("");
        }
        this.fPreferredEngineId = "";
        this.fPreferredEngine = TextSearchEngine.createDefault();
    }

    private String getPreferredEngineID() {
        Preferences prefs = SearchPlugin.getDefault().getPluginPreferences();
        String preferedEngine = prefs.getString(EXTENSION_POINT_ID);
        return preferedEngine;
    }

    private void setPreferredEngineID(String id) {
        Preferences prefs = SearchPlugin.getDefault().getPluginPreferences();
        prefs.setValue(EXTENSION_POINT_ID, id);
    }

    private TextSearchEngine createFromExtension(final String id) {
        final TextSearchEngine[] res = new TextSearchEngine[1];
        SafeRunnable safe = new SafeRunnable(){

            public void run() throws Exception {
                IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(TextSearchEngineRegistry.EXTENSION_POINT_ID);
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement curr = extensions[i];
                    if (TextSearchEngineRegistry.ENGINE_NODE_NAME.equals(curr.getName()) && id.equals(curr.getAttribute(TextSearchEngineRegistry.ATTRIB_ID))) {
                        res[0] = (TextSearchEngine)curr.createExecutableExtension(TextSearchEngineRegistry.ATTRIB_CLASS);
                        return;
                    }
                    ++i;
                }
            }

            public void handleException(Throwable e) {
                SearchPlugin.log(e);
            }
        };
        SafeRunnable.run((ISafeRunnable)safe);
        return res[0];
    }

    public String[][] getAvailableEngines() {
        ArrayList<String[]> res = new ArrayList<String[]>();
        res.add(new String[]{SearchMessages.TextSearchEngineRegistry_defaulttextsearch_label, ""});
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement engine = extensions[i];
            if (ENGINE_NODE_NAME.equals(engine.getName())) {
                res.add(new String[]{engine.getAttribute(ATTRIB_LABEL), engine.getAttribute(ATTRIB_ID)});
            }
            ++i;
        }
        return (String[][])res.toArray((T[])new String[res.size()][]);
    }
}

