/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.IIdentifiable;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.ILayoutNode;
import org.eclipse.ui.internal.menus.IMenuCollection;
import org.eclipse.ui.internal.menus.LocationElementToken;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.OrderNode;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SOrder;
import org.eclipse.ui.internal.misc.Policy;

final class LayoutNode
implements ILayoutNode,
IMenuCollection,
IPropertyChangeListener {
    private static final int BINARY_CUT_OFF = 5;
    private static final int END = 2;
    private static final int MIDDLE = 1;
    private static final int NUMBER_OF_BLOCKS = 3;
    private static final int START = 0;
    private Map childrenById;
    private MenuElement element;
    private SLocation location;
    private List orderedChildren;

    private static final SLocation getLocation(MenuElement element) throws NotDefinedException {
        SLocation[] locations = element.getLocations();
        if (locations.length > 0) {
            return locations[0];
        }
        return null;
    }

    static final void sortedInsert(List list, IIdentifiable node) {
        if (list.size() < 5) {
            LayoutNode.sortedInsertLinear(list, node);
        } else {
            LayoutNode.sortedInsertBinary(list, node);
        }
    }

    private static final void sortedInsertBinary(List list, IIdentifiable node) {
        block4: {
            String nodeId = node.getId();
            int topIndex = list.size() - 1;
            int bottomIndex = 0;
            int middleIndex = 0;
            while (true) {
                IIdentifiable current;
                String currentId;
                int comparison;
                if ((comparison = Util.compare((Comparable)((Object)nodeId), (Comparable)((Object)(currentId = (current = (IIdentifiable)list.get(middleIndex = (topIndex + bottomIndex) / 2)).getId())))) < 0) {
                    if (bottomIndex == middleIndex) {
                        list.add(bottomIndex, node);
                        break block4;
                    }
                    topIndex = middleIndex;
                    continue;
                }
                if (comparison <= 0) break;
                if (bottomIndex == middleIndex) {
                    list.add(topIndex, node);
                    break block4;
                }
                bottomIndex = middleIndex;
            }
            list.add(middleIndex, node);
        }
    }

    private static final void sortedInsertLinear(List list, IIdentifiable node) {
        String nodeId = node.getId();
        int length = list.size();
        int i = 0;
        while (i < length) {
            IIdentifiable current = (IIdentifiable)list.get(i);
            String currentId = current.getId();
            int comparison = Util.compare((Comparable)((Object)nodeId), (Comparable)((Object)currentId));
            if (comparison < 0) {
                list.add(i, node);
                return;
            }
            ++i;
        }
        list.add(node);
    }

    LayoutNode() {
    }

    public final void add(MenuElement element) throws NotDefinedException {
        this.createChildNode(element, null);
        this.orderedChildren = null;
    }

    public final void clear() {
        this.childrenById = null;
        this.orderedChildren = null;
    }

    final void createChildNode(MenuElement element, SLocation location) throws NotDefinedException {
        if (element == null) {
            throw new NullPointerException("A child node cannot be created from a null element");
        }
        String id = element.getId();
        if (Policy.EXPERIMENTAL_MENU && id.equals("org.eclipse.search.menu")) {
            System.err.println("createChildNode: " + location);
        }
        LayoutNode childNode = null;
        if (this.childrenById == null) {
            this.childrenById = new HashMap(4);
        } else {
            childNode = (LayoutNode)this.childrenById.get(id);
        }
        if (childNode == null) {
            childNode = new LayoutNode();
            this.childrenById.put(id, childNode);
            this.orderedChildren = null;
        }
        if (element != null) {
            childNode.setElement(element);
        }
        childNode.setLocation(location == null ? LayoutNode.getLocation(element) : location);
    }

    final LayoutNode getChildNode(LocationElementToken token) {
        if (token == null) {
            throw new NullPointerException("A child node cannot be created from a null token");
        }
        String id = token.getId();
        LayoutNode childNode = null;
        if (this.childrenById == null) {
            this.childrenById = new HashMap(4);
        } else {
            childNode = (LayoutNode)this.childrenById.get(id);
        }
        if (childNode == null) {
            childNode = new LayoutNode();
            this.childrenById.put(id, childNode);
            childNode.setLocation(token.getLocation());
            this.orderedChildren = null;
        }
        return childNode;
    }

    public final List getChildrenSorted() {
        Collection unsortedChildren = this.getChildrenUnsorted();
        int numberOfChildren = unsortedChildren.size();
        ArrayList sortedChildren = new ArrayList(numberOfChildren);
        HashMap<String, OrderNode> orderNodeById = new HashMap<String, OrderNode>();
        List[] blocks = new List[]{new ArrayList(numberOfChildren), new ArrayList(numberOfChildren), new ArrayList(numberOfChildren)};
        ArrayList relativeOrderedChildren = new ArrayList(numberOfChildren);
        Iterator childItr = unsortedChildren.iterator();
        while (childItr.hasNext()) {
            LayoutNode child = (LayoutNode)childItr.next();
            OrderNode orderNode = new OrderNode(child);
            orderNodeById.put(orderNode.getId(), orderNode);
            SLocation location = child.getLocation();
            if (location == null) {
                LayoutNode.sortedInsert(blocks[1], orderNode);
                continue;
            }
            SOrder orderingConstraint = location.getOrdering();
            if (orderingConstraint == null) {
                LayoutNode.sortedInsert(blocks[1], orderNode);
                continue;
            }
            int position = orderingConstraint.getPosition();
            switch (position) {
                case 2: 
                case 3: {
                    LayoutNode.sortedInsert(relativeOrderedChildren, child);
                    break;
                }
                case 0: {
                    LayoutNode.sortedInsert(blocks[0], orderNode);
                    break;
                }
                case 1: {
                    LayoutNode.sortedInsert(blocks[2], orderNode);
                    break;
                }
                default: {
                    LayoutNode.sortedInsert(blocks[1], orderNode);
                }
            }
        }
        int i = 0;
        while (i < relativeOrderedChildren.size()) {
            LayoutNode node = (LayoutNode)relativeOrderedChildren.get(i);
            String id = node.getId();
            SLocation location = node.getLocation();
            SOrder order = location.getOrdering();
            String relativeTo = order.getRelativeTo();
            boolean before = order.getPosition() == 2;
            OrderNode orderNode = (OrderNode)orderNodeById.get(id);
            OrderNode relativeNode = (OrderNode)orderNodeById.get(relativeTo);
            if (relativeNode != null) {
                if (before) {
                    relativeNode.addBeforeNode(orderNode);
                } else {
                    relativeNode.addAfterNode(orderNode);
                }
            }
            ++i;
        }
        i = 0;
        while (i < blocks.length) {
            Iterator itr = blocks[i].iterator();
            while (itr.hasNext()) {
                OrderNode node = (OrderNode)itr.next();
                node.addTo(sortedChildren);
            }
            ++i;
        }
        return sortedChildren;
    }

    final Collection getChildrenUnsorted() {
        if (this.childrenById == null) {
            return Collections.EMPTY_LIST;
        }
        return this.childrenById.values();
    }

    public final String getId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return null;
    }

    public final SLocation getLocation() {
        return this.location;
    }

    public final MenuElement getMenuElement() {
        return this.element;
    }

    public final boolean isEmpty() {
        return this.childrenById == null || this.childrenById.isEmpty();
    }

    public final void propertyChange(PropertyChangeEvent event) {
    }

    public final boolean remove(MenuElement element) {
        if (this.orderedChildren != null) {
            this.orderedChildren.remove((Object)element);
        }
        if (this.childrenById != null) {
            String id = element.getId();
            Object removedObject = this.childrenById.remove(id);
            return removedObject != null;
        }
        return false;
    }

    final void setElement(MenuElement element) {
        if (element == null) {
            throw new NullPointerException("A node cannot be given a null element");
        }
        if (this.element != null) {
            this.element.removeListener(this);
        }
        this.element = element;
        if (element != null) {
            element.addListener(this);
        }
    }

    final void setLocation(SLocation location) {
        if (location == null) {
            throw new NullPointerException("A node cannot be given a null location");
        }
        this.location = location;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer("LayoutNode(");
        buffer.append((Object)this.element);
        buffer.append(',');
        buffer.append(this.location);
        buffer.append(')');
        return buffer.toString();
    }
}

