/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.internal.core.AntObject;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AntObjectLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof Property) {
            Property prop = (Property)element;
            if (prop.isDefault() && prop.isEclipseRuntimeRequired()) {
                return AntUIImages.getImage("org.eclipse.ant.ui.antEclipse");
            }
            return AntObjectLabelProvider.getPropertyImage();
        }
        if (element instanceof AntObject) {
            AntObject object = (AntObject)element;
            if (object.isDefault() && object.isEclipseRuntimeRequired()) {
                return AntUIImages.getImage("org.eclipse.ant.ui.antEclipse");
            }
            if (element instanceof Task) {
                return AntObjectLabelProvider.getTaskImage();
            }
            return AntObjectLabelProvider.getTypeImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Property) {
            return this.getPropertyText((Property)element, columnIndex);
        }
        if (element instanceof AntObject) {
            AntObject object = (AntObject)element;
            switch (columnIndex) {
                case 0: {
                    return object.toString();
                }
                case 1: {
                    return object.getClassName();
                }
                case 2: {
                    return object.getLibraryEntry().getLabel();
                }
                case 3: {
                    return object.getPluginLabel();
                }
            }
        }
        return element.toString();
    }

    public String getPropertyText(Property property, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return property.getValue(false);
            }
            case 2: {
                if (!property.isDefault()) break;
                return property.getPluginLabel();
            }
        }
        return null;
    }

    public static Image getTypeImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.type");
    }

    public static Image getTaskImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
    }

    public static Image getPropertyImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof AntObject) {
            if (((AntObject)element).isDefault()) {
                Display display = Display.getCurrent();
                return display.getSystemColor(29);
            }
        } else if (element instanceof Property && ((Property)element).isDefault()) {
            Display display = Display.getCurrent();
            return display.getSystemColor(29);
        }
        return null;
    }
}

