/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.preferences.StringVariablePreferencePage;
import org.eclipse.debug.internal.ui.stringsubstitution.IArgumentSelector;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableLabelProvider;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariablePresentationManager;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StringVariableSelectionDialog
extends ElementListSelectionDialog {
    private Button fArgumentButton;
    private Text fDescriptionText;
    private Text fArgumentText;
    private String fArgumentValue;
    private Button fEditVariablesButton;

    public StringVariableSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StringVariableLabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_2);
        this.setMessage(StringSubstitutionMessages.StringVariableSelectionDialog_3);
        this.setMultipleSelection(false);
        this.setElements(VariablesPlugin.getDefault().getStringVariableManager().getVariables());
    }

    public String getVariableExpression() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length == 1) {
            IStringVariable variable = (IStringVariable)selected[0];
            StringBuffer buffer = new StringBuffer();
            buffer.append("${");
            buffer.append(variable.getName());
            if (this.fArgumentValue != null && this.fArgumentValue.length() > 0) {
                buffer.append(":");
                buffer.append(this.fArgumentValue);
            }
            buffer.append("}");
            return buffer.toString();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        container.setFont(parent.getFont());
        this.fEditVariablesButton = new Button(container, 8);
        this.fEditVariablesButton.setFont(container.getFont());
        this.fEditVariablesButton.setText(StringSubstitutionMessages.StringVariableSelectionDialog_0);
        gd = new GridData(128);
        gd.horizontalSpan = 2;
        this.fEditVariablesButton.setLayoutData((Object)gd);
        this.fEditVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.editVariables();
            }
        });
        Label desc = new Label(container, 0);
        desc.setFont(parent.getFont());
        desc.setText(StringSubstitutionMessages.StringVariableSelectionDialog_6);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        desc.setLayoutData((Object)gd);
        Composite args = new Composite(container, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        args.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        args.setLayoutData((Object)gd);
        args.setFont(container.getFont());
        this.fArgumentText = new Text(args, 2048);
        this.fArgumentText.setFont(container.getFont());
        gd = new GridData(768);
        this.fArgumentText.setLayoutData((Object)gd);
        this.fArgumentButton = new Button(args, 8);
        this.fArgumentButton.setFont(parent.getFont());
        this.fArgumentButton.setText(StringSubstitutionMessages.StringVariableSelectionDialog_7);
        gd = new GridData(128);
        gd.widthHint = SWTUtil.getButtonWidthHint(this.fArgumentButton);
        this.fArgumentButton.setLayoutData((Object)gd);
        this.fArgumentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.configureArgument();
            }
        });
        desc = new Label(container, 0);
        desc.setFont(parent.getFont());
        desc.setText(StringSubstitutionMessages.StringVariableSelectionDialog_8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        desc.setLayoutData((Object)gd);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void editVariables() {
        StringVariablePreferencePage page = new StringVariablePreferencePage();
        page.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_1);
        PreferenceNode targetNode = new PreferenceNode("org.eclipse.debug.ui.StringVariablePreferencePage", (IPreferencePage)page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager);
        Display display = DebugUIPlugin.getStandardDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable((IPreferenceNode)targetNode, display){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ Display val$display;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$display = display;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                if (dialog.open() == 0) {
                    IStringVariable[] elements = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
                    this.val$display.asyncExec(new Runnable(this, elements){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IStringVariable[] val$elements;
                        {
                            this.this$1 = var1_1;
                            this.val$elements = iStringVariableArray;
                        }

                        public void run() {
                            StringVariableSelectionDialog.access$0(3.access$0(this.this$1), this.val$elements);
                        }
                    });
                }
            }

            static /* synthetic */ StringVariableSelectionDialog access$0(3 var0) {
                return var0.StringVariableSelectionDialog.this;
            }
        });
    }

    protected void configureArgument() {
        Object[] objects = this.getSelectedElements();
        IStringVariable variable = (IStringVariable)objects[0];
        IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
        String value = selector.selectArgument(variable, this.getShell());
        if (value != null) {
            this.fArgumentText.setText(value);
        }
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        boolean buttonEnabled = false;
        boolean argEnabled = false;
        String text = null;
        if (objects.length == 1) {
            IStringVariable variable = (IStringVariable)objects[0];
            IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
            if (variable instanceof IDynamicVariable) {
                argEnabled = ((IDynamicVariable)variable).supportsArgument();
            }
            buttonEnabled = argEnabled && selector != null;
            text = variable.getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.fArgumentText.setEnabled(argEnabled);
        this.fArgumentButton.setEnabled(buttonEnabled);
        this.fDescriptionText.setText(text);
    }

    protected void okPressed() {
        this.fArgumentValue = this.fArgumentText.getText().trim();
        super.okPressed();
    }

    private String getDialogSettingsSectionName() {
        return String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".STRING_VARIABLE_SELECTION_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    static /* synthetic */ void access$0(StringVariableSelectionDialog stringVariableSelectionDialog, Object[] objectArray) {
        stringVariableSelectionDialog.setListElements(objectArray);
    }
}

