/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class InspectPopupDialog
extends DebugPopup {
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{90, 10};
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 200;
    private VariablesViewer fVariablesViewer;
    private IDebugModelPresentation fModelPresentation;
    private StyledText fValueDisplay;
    private SashForm fSashForm;
    private Tree fTree;
    private IExpression fExpression;

    public InspectPopupDialog(Shell shell, Point anchor, String commandId, IExpression expression) {
        super(shell, anchor, commandId);
        this.fExpression = expression;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, parent.getStyle());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fSashForm = new SashForm(composite, parent.getStyle());
        this.fSashForm.setOrientation(512);
        this.fSashForm.setLayoutData((Object)new GridData(1808));
        VariablesView view = this.getViewToEmulate();
        this.fVariablesViewer = new VariablesViewer((Composite)this.fSashForm, 0x10000008, null);
        this.fVariablesViewer.setContext(new PresentationContext((IWorkbenchPart)view));
        this.fModelPresentation = new VariablesViewModelPresentation();
        this.fVariablesViewer.setLabelProvider((IBaseLabelProvider)this.fModelPresentation);
        this.fValueDisplay = new StyledText((Composite)this.fSashForm, 584);
        this.fValueDisplay.setEditable(false);
        this.fTree = this.fVariablesViewer.getTree();
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TreeItem[] selections = InspectPopupDialog.this.fTree.getSelection();
                    if (selections.length > 0) {
                        Object data = selections[selections.length - 1].getData();
                        IValue val = null;
                        if (data instanceof IndexedVariablePartition) {
                            return;
                        }
                        if (data instanceof IVariable) {
                            val = ((IVariable)data).getValue();
                        } else if (data instanceof IExpression) {
                            val = ((IExpression)data).getValue();
                        }
                        if (val == null) {
                            return;
                        }
                        InspectPopupDialog.this.updateValueDisplay(val);
                    }
                }
                catch (DebugException ex) {
                    DebugUIPlugin.log(ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Color background = parent.getDisplay().getSystemColor(29);
        Color foreground = parent.getDisplay().getSystemColor(28);
        this.fTree.setForeground(foreground);
        this.fTree.setBackground(background);
        composite.setForeground(foreground);
        composite.setBackground(background);
        this.fValueDisplay.setForeground(foreground);
        this.fValueDisplay.setBackground(background);
        this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        this.fVariablesViewer.getContentProvider();
        if (view != null) {
            StructuredViewer structuredViewer = (StructuredViewer)view.getViewer();
            if (structuredViewer != null) {
                ViewerFilter[] filters = structuredViewer.getFilters();
                int i = 0;
                while (i < filters.length) {
                    this.fVariablesViewer.addFilter(filters[i]);
                    ++i;
                }
            }
            Map map = view.getPresentationAttributes(this.fExpression.getModelIdentifier());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.fModelPresentation.setAttribute(key, map.get(key));
            }
        }
        TreeRoot treeRoot = new TreeRoot();
        this.fVariablesViewer.setInput(treeRoot);
        this.fVariablesViewer.expand((ISelection)new TreeSelection(new TreePath(new Object[]{treeRoot, this.fExpression})));
        return this.fTree;
    }

    private void updateValueDisplay(IValue val) {
        IValueDetailListener valueDetailListener = new IValueDetailListener(){

            public void detailComputed(IValue value, String result) {
                Display.getDefault().asyncExec(new Runnable(this, result){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ String val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$result = string;
                    }

                    public void run() {
                        if (!InspectPopupDialog.access$3(2.access$0(this.this$1)).isDisposed()) {
                            String text = this.val$result;
                            int max = DebugUIPlugin.getDefault().getPreferenceStore().getInt(IDebugUIConstants.PREF_MAX_DETAIL_LENGTH);
                            if (max > 0 && this.val$result.length() > max) {
                                text = String.valueOf(this.val$result.substring(0, max)) + "...";
                            }
                            InspectPopupDialog.access$3(2.access$0(this.this$1)).setText(text);
                        }
                    }
                });
            }

            static /* synthetic */ InspectPopupDialog access$0(2 var0) {
                return var0.InspectPopupDialog.this;
            }
        };
        this.fModelPresentation.computeDetail(val, valueDetailListener);
    }

    private VariablesView getViewToEmulate() {
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        VariablesView expressionsView = (VariablesView)page.findView("org.eclipse.debug.ui.ExpressionView");
        if (expressionsView != null && expressionsView.isVisible()) {
            return expressionsView;
        }
        VariablesView variablesView = (VariablesView)page.findView("org.eclipse.debug.ui.VariableView");
        if (variablesView != null && variablesView.isVisible()) {
            return variablesView;
        }
        if (expressionsView != null) {
            return expressionsView;
        }
        return variablesView;
    }

    public boolean close() {
        if (this.fVariablesViewer != null) {
            this.fVariablesViewer.dispose();
        }
        if (this.fModelPresentation != null) {
            this.fModelPresentation.dispose();
        }
        if (!this.wasPersisted()) {
            this.fExpression.dispose();
        }
        return super.close();
    }

    protected String getActionText() {
        return DebugUIViewsMessages.InspectPopupDialog_0;
    }

    protected void persist() {
        super.persist();
        DebugPlugin.getDefault().getExpressionManager().addExpression(this.fExpression);
        this.fExpression = null;
        IWorkbenchPage page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = Math.max(initialSize.x, 250);
        initialSize.y = Math.max(initialSize.y, 200);
        return initialSize;
    }

    static /* synthetic */ StyledText access$3(InspectPopupDialog inspectPopupDialog) {
        return inspectPopupDialog.fValueDisplay;
    }

    private class TreeRoot
    extends AsynchronousContentAdapter {
        private TreeRoot() {
        }

        protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
            return new Object[]{InspectPopupDialog.this.fExpression};
        }

        protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
            return true;
        }

        protected boolean supportsPartId(String id) {
            return true;
        }
    }
}

