/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.FileEditorInput;

public class ProcessConsole
extends IOConsole
implements IConsole,
IDebugEventSetListener,
IPropertyChangeListener {
    private IProcess fProcess = null;
    private List fStreamListeners = new ArrayList();
    private IConsoleColorProvider fColorProvider;
    private IOConsoleInputStream fInput;
    private FileOutputStream fFileOutputStream;
    private boolean fAllocateConsole = true;
    private boolean fStreamsClosed = false;

    public ProcessConsole(IProcess process, IConsoleColorProvider colorProvider) {
        this(process, colorProvider, null);
    }

    public ProcessConsole(IProcess process, IConsoleColorProvider colorProvider, String encoding) {
        super("", IDebugUIConstants.ID_PROCESS_CONSOLE_TYPE, null, encoding, true);
        this.fProcess = process;
        ILaunchConfiguration configuration = process.getLaunch().getLaunchConfiguration();
        String file = null;
        boolean append = false;
        if (configuration != null) {
            try {
                file = configuration.getAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_FILE, null);
                if (file != null) {
                    IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
                    file = stringVariableManager.performStringSubstitution(file);
                    append = configuration.getAttribute(IDebugUIConstants.ATTR_APPEND_TO_FILE, false);
                }
            }
            catch (CoreException coreException) {}
        }
        if (file != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            Path path = new Path(file);
            IFile ifile = root.getFileForLocation((IPath)path);
            String message = null;
            try {
                String fileLoc = null;
                if (ifile != null) {
                    if (append && ifile.exists()) {
                        ifile.appendContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        if (ifile.exists()) {
                            ifile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        ifile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                File outputFile = new File(file);
                this.fFileOutputStream = new FileOutputStream(outputFile, append);
                fileLoc = outputFile.getAbsolutePath();
                message = MessageFormat.format((String)ConsoleMessages.ProcessConsole_1, (Object[])new String[]{fileLoc});
                this.addPatternMatchListener(new ConsoleLogFilePatternMatcher(fileLoc));
            }
            catch (FileNotFoundException fileNotFoundException) {
                message = MessageFormat.format((String)ConsoleMessages.ProcessConsole_2, (Object[])new String[]{file});
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            if (message != null) {
                try {
                    IOConsoleOutputStream stream = this.newOutputStream();
                    stream.write(message);
                    stream.close();
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
            }
            try {
                this.fAllocateConsole = configuration.getAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, true);
            }
            catch (CoreException coreException) {}
        }
        this.fColorProvider = colorProvider;
        this.fInput = this.getInputStream();
        colorProvider.connect(this.fProcess, this);
        this.setName(this.computeName());
        Color color = this.fColorProvider.getColor(IDebugUIConstants.ID_STANDARD_INPUT_STREAM);
        this.fInput.setColor(color);
        IConsoleLineTracker[] lineTrackers = DebugUIPlugin.getDefault().getProcessConsoleManager().getLineTrackers(process);
        if (lineTrackers.length > 0) {
            this.addPatternMatchListener(new ConsoleLineNotifier());
        }
    }

    protected ImageDescriptor computeImageDescriptor() {
        ILaunchConfiguration configuration = this.getProcess().getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugPluginImages.getImageDescriptor(type.getIdentifier());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected String computeName() {
        String label = null;
        IProcess process = this.getProcess();
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        label = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
        if (label == null) {
            if (config == null) {
                label = process.getLabel();
            } else if (DebugUITools.isPrivate(config)) {
                label = process.getLabel();
            } else {
                String type = null;
                try {
                    type = config.getType().getName();
                }
                catch (CoreException coreException) {}
                StringBuffer buffer = new StringBuffer();
                buffer.append(config.getName());
                if (type != null) {
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
                buffer.append(process.getLabel());
                label = buffer.toString();
            }
        }
        if (process.isTerminated()) {
            return MessageFormat.format((String)ConsoleMessages.ProcessConsole_0, (Object[])new String[]{label});
        }
        return label;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getProperty();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        if (property.equals("Console.wrap") || property.equals("Console.width")) {
            boolean fixedWidth = store.getBoolean("Console.wrap");
            if (fixedWidth) {
                int width = store.getInt("Console.width");
                this.setConsoleWidth(width);
            } else {
                this.setConsoleWidth(-1);
            }
        } else if (property.equals("Console.limitConsoleOutput") || property.equals("Console.highWaterMark") || property.equals("Console.lowWaterMark")) {
            boolean limitBufferSize = store.getBoolean("Console.limitConsoleOutput");
            if (limitBufferSize) {
                int lowWater;
                int highWater = store.getInt("Console.highWaterMark");
                if (highWater > (lowWater = store.getInt("Console.lowWaterMark"))) {
                    this.setWaterMarks(lowWater, highWater);
                }
            } else {
                this.setWaterMarks(-1, -1);
            }
        } else if (property.equals("Console.console_tab_width")) {
            int tabWidth = store.getInt("Console.console_tab_width");
            this.setTabWidth(tabWidth);
        } else if (property.equals("DEBUG.consoleOpenOnOut")) {
            boolean activateOnOut = store.getBoolean("DEBUG.consoleOpenOnOut");
            IOConsoleOutputStream stream = this.getStream(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM);
            if (stream != null) {
                stream.setActivateOnWrite(activateOnOut);
            }
        } else if (property.equals("DEBUG.consoleOpenOnErr")) {
            boolean activateOnErr = store.getBoolean("DEBUG.consoleOpenOnErr");
            IOConsoleOutputStream stream = this.getStream(IDebugUIConstants.ID_STANDARD_ERROR_STREAM);
            if (stream != null) {
                stream.setActivateOnWrite(activateOnErr);
            }
        } else if (property.equals("org.eclipse.debug.ui.outColor")) {
            IOConsoleOutputStream stream = this.getStream(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM);
            if (stream != null) {
                stream.setColor(this.fColorProvider.getColor(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM));
            }
        } else if (property.equals("org.eclipse.debug.ui.errorColor")) {
            IOConsoleOutputStream stream = this.getStream(IDebugUIConstants.ID_STANDARD_ERROR_STREAM);
            if (stream != null) {
                stream.setColor(this.fColorProvider.getColor(IDebugUIConstants.ID_STANDARD_ERROR_STREAM));
            }
        } else if (property.equals("org.eclipse.debug.ui.inColor")) {
            if (this.fInput != null) {
                this.fInput.setColor(this.fColorProvider.getColor(IDebugUIConstants.ID_STANDARD_INPUT_STREAM));
            }
        } else if (property.equals("org.eclipse.debug.ui.consoleFont")) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        }
    }

    public IOConsoleOutputStream getStream(String streamIdentifier) {
        Iterator i = this.fStreamListeners.iterator();
        while (i.hasNext()) {
            StreamListener listener = (StreamListener)i.next();
            if (!listener.fStreamId.equals(streamIdentifier)) continue;
            return listener.fStream;
        }
        return null;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    protected void dispose() {
        super.dispose();
        this.fColorProvider.disconnect();
        this.closeStreams();
        this.disposeStreams();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeStreams() {
        if (this.fStreamsClosed) {
            return;
        }
        Iterator i = this.fStreamListeners.iterator();
        while (i.hasNext()) {
            StreamListener listener = (StreamListener)i.next();
            listener.closeStream();
        }
        if (this.fFileOutputStream != null) {
            FileOutputStream fileOutputStream = this.fFileOutputStream;
            synchronized (fileOutputStream) {
                try {
                    this.fFileOutputStream.flush();
                    this.fFileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.fInput.close();
        }
        catch (IOException iOException) {}
        this.fStreamsClosed = true;
    }

    private synchronized void disposeStreams() {
        Iterator i = this.fStreamListeners.iterator();
        while (i.hasNext()) {
            StreamListener listener = (StreamListener)i.next();
            listener.dispose();
        }
        this.fFileOutputStream = null;
        this.fInput = null;
    }

    protected void init() {
        super.init();
        if (this.fProcess.isTerminated()) {
            this.closeStreams();
            this.resetName();
        } else {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        if (store.getBoolean("Console.wrap")) {
            this.setConsoleWidth(store.getInt("Console.width"));
        }
        this.setTabWidth(store.getInt("Console.console_tab_width"));
        if (store.getBoolean("Console.limitConsoleOutput")) {
            int highWater = store.getInt("Console.highWaterMark");
            int lowWater = store.getInt("Console.lowWaterMark");
            this.setWaterMarks(lowWater, highWater);
        }
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                ProcessConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                if (event.getKind() == 8) {
                    this.closeStreams();
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
                this.resetName();
            }
            ++i;
        }
    }

    private void resetName() {
        final String newName = this.computeName();
        String name = this.getName();
        if (!name.equals(newName)) {
            Runnable r = new Runnable(){

                public void run() {
                    ProcessConsole.this.setName(newName);
                    ProcessConsole.this.warnOfContentChange();
                }
            };
            DebugUIPlugin.getStandardDisplay().asyncExec(r);
        }
    }

    private void warnOfContentChange() {
        ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(DebugUITools.getConsole(this.fProcess));
    }

    public void connect(IStreamsProxy streamsProxy) {
        IOConsoleOutputStream stream;
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        IStreamMonitor streamMonitor = streamsProxy.getErrorStreamMonitor();
        if (streamMonitor != null) {
            this.connect(streamMonitor, IDebugUIConstants.ID_STANDARD_ERROR_STREAM);
            stream = this.getStream(IDebugUIConstants.ID_STANDARD_ERROR_STREAM);
            if (stream != null) {
                stream.setActivateOnWrite(store.getBoolean("DEBUG.consoleOpenOnErr"));
            }
        }
        if ((streamMonitor = streamsProxy.getOutputStreamMonitor()) != null) {
            this.connect(streamMonitor, IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM);
            stream = this.getStream(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM);
            if (stream != null) {
                stream.setActivateOnWrite(store.getBoolean("DEBUG.consoleOpenOnOut"));
            }
        }
        InputReadJob readJob = new InputReadJob(streamsProxy);
        readJob.setSystem(true);
        readJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IStreamMonitor streamMonitor, String streamIdentifier) {
        IOConsoleOutputStream stream = null;
        if (this.fAllocateConsole) {
            stream = this.newOutputStream();
            Color color = this.fColorProvider.getColor(streamIdentifier);
            stream.setColor(color);
        }
        IStreamMonitor iStreamMonitor = streamMonitor;
        synchronized (iStreamMonitor) {
            StreamListener listener = new StreamListener(streamIdentifier, streamMonitor, stream);
            this.fStreamListeners.add(listener);
        }
    }

    public void addLink(IConsoleHyperlink link, int offset, int length) {
        try {
            this.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log(e);
        }
    }

    public void addLink(IHyperlink link, int offset, int length) {
        try {
            this.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log(e);
        }
    }

    public IRegion getRegion(IConsoleHyperlink link) {
        return super.getRegion((IHyperlink)link);
    }

    public ImageDescriptor getImageDescriptor() {
        if (super.getImageDescriptor() == null) {
            this.setImageDescriptor(this.computeImageDescriptor());
        }
        return super.getImageDescriptor();
    }

    public String getHelpContextId() {
        return IDebugHelpContextIds.PROCESS_CONSOLE;
    }

    private class StreamListener
    implements IStreamListener {
        private IOConsoleOutputStream fStream;
        private IStreamMonitor fStreamMonitor;
        private String fStreamId;
        private boolean fFlushed = false;
        private boolean fListenerRemoved = false;

        public StreamListener(String streamIdentifier, IStreamMonitor monitor, IOConsoleOutputStream stream) {
            this.fStreamId = streamIdentifier;
            this.fStreamMonitor = monitor;
            this.fStream = stream;
            this.fStreamMonitor.addListener((IStreamListener)this);
            this.streamAppended(null, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(String text, IStreamMonitor monitor) {
            block18: {
                if (this.fFlushed) {
                    try {
                        if (this.fStream != null) {
                            this.fStream.write(text);
                        }
                        if (ProcessConsole.this.fFileOutputStream == null) break block18;
                        FileOutputStream fileOutputStream = ProcessConsole.this.fFileOutputStream;
                        synchronized (fileOutputStream) {
                            ProcessConsole.this.fFileOutputStream.write(text.getBytes());
                        }
                    }
                    catch (IOException e) {
                        DebugUIPlugin.log(e);
                    }
                } else {
                    String contents = null;
                    Object object = this.fStreamMonitor;
                    synchronized (object) {
                        this.fFlushed = true;
                        contents = this.fStreamMonitor.getContents();
                        if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                            IFlushableStreamMonitor m = (IFlushableStreamMonitor)this.fStreamMonitor;
                            m.flushContents();
                            m.setBuffered(false);
                        }
                    }
                    try {
                        if (contents == null || contents.length() <= 0) break block18;
                        if (this.fStream != null) {
                            this.fStream.write(contents);
                        }
                        if (ProcessConsole.this.fFileOutputStream == null) break block18;
                        object = ProcessConsole.this.fFileOutputStream;
                        synchronized (object) {
                            ProcessConsole.this.fFileOutputStream.write(contents.getBytes());
                        }
                    }
                    catch (IOException e) {
                        DebugUIPlugin.log(e);
                    }
                }
            }
        }

        public IStreamMonitor getStreamMonitor() {
            return this.fStreamMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream() {
            if (this.fStreamMonitor == null) {
                return;
            }
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                this.fStreamMonitor.removeListener((IStreamListener)this);
                if (!this.fFlushed) {
                    String contents = this.fStreamMonitor.getContents();
                    this.streamAppended(contents, this.fStreamMonitor);
                }
                this.fListenerRemoved = true;
                try {
                    if (this.fStream != null) {
                        this.fStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void dispose() {
            if (!this.fListenerRemoved) {
                this.closeStream();
            }
            this.fStream = null;
            this.fStreamMonitor = null;
            this.fStreamId = null;
        }
    }

    private class InputReadJob
    extends Job {
        private IStreamsProxy streamsProxy;

        InputReadJob(IStreamsProxy streamsProxy) {
            super("Process Console Input Job");
            this.streamsProxy = streamsProxy;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                while (ProcessConsole.this.fInput != null && read >= 0) {
                    read = ProcessConsole.this.fInput.read(b);
                    if (read <= 0) continue;
                    String s = new String(b, 0, read);
                    this.streamsProxy.write(s);
                }
            }
            catch (IOException e) {
                DebugUIPlugin.log(e);
            }
            return Status.OK_STATUS;
        }
    }

    private class ConsoleLogFilePatternMatcher
    implements IPatternMatchListener {
        String fFilePath;

        public ConsoleLogFilePatternMatcher(String filePath) {
            this.fFilePath = this.escape(filePath);
        }

        private String escape(String path) {
            StringBuffer buffer = new StringBuffer(path);
            int index = buffer.indexOf("\\");
            while (index >= 0) {
                buffer.insert(index, '\\');
                index = buffer.indexOf("\\", index + 2);
            }
            return buffer.toString();
        }

        public String getPattern() {
            return this.fFilePath;
        }

        public void matchFound(PatternMatchEvent event) {
            try {
                ProcessConsole.this.addHyperlink(new ConsoleLogFileHyperlink(this.fFilePath), event.getOffset(), event.getLength());
                ProcessConsole.this.removePatternMatchListener(this);
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }

        public void connect(TextConsole console) {
        }

        public void disconnect() {
        }
    }

    private class ConsoleLogFileHyperlink
    implements IHyperlink {
        String fFilePath;

        ConsoleLogFileHyperlink(String filePath) {
            this.fFilePath = filePath;
        }

        public void linkActivated() {
            Object input;
            Path path = new Path(this.fFilePath);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile ifile = root.getFileForLocation((IPath)path);
            if (ifile == null) {
                File file = new File(this.fFilePath);
                LocalFileStorage lfs = new LocalFileStorage(file);
                input = new StorageEditorInput((IStorage)lfs, file);
            } else {
                input = new FileEditorInput(ifile);
            }
            IWorkbenchPage activePage = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true);
            }
            catch (PartInitException partInitException) {}
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput {
        private File fFile;
        private IStorage fStorage;

        public StorageEditorInput(IStorage storage, File file) {
            this.fStorage = storage;
            this.fFile = file;
        }

        public IStorage getStorage() {
            return this.fStorage;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.getStorage().getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.getStorage().getFullPath().toOSString();
        }

        public boolean equals(Object object) {
            return object instanceof StorageEditorInput && this.getStorage().equals(((StorageEditorInput)((Object)object)).getStorage());
        }

        public int hashCode() {
            return this.getStorage().hashCode();
        }

        public boolean exists() {
            return this.fFile.exists();
        }
    }
}

