/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.Pair;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LaunchShortcutExtension
implements ILaunchShortcut,
IPluginContribution {
    private ImageDescriptor fImageDescriptor = null;
    private List fPerspectives = null;
    private ILaunchShortcut fDelegate = null;
    private Set fModes = null;
    private IConfigurationElement fContextualLaunchConfigurationElement = null;
    private Expression fContextualLaunchExpr = null;
    private Expression fStandardLaunchExpr = null;
    private IConfigurationElement fConfig;
    private List fContextLabels;
    static /* synthetic */ Class class$0;

    public LaunchShortcutExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
        this.registerLaunchCommandHandlers();
    }

    private void registerLaunchCommandHandlers() {
        Iterator modes = this.getModes().iterator();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbench.getAdapter((Class)clazz);
        while (modes.hasNext()) {
            String mode = (String)modes.next();
            String id = String.valueOf(this.getId()) + "." + mode;
            LaunchCommandHandler handler = new LaunchCommandHandler(this, mode);
            handlerService.activateHandler(id, (IHandler)handler);
        }
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    public IConfigurationElement getContextualLaunchConfigurationElement() {
        IConfigurationElement[] elements;
        if (this.fContextualLaunchConfigurationElement == null && (elements = this.getConfigurationElement().getChildren("contextualLaunch")).length > 0) {
            this.fContextualLaunchConfigurationElement = elements[0];
        }
        return this.fContextualLaunchConfigurationElement;
    }

    public String getContextLabel(String mode) {
        if (this.fContextLabels == null) {
            IConfigurationElement context = this.getContextualLaunchConfigurationElement();
            if (context == null) {
                return null;
            }
            IConfigurationElement[] labels = context.getChildren("contextLabel");
            this.fContextLabels = new ArrayList(labels.length);
            int i = 0;
            while (i < labels.length) {
                this.fContextLabels.add(new Pair(labels[i].getAttribute("mode"), labels[i].getAttribute("label")));
                ++i;
            }
        }
        Iterator iter = this.fContextLabels.iterator();
        while (iter.hasNext()) {
            Pair p = (Pair)iter.next();
            if (!p.firstAsString().equals(mode)) continue;
            return p.secondAsString();
        }
        return this.getLabel();
    }

    public boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : false;
    }

    public Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement contextualLaunchElement = this.getContextualLaunchConfigurationElement();
            if (contextualLaunchElement == null) {
                return null;
            }
            IConfigurationElement[] elements = contextualLaunchElement.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    public Expression getShortcutEnablementExpression() throws CoreException {
        if (this.fStandardLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.getConfigurationElement().getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fStandardLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fStandardLaunchExpr;
    }

    public String getId() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getHelpContextId() {
        return this.getConfigurationElement().getAttribute("helpContextId");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            this.fImageDescriptor = DebugUIPlugin.getImageDescriptor(this.getConfigurationElement(), "icon");
            if (this.fImageDescriptor == null) {
                this.fImageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return this.fImageDescriptor;
    }

    public List getPerspectives() {
        if (this.fPerspectives == null) {
            IConfigurationElement[] perspectives = this.getConfigurationElement().getChildren("perspective");
            this.fPerspectives = new ArrayList(perspectives.length);
            int i = 0;
            while (i < perspectives.length) {
                this.fPerspectives.add(perspectives[i].getAttribute("id"));
                ++i;
            }
        }
        return this.fPerspectives;
    }

    protected ILaunchShortcut getDelegate() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (ILaunchShortcut)this.fConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.LaunchShortcutExtension_Error_4, LaunchConfigurationsMessages.LaunchShortcutExtension_Unable_to_use_launch_shortcut_5, e.getStatus());
            }
        }
        return this.fDelegate;
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(editor, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(selection, mode);
        }
    }

    public Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    public String getMenuPath() {
        return this.getConfigurationElement().getAttribute("path");
    }

    public String toString() {
        return this.getId();
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.fConfig.getContributor().getName();
    }

    private class LaunchCommandHandler
    extends AbstractHandler {
        private LaunchShortcutExtension fShortcut;
        private String fMode;

        public LaunchCommandHandler(LaunchShortcutExtension shortcut, String mode) {
            this.fShortcut = shortcut;
            this.fMode = mode;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            LaunchShortcutAction action = new LaunchShortcutAction(this.fMode, this.fShortcut);
            if (action.isEnabled()) {
                action.run();
            } else {
                this.fShortcut.launch((ISelection)new StructuredSelection(), this.fMode);
            }
            return null;
        }
    }
}

