/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.debug.core.hcr.MethodSearchVisitor;

public class CompilationUnitDelta {
    private CompilationUnit fCurrentAst;
    private CompilationUnit fPrevAst;
    private ASTParser fParser = null;
    private ASTMatcher fMatcher = null;
    private boolean fHasHistory = false;

    public CompilationUnitDelta(ICompilationUnit cu, long timestamp) throws CoreException {
        IFile file;
        IFileState[] states;
        if (cu.isWorkingCopy()) {
            cu = cu.getPrimary();
        }
        if ((states = (file = (IFile)cu.getUnderlyingResource()).getHistory(null)) == null || states.length <= 0) {
            return;
        }
        this.fHasHistory = true;
        IFileState found = null;
        int i = 0;
        while (i < states.length) {
            IFileState state = states[i];
            long d = state.getModificationTime();
            if (d < timestamp) {
                found = state;
                break;
            }
            ++i;
        }
        if (found == null) {
            found = states[states.length - 1];
        }
        InputStream oldContents = null;
        InputStream newContents = null;
        try {
            oldContents = found.getContents();
            newContents = file.getContents();
        }
        catch (CoreException coreException) {
            return;
        }
        this.fPrevAst = this.parse(oldContents, cu);
        this.fCurrentAst = this.parse(newContents, cu);
    }

    public boolean hasChanged(String methodName, String signature) {
        MethodDeclaration curr;
        if (!this.fHasHistory) {
            return false;
        }
        if (this.fPrevAst == null || this.fCurrentAst == null) {
            return true;
        }
        MethodSearchVisitor visitor = new MethodSearchVisitor();
        MethodDeclaration prev = this.findMethod(this.fPrevAst, visitor, methodName, signature);
        if (prev != null && (curr = this.findMethod(this.fCurrentAst, visitor, methodName, signature)) != null) {
            return !this.getMatcher().match(prev, (Object)curr);
        }
        return true;
    }

    private MethodDeclaration findMethod(CompilationUnit cu, MethodSearchVisitor visitor, String name, String signature) {
        visitor.setTargetMethod(name, signature);
        cu.accept((ASTVisitor)visitor);
        return visitor.getMatch();
    }

    private CompilationUnit parse(InputStream input, ICompilationUnit cu) {
        char[] buffer = this.readString(input);
        if (buffer != null) {
            if (this.fParser == null) {
                this.fParser = ASTParser.newParser((int)3);
            }
            this.fParser.setSource(buffer);
            this.fParser.setProject(cu.getJavaProject());
            this.fParser.setResolveBindings(true);
            this.fParser.setKind(8);
            this.fParser.setUnitName(cu.getElementName());
            return (CompilationUnit)this.fParser.createAST(null);
        }
        return null;
    }

    private ASTMatcher getMatcher() {
        if (this.fMatcher == null) {
            this.fMatcher = new ASTMatcher();
        }
        return this.fMatcher;
    }

    /*
     * Exception decompiling
     */
    private char[] readString(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 128->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

