/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public final class RefactoringHistorySerializer
implements IRefactoringHistoryListener {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void historyNotification(RefactoringHistoryEvent event) {
        IFileStore store;
        String name;
        block16: {
            block17: {
                IProject project;
                Assert.isNotNull((Object)event);
                switch (event.getEventType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        RefactoringDescriptorProxy proxy = event.getDescriptor();
                        long stamp = proxy.getTimeStamp();
                        if (stamp < 0L) return;
                        name = proxy.getProject();
                        store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings");
                        if (name == null || "".equals(name)) break block16;
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!project.isAccessible()) return;
                        if (RefactoringHistoryService.hasSharedRefactoringHistory(project)) {
                            URI uri = project.getLocationURI();
                            if (uri == null) return;
                            try {
                                try {
                                    this.processHistoryNotification(EFS.getStore((URI)uri).getChild(".refactorings"), event, name);
                                }
                                catch (CoreException exception) {
                                    RefactoringCorePlugin.log(exception);
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                try {
                                    project.refreshLocal(2, null);
                                    throw throwable;
                                }
                                catch (CoreException exception) {
                                    RefactoringCorePlugin.log(exception);
                                }
                                throw throwable;
                            }
                        }
                        break block17;
                    }
                    default: {
                        return;
                    }
                }
                {
                    Object var10_13 = null;
                }
                try {}
                catch (CoreException exception) {
                    RefactoringCorePlugin.log(exception);
                    return;
                }
                project.refreshLocal(2, null);
                return;
            }
            try {
                this.processHistoryNotification(store.getChild(name), event, name);
                return;
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
                return;
            }
        }
        try {
            this.processHistoryNotification(store.getChild(".workspace"), event, name);
            return;
        }
        catch (CoreException exception) {
            RefactoringCorePlugin.log(exception);
            return;
        }
    }

    private void processHistoryNotification(IFileStore store, RefactoringHistoryEvent event, String name) throws CoreException {
        RefactoringDescriptorProxy proxy = event.getDescriptor();
        int type = event.getEventType();
        RefactoringHistoryManager manager = new RefactoringHistoryManager(store, name);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (type == 1 || type == 4) {
            RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)monitor);
            if (descriptor != null) {
                manager.addRefactoringDescriptor(descriptor, type == 4, (IProgressMonitor)monitor);
            }
        } else if (type == 2 || type == 3) {
            manager.removeRefactoringDescriptor(proxy.getTimeStamp(), (IProgressMonitor)monitor);
        }
    }
}

