/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IUndoManagerListener;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.UndoableOperation2ChangeAdapter;

public class UndoManager2
implements IUndoManager {
    private IOperationHistory fOperationHistroy = OperationHistoryFactory.getOperationHistory();
    private IOperationHistoryListener fOperationHistoryListener;
    private boolean fIsOpen;
    private TriggeredOperations fActiveOperation;
    private ListenerList fListeners;

    public void addListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(1);
            this.fOperationHistoryListener = new OperationHistroyListener();
            this.fOperationHistroy.addOperationHistoryListener(this.fOperationHistoryListener);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.size() == 0) {
            this.fOperationHistroy.removeOperationHistoryListener(this.fOperationHistoryListener);
            this.fListeners = null;
            this.fOperationHistoryListener = null;
        }
    }

    public void aboutToPerformChange(Change change) {
        UndoableOperation2ChangeAdapter operation = new UndoableOperation2ChangeAdapter(change);
        operation.addContext(RefactoringCorePlugin.getUndoContext());
        this.fActiveOperation = new TriggeredOperations((IUndoableOperation)operation, this.fOperationHistroy);
        this.fActiveOperation.addContext(RefactoringCorePlugin.getUndoContext());
        this.fOperationHistroy.openOperation((ICompositeOperation)this.fActiveOperation, 1);
        this.fIsOpen = true;
    }

    public void changePerformed(Change change) {
        this.changePerformed(change, true);
    }

    public void changePerformed(Change change, boolean successful) {
        if (this.fIsOpen && this.fActiveOperation != null) {
            this.fOperationHistroy.closeOperation(successful, false, 1);
            this.fIsOpen = false;
        }
    }

    public void addUndo(String name, Change change) {
        if (this.fActiveOperation != null) {
            UndoableOperation2ChangeAdapter operation = (UndoableOperation2ChangeAdapter)this.fActiveOperation.getTriggeringOperation();
            operation.setUndoChange(change);
            operation.setLabel(name);
            this.fOperationHistroy.add((IUndoableOperation)this.fActiveOperation);
            this.fActiveOperation = null;
        }
    }

    public boolean anythingToUndo() {
        return this.fOperationHistroy.canUndo(RefactoringCorePlugin.getUndoContext());
    }

    public String peekUndoName() {
        IUndoableOperation op = this.fOperationHistroy.getUndoOperation(RefactoringCorePlugin.getUndoContext());
        if (op == null) {
            return null;
        }
        return op.getLabel();
    }

    public void performUndo(IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        IUndoableOperation undo = this.fOperationHistroy.getUndoOperation(RefactoringCorePlugin.getUndoContext());
        UndoableOperation2ChangeAdapter changeOperation = this.getUnwrappedOperation(undo);
        if (changeOperation == null) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoManager2_no_change, null));
        }
        if (query == null) {
            query = new NullQuery();
        }
        try {
            this.fOperationHistroy.undoOperation(undo, pm, (IAdaptable)new QueryAdapter(query));
        }
        catch (ExecutionException e) {
            this.handleException(e);
        }
    }

    public boolean anythingToRedo() {
        return this.fOperationHistroy.canRedo(RefactoringCorePlugin.getUndoContext());
    }

    public String peekRedoName() {
        IUndoableOperation op = this.fOperationHistroy.getRedoOperation(RefactoringCorePlugin.getUndoContext());
        if (op == null) {
            return null;
        }
        return op.getLabel();
    }

    public void performRedo(IValidationCheckResultQuery query, IProgressMonitor pm) throws CoreException {
        IUndoableOperation redo = this.fOperationHistroy.getRedoOperation(RefactoringCorePlugin.getUndoContext());
        UndoableOperation2ChangeAdapter changeOperation = this.getUnwrappedOperation(redo);
        if (changeOperation == null) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.UndoManager2_no_change, null));
        }
        if (query == null) {
            query = new NullQuery();
        }
        try {
            this.fOperationHistroy.redoOperation(redo, pm, (IAdaptable)new QueryAdapter(query));
        }
        catch (ExecutionException e) {
            this.handleException(e);
        }
    }

    private UndoableOperation2ChangeAdapter getUnwrappedOperation(IUndoableOperation operation) {
        IUndoableOperation result = operation;
        if (result instanceof TriggeredOperations) {
            result = ((TriggeredOperations)result).getTriggeringOperation();
        }
        if (result instanceof UndoableOperation2ChangeAdapter) {
            return (UndoableOperation2ChangeAdapter)result;
        }
        return null;
    }

    public void flush() {
        if (this.fActiveOperation != null) {
            if (this.fIsOpen) {
                this.fOperationHistroy.closeOperation(false, false, 1);
            }
            this.fOperationHistroy.add((IUndoableOperation)this.fActiveOperation);
        }
        this.fActiveOperation = null;
        this.fIsOpen = false;
        this.fOperationHistroy.dispose(RefactoringCorePlugin.getUndoContext(), true, true, false);
    }

    public void shutdown() {
    }

    private void handleException(ExecutionException e) throws CoreException {
        Throwable cause = e.getCause();
        if (cause instanceof CoreException) {
            throw (CoreException)cause;
        }
        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 4, RefactoringCoreMessages.RefactoringCorePlugin_internal_error, (Throwable)e));
    }

    private void fireAboutToPerformChange(final Change change) {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.aboutToPerformChange(UndoManager2.this, change);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    private void fireChangePerformed(final Change change) {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.changePerformed(UndoManager2.this, change);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    private void fireUndoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.undoStackChanged(UndoManager2.this);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    private void fireRedoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IUndoManagerListener listener = (IUndoManagerListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.redoStackChanged(UndoManager2.this);
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
            ++i;
        }
    }

    public boolean testHasNumberOfUndos(int number) {
        return this.fOperationHistroy.getUndoHistory(RefactoringCorePlugin.getUndoContext()).length == number;
    }

    public boolean testHasNumberOfRedos(int number) {
        return this.fOperationHistroy.getRedoHistory(RefactoringCorePlugin.getUndoContext()).length == number;
    }

    private class OperationHistroyListener
    implements IOperationHistoryListener {
        private OperationHistroyListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation op = event.getOperation();
            if (op instanceof TriggeredOperations) {
                op = ((TriggeredOperations)op).getTriggeringOperation();
            }
            UndoableOperation2ChangeAdapter changeOperation = null;
            if (op instanceof UndoableOperation2ChangeAdapter) {
                changeOperation = (UndoableOperation2ChangeAdapter)op;
            }
            if (changeOperation == null) {
                return;
            }
            Change change = changeOperation.getChange();
            switch (event.getEventType()) {
                case 1: 
                case 2: 
                case 3: {
                    UndoManager2.this.fireAboutToPerformChange(change);
                    break;
                }
                case 4: 
                case 9: 
                case 10: {
                    UndoManager2.this.fireChangePerformed(change);
                    UndoManager2.this.fireUndoStackChanged();
                    UndoManager2.this.fireRedoStackChanged();
                    break;
                }
                case 7: {
                    UndoManager2.this.fireChangePerformed(change);
                    break;
                }
                case 5: {
                    UndoManager2.this.fireUndoStackChanged();
                    UndoManager2.this.fireRedoStackChanged();
                    break;
                }
                case 8: {
                    UndoManager2.this.fireUndoStackChanged();
                    UndoManager2.this.fireRedoStackChanged();
                }
            }
        }
    }

    private static class NullQuery
    implements IValidationCheckResultQuery {
        private NullQuery() {
        }

        public boolean proceed(RefactoringStatus status) {
            return true;
        }

        public void stopped(RefactoringStatus status) {
        }
    }

    private static class QueryAdapter
    implements IAdaptable {
        private IValidationCheckResultQuery fQuery;
        static /* synthetic */ Class class$0;

        public QueryAdapter(IValidationCheckResultQuery query) {
            this.fQuery = query;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(adapter)) {
                return this.fQuery;
            }
            return null;
        }
    }
}

