/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.text.edits.UndoEdit;

public class UndoTextFileChange
extends Change {
    private String fName;
    private UndoEdit fUndo;
    private IFile fFile;
    private ContentStamp fContentStampToRestore;
    private int fSaveMode;
    private boolean fDirty;
    private BufferValidationState fValidationState;

    protected UndoTextFileChange(String name, IFile file, UndoEdit undo, ContentStamp stamp, int saveMode) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)undo);
        this.fName = name;
        this.fFile = file;
        this.fUndo = undo;
        this.fContentStampToRestore = stamp;
        this.fSaveMode = saveMode;
    }

    public int getSaveMode() {
        return this.fSaveMode;
    }

    public String getName() {
        return this.fName;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.fSaveMode);
    }

    public Object getModifiedElement() {
        return this.fFile;
    }

    public Object[] getAffectedObjects() {
        Object modifiedElement = this.getModifiedElement();
        if (modifiedElement == null) {
            return null;
        }
        return new Object[]{modifiedElement};
    }

    public void initializeValidationData(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        this.fValidationState = BufferValidationState.create(this.fFile);
        pm.worked(1);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath());
        this.fDirty = buffer != null && buffer.isDirty();
        RefactoringStatus result = this.fValidationState.isValid(this.needsSaving());
        pm.worked(1);
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        block7: {
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            pm.beginTask("", 2);
            ITextFileBuffer buffer = null;
            try {
                manager.connect(this.fFile.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                buffer = manager.getTextFileBuffer(this.fFile.getFullPath());
                IDocument document = buffer.getDocument();
                ContentStamp currentStamp = ContentStamps.get(this.fFile, document);
                UndoEdit redo = this.fUndo.apply(document, 1);
                boolean success = ContentStamps.set(document, this.fContentStampToRestore);
                if (this.needsSaving()) {
                    buffer.commit(pm, false);
                    if (!success) {
                        ContentStamps.set(this.fFile, this.fContentStampToRestore);
                    }
                }
                change = this.createUndoChange(redo, currentStamp);
                Object var8_10 = null;
                if (buffer == null) break block7;
            }
            catch (BadLocationException e) {
                try {
                    throw Changes.asCoreException(e);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var8_11 = null;
                        if (buffer == null) break block8;
                        manager.disconnect(this.fFile.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    throw throwable;
                }
            }
            manager.disconnect(this.fFile.getFullPath(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        return change;
    }

    public void dispose() {
        this.fValidationState.dispose();
    }

    private boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }
}

