/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CTable;
import org.eclipse.swt.internal.swing.CTableItem;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    public CTableItem handle;
    Table parent;
    Image[] images;
    boolean cached;

    public TableItem(Table table, int n2) {
        this(table, n2, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n2, int n3) {
        this(table, n2, n3, true);
    }

    TableItem(Table table, int n2, int n3, boolean bl) {
        super(table, n2);
        this.parent = table;
        this.handle = this.createHandle();
        if (bl) {
            table.createItem(this, n3);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    CTableItem createHandle() {
        return CTableItem.Factory.newInstance(this, this.style);
    }

    void clear() {
        int n2;
        this.text = "";
        this.image = null;
        this.images = null;
        this.handle.setBackground(null);
        this.handle.setForeground(null);
        this.handle.setFont(null);
        this.handle.setChecked(false);
        this.handle.setGrayed(false);
        int n3 = this.parent.getColumnCount();
        for (n2 = 0; n2 < n3; ++n2) {
            CTableItem.TableItemObject tableItemObject = this.handle.getTableItemObject(n3);
            tableItemObject.setText(null);
            tableItemObject.setBackground(null);
            tableItemObject.setForeground(null);
            tableItemObject.setFont(null);
            tableItemObject.setIcon(null);
        }
        n2 = this.parent.indexOf(this);
        ((CTable)((Object)this.parent.handle)).getModel().fireTableRowsUpdated(n2, n2);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public org.eclipse.swt.graphics.Color getBackground() {
        this.checkWidget();
        Color color = this.handle.getBackground();
        if (color == null) {
            return this.parent.getBackground();
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Color getBackground(int n2) {
        this.checkWidget();
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getBackground();
        }
        Color color = this.handle.getTableItemObject(n2).getBackground();
        if (color == null) {
            if (n2 != 0) {
                return this.getBackground();
            }
            return org.eclipse.swt.graphics.Color.swing_new(this.display, this.parent.handle.getBackground());
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
        }
        return this.getBounds(0);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Rectangle rectangle = ((CTable)((Object)this.parent.handle)).getCellRect(this.parent.indexOf(this), n2, false);
        Point point = this.parent.getInternalOffset();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x + point.x, rectangle.y + point.y, rectangle.width, rectangle.height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.handle.isChecked();
    }

    public org.eclipse.swt.graphics.Font getFont() {
        return this.getFont(0);
    }

    public org.eclipse.swt.graphics.Font getFont(int n2) {
        this.checkWidget();
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getFont();
        }
        Font font = this.handle.getTableItemObject(n2).getFont();
        if (font == null) {
            if (n2 != 0) {
                return this.getFont();
            }
            return org.eclipse.swt.graphics.Font.swing_new(this.display, this.parent.handle.getFont());
        }
        return org.eclipse.swt.graphics.Font.swing_new(this.display, font);
    }

    public org.eclipse.swt.graphics.Color getForeground() {
        this.checkWidget();
        Color color = this.handle.getForeground();
        if (color == null) {
            return this.parent.getForeground();
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public org.eclipse.swt.graphics.Color getForeground(int n2) {
        this.checkWidget();
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return this.getForeground();
        }
        Color color = this.handle.getTableItemObject(n2).getForeground();
        if (color == null) {
            if (n2 != 0) {
                return this.getBackground();
            }
            return org.eclipse.swt.graphics.Color.swing_new(this.display, this.parent.handle.getForeground());
        }
        return org.eclipse.swt.graphics.Color.swing_new(this.display, color);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.handle.isGrayed();
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && 0 <= n2 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public org.eclipse.swt.graphics.Rectangle getImageBounds(int n2) {
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = this.parent.indexOf(this)) == -1) {
            return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
        }
        int n4 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n4 - 1) {
            return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = ((CTable)((Object)this.parent.handle)).getImageBounds(n3, n2);
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Utils.notImplemented();
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return "";
        }
        return this.handle.getTableItemObject(n2).getText();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.images = null;
    }

    public void setBackground(org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setBackground(color == null ? null : color.handle);
        int n2 = this.parent.indexOf(this);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableRowsUpdated(n2, n2);
    }

    public void setBackground(int n2, org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTableItemObject(n2).setBackground(color == null ? null : color.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), n2);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        this.handle.setChecked(bl);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), 0);
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setFont(font == null ? null : font.handle);
        int n2 = this.parent.indexOf(this);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableRowsUpdated(n2, n2);
    }

    public void setFont(int n2, org.eclipse.swt.graphics.Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTableItemObject(n2).setFont(font == null ? null : font.handle);
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), n2);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.adjustColumnWidth();
    }

    public void setForeground(org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.handle.setForeground(color == null ? null : color.handle);
        int n2 = this.parent.indexOf(this);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableRowsUpdated(n2, n2);
    }

    public void setForeground(int n2, org.eclipse.swt.graphics.Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        this.handle.getTableItemObject(n2).setForeground(color == null ? null : color.handle);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), n2);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        this.handle.setGrayed(bl);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), 0);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            this.setImage(i2, imageArray[i2]);
        }
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (this.images == null && n2 != 0) {
            this.images = new Image[n3];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            this.images[n2] = image;
        }
        this.handle.getTableItemObject(n2).setIcon(image != null ? new ImageIcon(image.handle) : null);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(n2, n2);
        this.parent.adjustColumnWidth();
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        Utils.notImplemented();
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string == null) continue;
            this.setText(i2, string);
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n2 || n2 > n3 - 1) {
            return;
        }
        if (n2 == 0) {
            super.setText(string);
        }
        this.handle.getTableItemObject(n2).setText(string);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        ((CTable)((Object)this.parent.handle)).getModel().fireTableCellUpdated(this.parent.indexOf(this), n2);
        this.parent.adjustColumnWidth();
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

