/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import javax.swing.ImageIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CTabFolder;
import org.eclipse.swt.internal.swing.CTabItem;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    Container handle;

    public TabItem(TabFolder tabFolder, int n2) {
        super(tabFolder, n2);
        this.parent = tabFolder;
        this.handle = this.createHandle();
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n2, int n3) {
        super(tabFolder, n2);
        this.parent = tabFolder;
        this.handle = this.createHandle();
        tabFolder.createItem(this, n3);
    }

    Container createHandle() {
        return (Container)((Object)CTabItem.Factory.newInstance(this, this.style));
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int n2 = this.parent.indexOf(this);
        if (n2 == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
            this.handle.remove(this.control.handle);
        }
        this.control = control;
        if (control != null) {
            this.handle.add((Component)control.handle, "Center");
        }
        this.handle.invalidate();
        this.handle.validate();
        this.handle.repaint();
    }

    public void setImage(Image image) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setImage(image);
        ((CTabFolder)((Object)this.parent.handle)).setIconAt(n2, new ImageIcon(image.handle));
    }

    public void setText(String string) {
        char c2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setText(string);
        int n3 = this.findMnemonicIndex(string);
        CTabFolder cTabFolder = (CTabFolder)((Object)this.parent.handle);
        if (n3 < 0) {
            c2 = '\u0000';
            cTabFolder.setTitleAt(n2, string);
        } else {
            c2 = string.charAt(n3);
            cTabFolder.setTitleAt(n2, string.substring(0, n3 - 1) + string.substring(n3));
        }
        cTabFolder.setMnemonicAt(n2, c2);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        ((CTabFolder)((Object)this.parent.handle)).setToolTipTextAt(this.parent.indexOf(this), Utils.convertStringToHTML(this.toolTipText));
    }
}

