/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.event.AdjustmentEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.swing.CSlider;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    public Slider(Composite composite, int n2) {
        super(composite, Slider.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return Slider.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    Container createHandle() {
        return (Container)((Object)CSlider.Factory.newInstance(this, this.style));
    }

    public int getIncrement() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getUnitIncrement();
    }

    public int getMaximum() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getBlockIncrement();
    }

    public int getSelection() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getValue();
    }

    public int getThumb() {
        this.checkWidget();
        return ((CSlider)((Object)this.handle)).getVisibleAmount();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        ((CSlider)((Object)this.handle)).setUnitIncrement(n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CSlider)((Object)this.handle)).setMaximum(n2);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CSlider)((Object)this.handle)).setMinimum(n2);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        ((CSlider)((Object)this.handle)).setBlockIncrement(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        ((CSlider)((Object)this.handle)).setValue(n2);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        ((CSlider)((Object)this.handle)).setVisibleAmount(n2);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        CSlider cSlider = (CSlider)((Object)this.handle);
        cSlider.setValues(n2, n5, n3, n4);
        cSlider.setUnitIncrement(n6);
        cSlider.setBlockIncrement(n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 601: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 601: {
                    Event event = new Event();
                    event.detail = 1;
                    switch (((AdjustmentEvent)aWTEvent).getAdjustmentType()) {
                        case 3: {
                            event.detail = 0x1000006;
                            break;
                        }
                        case 4: {
                            event.detail = 0x1000005;
                            break;
                        }
                        case 2: {
                            event.detail = 0x1000002;
                            break;
                        }
                        case 1: {
                            event.detail = 0x1000001;
                        }
                    }
                    this.sendEvent(13, event);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

