/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    Image image;
    String text;

    public Label(Composite composite, int n2) {
        super(composite, Label.checkStyle(n2));
    }

    static int checkStyle(int n2) {
        if (((n2 |= 0x80000) & 2) != 0) {
            n2 = Label.checkBits(n2, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n2, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        this.checkWidget();
        if ((this.style & 0x40) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Label.this.isAdjustingSize = true;
                }
            });
            Dimension dimension = this.handle.getSize();
            if (n2 == -1) {
                this.handle.setSize(((CLabel)((Object)this.handle)).getPreferredWidth(), 0);
            } else {
                this.handle.setSize(n2, 0);
            }
            Point point = super.computeSize(n2, n3, bl);
            this.handle.setSize(dimension);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Label.this.isAdjustingSize = false;
                }
            });
            return point;
        }
        return super.computeSize(n2, n3, bl);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state |= 0x100;
    }

    Container createHandle() {
        return (Container)((Object)CLabel.Factory.newInstance(this, this.style));
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text == null ? "" : this.text;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        if ((n2 & 0x4000) != 0) {
            ((CLabel)((Object)this.handle)).setAlignment(2);
        } else if ((n2 & 0x20000) != 0) {
            ((CLabel)((Object)this.handle)).setAlignment(4);
        } else if ((n2 & 0x1000000) != 0) {
            ((CLabel)((Object)this.handle)).setAlignment(0);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        ImageIcon imageIcon = null;
        if (image != null && image.handle != null) {
            imageIcon = new ImageIcon(image.handle);
        }
        ((CLabel)((Object)this.handle)).setIcon(imageIcon);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        int n2 = this.findMnemonicIndex(string);
        if (n2 > 0) {
            String string2 = string.substring(0, n2 - 1).replaceAll("&&", "&");
            string = string2 + string.substring(n2).replaceAll("&&", "&");
            n2 -= n2 - 1 - string2.length();
            --n2;
        } else {
            string = string.replaceAll("&&", "&");
        }
        ((CLabel)((Object)this.handle)).setText(string, n2);
    }
}

