/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.swing.JFontChooser;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n2) {
        super(shell, n2);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        Window window = (Window)this.getParent().handle;
        JFontChooser jFontChooser = window instanceof Frame ? new JFontChooser((Frame)window) : new JFontChooser((java.awt.Dialog)window);
        if (this.rgb != null) {
            jFontChooser.setDefaultColor(new Color(this.rgb.red, this.rgb.green, this.rgb.blue));
        }
        int n2 = this.getParent().getDisplay().getDPI().x;
        if (this.fontData != null) {
            Font font;
            int n3 = Math.round((float)(this.fontData.getHeight() * n2) / 72.0f);
            int n4 = this.fontData.getStyle();
            n4 = ((n4 & 2) != 0 ? 2 : 0) | ((n4 & 1) != 0 ? 1 : 0);
            if (this.fontData.data != null) {
                HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(this.fontData.data);
                hashMap.put(TextAttribute.FAMILY, this.fontData.getName());
                hashMap.put(TextAttribute.POSTURE, (n4 & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                hashMap.put(TextAttribute.WEIGHT, (n4 & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                font = new Font(hashMap);
            } else {
                font = new Font(this.fontData.getName(), n4, n3);
            }
            jFontChooser.setDefaultFont(font);
        }
        jFontChooser.setModal(true);
        jFontChooser.setVisible(true);
        Font font = jFontChooser.getNewFont();
        if (font == null) {
            return null;
        }
        Color color = jFontChooser.getNewColor();
        int n5 = Math.round((float)font.getSize() * 72.0f / (float)n2);
        int n6 = font.getStyle();
        this.fontData = new FontData(font.getName(), n5, 0 | ((n6 & 2) != 0 ? 2 : 0) | ((n6 & 1) != 0 ? 1 : 0));
        this.fontData.data = font.getAttributes();
        this.rgb = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

