/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CExpandBar;
import org.eclipse.swt.internal.swing.CExpandItem;
import org.eclipse.swt.internal.swing.JExpandPane;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ArrayList itemList;

    public ExpandBar(Composite composite, int n2) {
        super(composite, ExpandBar.checkStyle(n2));
    }

    Control[] _getChildren() {
        Component[] componentArray = ((CControl)((Object)this.handle)).getClientArea().getComponents();
        if (componentArray.length == 0) {
            return new Control[0];
        }
        ArrayList<Control> arrayList = new ArrayList<Control>(componentArray.length);
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Control control;
            Component component = componentArray[i2];
            if (!(component instanceof JExpandPane.JExpandPaneItem) || (component = ((JExpandPane.JExpandPaneItem)component).getComponent()) == null || !(component instanceof CExpandItem) || (control = this.display.getControl(component = ((CExpandItem)((Object)component)).getContent())) == null || control == this) continue;
            arrayList.add(control);
        }
        return arrayList.toArray(new Control[0]);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        return (n2 &= 0xFFFFFEFF) | 0x40000;
    }

    boolean autoAddChildren() {
        return false;
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFFFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CExpandBar.Factory.newInstance(this, this.style));
    }

    void createItem(ExpandItem expandItem, int n2, int n3) {
        int n4 = this.getItemCount();
        if (0 > n3 || n3 > n4) {
            this.error(6);
        }
        this.itemList.add(n3, expandItem);
        ((CExpandBar)((Object)this.handle)).insertExpandPaneItem(null, null, expandItem.handle, n3);
        this.handle.invalidate();
        this.handle.validate();
    }

    void createWidget() {
        super.createWidget();
        this.itemList = new ArrayList();
    }

    void destroyItem(ExpandItem expandItem) {
        int n2 = this.indexOf(expandItem);
        if (n2 != -1) {
            ((CExpandBar)((Object)this.handle)).removeExpandPaneItem(expandItem.handle);
            this.handle.invalidate();
            this.handle.validate();
            this.handle.repaint();
        }
        this.itemList = null;
    }

    public ExpandItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return (ExpandItem)this.itemList.get(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList.size();
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        return this.itemList.toArray(new ExpandItem[0]);
    }

    public int getSpacing() {
        this.checkWidget();
        return ((CExpandBar)((Object)this.handle)).getSpacing();
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.itemList.get(i2) != expandItem) continue;
            return i2;
        }
        return -1;
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        int n4 = ((CExpandBar)((Object)this.handle)).getVerticalScrollBar().getPreferredSize().width;
        return new Point(dimension.width + n4, dimension.height);
    }

    void releaseChildren(boolean bl) {
        if (this.itemList != null) {
            int n2 = this.getItemCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                ExpandItem expandItem = (ExpandItem)this.itemList.get(i2);
                if (expandItem.isDisposed()) continue;
                expandItem.release(false);
            }
            this.itemList = null;
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    public void setSpacing(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        ((CExpandBar)((Object)this.handle)).setSpacing(n2);
    }
}

